/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.thread.monitor;

import io.nuls.block.model.ChainContext;
import io.nuls.block.rpc.call.ConsensusCall;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.rpc.call.TransactionCall;
import io.nuls.block.thread.BlockSynchronizer;
import io.nuls.block.thread.monitor.BaseMonitor;
import io.nuls.common.ConfigBean;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.rpc.util.NulsDateUtils;

public class NetworkResetMonitor
extends BaseMonitor {
    private static final NetworkResetMonitor INSTANCE = new NetworkResetMonitor();

    public static NetworkResetMonitor getInstance() {
        return INSTANCE;
    }

    @Override
    protected void process(int chainId, ChainContext context, NulsLogger commonLog) {
        ConfigBean parameters = context.getParameters();
        long reset = parameters.getResetTime();
        long time = context.getLatestBlock().getHeader().getTime() * 1000L;
        long currentTime = NulsDateUtils.getCurrentTimeMillis();
        commonLog.debug("chainId-" + chainId + ",currentTime-" + currentTime + ",blockTime-" + time + ",diffrence-" + (currentTime - time));
        if (currentTime - time > reset) {
            commonLog.info("chainId-" + chainId + ",NetworkReset!");
            NetworkCall.resetNetwork(chainId);
            ConsensusCall.notice(chainId, 0);
            TransactionCall.notice(chainId, 0);
            BlockSynchronizer.syn(chainId);
        }
    }
}

