/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.thread.monitor;

import io.nuls.block.constant.StatusEnum;
import io.nuls.block.model.ChainContext;
import io.nuls.block.rpc.call.ConsensusCall;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.rpc.call.TransactionCall;
import io.nuls.block.thread.BlockSynchronizer;
import io.nuls.block.thread.monitor.BaseMonitor;
import io.nuls.common.ConfigBean;
import io.nuls.core.log.logback.NulsLogger;
import java.util.List;

public class NodesMonitor
extends BaseMonitor {
    private static final NodesMonitor INSTANCE = new NodesMonitor();

    public static NodesMonitor getInstance() {
        return INSTANCE;
    }

    private NodesMonitor() {
        super(List.of(StatusEnum.WAITING));
    }

    @Override
    protected void process(int chainId, ChainContext context, NulsLogger commonLog) {
        ConfigBean parameters = context.getParameters();
        byte minNodeAmount = parameters.getMinNodeAmount();
        int size = NetworkCall.getAvailableNodes(chainId).size();
        if (size < minNodeAmount && StatusEnum.RUNNING.equals((Object)context.getStatus())) {
            commonLog.info("chainId-" + chainId + ", AvailableNodes not enough!");
            ConsensusCall.notice(chainId, 0);
            TransactionCall.notice(chainId, 0);
            context.setStatus(StatusEnum.WAITING);
        }
        if (size >= minNodeAmount && StatusEnum.WAITING.equals((Object)context.getStatus())) {
            commonLog.info("chainId-" + chainId + ", AvailableNodes enough!");
            BlockSynchronizer.syn(chainId);
        }
    }
}

