/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.thread.monitor;

import io.nuls.block.constant.StatusEnum;
import io.nuls.block.manager.BlockChainManager;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.Chain;
import io.nuls.block.model.ChainContext;
import io.nuls.block.thread.monitor.BaseMonitor;
import io.nuls.common.ConfigBean;
import io.nuls.core.log.logback.NulsLogger;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.StampedLock;

public class StorageSizeMonitor
extends BaseMonitor {
    private static final StorageSizeMonitor INSTANCE = new StorageSizeMonitor();

    public static StorageSizeMonitor getInstance() {
        return INSTANCE;
    }

    @Override
    protected void process(int chainId, ChainContext context, NulsLogger commonLog) {
        ConfigBean parameters = ContextManager.getContext(chainId).getParameters();
        int heightRange = parameters.getHeightRange();
        byte orphanChainMaxAge = parameters.getOrphanChainMaxAge();
        context.setStatus(StatusEnum.STORAGE_CLEANING);
        this.forkChainsCleaner(chainId, heightRange, context);
        this.orphanChainsCleaner(chainId, heightRange, context, orphanChainMaxAge);
        int cacheSize = parameters.getCacheSize();
        this.dbSizeCleaner(chainId, context, cacheSize);
        context.setStatus(StatusEnum.RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbSizeCleaner(Integer chainId, ChainContext context, int cacheSize) {
        StampedLock lock = context.getLock();
        long stamp = lock.tryOptimisticRead();
        NulsLogger logger = context.getLogger();
        try {
            while (true) {
                if (stamp != 0L) {
                    int actualSize = BlockChainManager.getForkChains(chainId).stream().mapToInt(e -> e.getHashList().size()).sum();
                    logger.debug("cacheSize:" + cacheSize + ", actualSize:" + (actualSize += BlockChainManager.getOrphanChains(chainId).stream().mapToInt(e -> e.getHashList().size()).sum()));
                    if (lock.validate(stamp)) {
                        if (actualSize <= cacheSize) {
                            break;
                        }
                        if ((stamp = lock.tryConvertToWriteLock(stamp)) != 0L) {
                            while (actualSize > cacheSize) {
                                SortedSet<Chain> forkChains;
                                logger.info("before clear, chainId:" + chainId + ", cacheSize:" + cacheSize + ", actualSize:" + actualSize);
                                SortedSet<Chain> orphanChains = BlockChainManager.getOrphanChains(chainId);
                                if (!orphanChains.isEmpty()) {
                                    Chain chain = orphanChains.first();
                                    BlockChainManager.deleteOrphanChain(chainId, chain);
                                }
                                if (!(forkChains = BlockChainManager.getForkChains(chainId)).isEmpty()) {
                                    Chain chain = forkChains.first();
                                    BlockChainManager.deleteForkChain(chainId, chain, true);
                                }
                                actualSize = BlockChainManager.getForkChains(chainId).stream().mapToInt(e -> e.getHashList().size()).sum();
                                logger.info("after clear, chainId:" + chainId + ", cacheSize:" + cacheSize + ", actualSize:" + (actualSize += BlockChainManager.getOrphanChains(chainId).stream().mapToInt(e -> e.getHashList().size()).sum()));
                            }
                            break;
                        }
                    }
                }
                stamp = lock.writeLock();
            }
        }
        finally {
            if (StampedLock.isWriteLockStamp(stamp)) {
                lock.unlockWrite(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forkChainsCleaner(int chainId, int heightRange, ChainContext context) {
        StampedLock lock = context.getLock();
        long stamp = lock.tryOptimisticRead();
        NulsLogger logger = context.getLogger();
        try {
            while (true) {
                if (stamp != 0L) {
                    SortedSet<Chain> forkChains = BlockChainManager.getForkChains(chainId);
                    if (lock.validate(stamp)) {
                        if (forkChains.isEmpty()) {
                            break;
                        }
                        if ((stamp = lock.tryConvertToWriteLock(stamp)) != 0L) {
                            Chain masterChain = BlockChainManager.getMasterChain(chainId);
                            long latestHeight = masterChain.getEndHeight();
                            TreeSet<Chain> deleteSet = new TreeSet<Chain>(Chain.COMPARATOR);
                            for (Chain forkChain : forkChains) {
                                if (latestHeight - forkChain.getStartHeight() <= (long)heightRange && !masterChain.getHashList().contains(forkChain.getEndHash())) continue;
                                deleteSet.add(forkChain);
                            }
                            for (Chain chain : deleteSet) {
                                BlockChainManager.deleteForkChain(chainId, chain, true);
                                logger.info("remove fork chain, chain:" + chain);
                            }
                            break;
                        }
                    }
                }
                stamp = lock.writeLock();
            }
        }
        finally {
            if (StampedLock.isWriteLockStamp(stamp)) {
                lock.unlockWrite(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orphanChainsCleaner(int chainId, int heightRange, ChainContext context, int orphanChainMaxAge) {
        StampedLock lock = context.getLock();
        long stamp = lock.tryOptimisticRead();
        NulsLogger logger = context.getLogger();
        try {
            while (true) {
                if (stamp != 0L) {
                    SortedSet<Chain> orphanChains = BlockChainManager.getOrphanChains(chainId);
                    if (lock.validate(stamp)) {
                        if (orphanChains.isEmpty()) {
                            break;
                        }
                        if ((stamp = lock.tryConvertToWriteLock(stamp)) != 0L) {
                            Chain masterChain = BlockChainManager.getMasterChain(chainId);
                            long latestHeight = masterChain.getEndHeight();
                            TreeSet<Chain> deleteSet = new TreeSet<Chain>(Chain.COMPARATOR);
                            for (Chain orphanChain : orphanChains) {
                                if (Math.abs(orphanChain.getStartHeight() - latestHeight) <= (long)heightRange && orphanChain.getAge().get() <= orphanChainMaxAge) continue;
                                deleteSet.add(orphanChain);
                            }
                            for (Chain chain : deleteSet) {
                                BlockChainManager.deleteOrphanChain(chainId, chain);
                                logger.info("remove orphan chain, chain:" + chain);
                            }
                            break;
                        }
                    }
                }
                stamp = lock.writeLock();
            }
        }
        finally {
            if (StampedLock.isWriteLockStamp(stamp)) {
                lock.unlockWrite(stamp);
            }
        }
    }
}

