/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.rpc.call.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.chain.info.CmConstants;
import io.nuls.chain.info.CmErrorCode;
import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.dto.AccountBalance;
import io.nuls.chain.model.dto.ChainAssetTotalCirculate;
import io.nuls.chain.model.po.Asset;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.rpc.call.RpcService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.chain.util.ResponseUtil;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Service;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class RpcServiceImpl
implements RpcService {
    @Autowired
    ChainService chainService;

    @Override
    public String getCrossChainSeeds() {
        String seeds = "";
        try {
            Map<String, Object> rtMap;
            HashMap map = new HashMap();
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_getSeeds", map);
            if (response.isSuccess() && null != (rtMap = ResponseUtil.getResultMap(response, "nw_getSeeds"))) {
                seeds = String.valueOf(rtMap.get("seedsIps"));
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
        }
        return seeds;
    }

    @Override
    public long getMainNetMagicNumber() {
        try {
            Map<String, Object> rtMap;
            HashMap map = new HashMap();
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_getMainMagicNumber", map);
            if (response.isSuccess() && null != (rtMap = ResponseUtil.getResultMap(response, "nw_getMainMagicNumber"))) {
                return Long.valueOf(rtMap.get("value").toString());
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            throw new RuntimeException(e);
        }
        return 0L;
    }

    @Override
    public ErrorCode newTx(Transaction tx) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chainId", CmRuntimeInfo.getMainIntChainId());
            params.put("tx", RPCUtil.encode((byte[])tx.serialize()));
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_newTx", params);
            if (!cmdResp.isSuccess()) {
                return ErrorCode.init((String)cmdResp.getResponseErrorCode());
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return CmErrorCode.ERROR_TX_REG_RPC;
        }
        return null;
    }

    @Override
    public boolean createCrossGroup(BlockChain blockChain) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("chainId", blockChain.getChainId());
            map.put("magicNumber", blockChain.getMagicNumber());
            map.put("maxOut", "");
            map.put("maxIn", "");
            map.put("minAvailableCount", blockChain.getMinAvailableNodeNum());
            map.put("seedIps", "");
            map.put("isCrossGroup", "true");
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_createNodeGroup", map);
            LoggerUtil.logger().info("Notification Network Module:createCrossGroup success");
            return response.isSuccess();
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return false;
        }
    }

    @Override
    public boolean destroyCrossGroup(BlockChain blockChain) {
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("chainId", blockChain.getChainId());
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_delNodeGroup", map);
            LoggerUtil.logger().info("Notification Network Module:destroyCrossGroup success");
            return response.isSuccess();
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return false;
        }
    }

    @Override
    public boolean requestCrossIssuingAssets(int chainId, String assetIds) {
        try {
            LoggerUtil.logger().debug("requestCrossIssuingAssets chainId={},assetIds={}", new Object[]{chainId, assetIds});
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("chainId", chainId);
            map.put("assetIds", assetIds);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CC.abbr, (String)"getFriendChainCirculate", map);
            return response.isSuccess();
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return false;
        }
    }

    @Override
    public boolean crossChainRegisterChange(int chainId) {
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("chainId", chainId);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CC.abbr, (String)"crossChainRegisterChange", map, (long)1000L);
            LoggerUtil.logger().info("Notification Cross Chain Protocol Module:crossChainRegisterChange success");
            return response.isSuccess();
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return false;
        }
    }

    @Override
    public boolean registerCrossChain(List<BlockChain> blockChains) {
        for (BlockChain blockChain : blockChains) {
            if (this.registerCrossChain(blockChain)) continue;
            return false;
        }
        LoggerUtil.logger().info("Notification Cross Chain Protocol Module:cmd=registerCrossChain all success size={}", new Object[]{blockChains.size()});
        return true;
    }

    @Override
    public boolean registerCrossChain(BlockChain blockChain) {
        try {
            Map<String, Object> map = this.chainService.getBlockAssetsInfo(blockChain);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CC.abbr, (String)"registerCrossChain", map);
            if (!response.isSuccess()) {
                LoggerUtil.logger().info("Notification Cross Chain Protocol Module:cmd=registerCrossChain fail chainId={},error={}", new Object[]{blockChain.getChainId(), response.getResponseComment()});
                return false;
            }
            LoggerUtil.logger().info("Notification Cross Chain Protocol Module:cmd=registerCrossChain success chainId={}", new Object[]{blockChain.getChainId()});
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean registerCrossAsset(List<Asset> assets, long registerTime) {
        for (Asset asset : assets) {
            if (this.registerCrossAsset(asset, registerTime)) continue;
            return false;
        }
        LoggerUtil.logger().info("Notification Cross Chain Protocol Module:cmd=registerCrossAsset all success size={}", new Object[]{assets.size()});
        return true;
    }

    @Override
    public boolean registerCrossAsset(Asset asset, long registerTime) {
        try {
            HashMap<String, Object> assetMap = new HashMap<String, Object>();
            assetMap.put("chainId", asset.getChainId());
            assetMap.put("assetId", asset.getAssetId());
            assetMap.put("symbol", asset.getSymbol());
            assetMap.put("assetName", asset.getAssetName());
            assetMap.put("usable", asset.isAvailable());
            assetMap.put("decimalPlaces", asset.getDecimalPlaces());
            assetMap.put("time", registerTime);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CC.abbr, (String)"registerAsset", assetMap);
            if (!response.isSuccess()) {
                LoggerUtil.logger().info("Notification Cross Chain Protocol Module:cmd=registerCrossAsset fail chainId={},assetId={},error={}", new Object[]{asset.getChainId(), asset.getAssetId(), response.getResponseComment()});
                return false;
            }
            LoggerUtil.logger().info("Notification Cross Chain Protocol Module:cmd=registerCrossAsset success chainId={},assetId={}", new Object[]{asset.getChainId(), asset.getAssetId()});
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean cancelCrossChain(List<Map<String, Object>> chainAssetIds, long cancelTime) {
        for (Map<String, Object> map : chainAssetIds) {
            if (this.cancelCrossChain(map, cancelTime)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean cancelCrossChain(Map<String, Object> chainAssetId, long cancelTime) {
        try {
            chainAssetId.put("time", cancelTime);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CC.abbr, (String)"cancelCrossChain", chainAssetId);
            if (!response.isSuccess()) {
                LoggerUtil.logger().info("Notification Cross Chain Protocol Module:cmd=cancelCrossChain fail chainId={},assetId={},error={}", new Object[]{chainAssetId.get("chainId"), chainAssetId.get("assetId"), response.getResponseComment()});
                return false;
            }
            LoggerUtil.logger().info("Notification Cross Chain Protocol Module:cmd=cancelCrossChain success. chainId={},assetId={}", new Object[]{chainAssetId.get("chainId"), chainAssetId.get("assetId")});
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean addAcAddressPrefix(List<Map<String, Object>> prefixList) {
        try {
            if (prefixList.size() == 0) {
                return true;
            }
            HashMap<String, List<Map<String, Object>>> param = new HashMap<String, List<Map<String, Object>>>();
            param.put("prefixList", prefixList);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_addAddressPrefix", param, (long)1000L);
            if (!response.isSuccess()) {
                LoggerUtil.logger().info("noticeACModule address prefix addition failed");
                return false;
            }
            LoggerUtil.logger().info("noticeACModule address prefix added successfully");
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return false;
        }
        return true;
    }

    @Override
    public ErrorCode getCoinData(String address, AccountBalance accountBalance) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("chainId", CmRuntimeInfo.getMainIntChainId());
            map.put("assetChainId", CmRuntimeInfo.getMainIntChainId());
            map.put("assetId", CmRuntimeInfo.getMainIntAssetId());
            map.put("address", address);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"getBalanceNonce", map);
            if (!response.isSuccess()) {
                return ErrorCode.init((String)response.getResponseErrorCode());
            }
            Map<String, Object> resultMap = ResponseUtil.getResultMap(response, "getBalanceNonce");
            if (null != resultMap) {
                String available = resultMap.get("available").toString();
                byte[] nonce = RPCUtil.decode((String)resultMap.get("nonce").toString());
                accountBalance.setNonce(nonce);
                accountBalance.setAvailable(available);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error("get AccountBalance error....");
            LoggerUtil.logger().error(e);
            return CmErrorCode.ERROR_LEDGER_BALANCE_RPC;
        }
        return null;
    }

    @Override
    public List<ChainAssetTotalCirculate> getLgAssetsById(int chainId, String assetIds) {
        ArrayList<ChainAssetTotalCirculate> list = new ArrayList<ChainAssetTotalCirculate>();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("chainId", chainId);
            map.put("assetIds", assetIds);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"getAssetsById", map);
            if (response.isSuccess()) {
                Map<String, Object> assetsMap = ResponseUtil.getResultMap(response, "getAssetsById");
                List assets = (List)assetsMap.get("assets");
                for (Map asset : assets) {
                    ChainAssetTotalCirculate chainAssetTotalCirculate = new ChainAssetTotalCirculate();
                    chainAssetTotalCirculate.setChainId(chainId);
                    chainAssetTotalCirculate.setFreeze(new BigInteger(asset.get("freeze").toString()));
                    chainAssetTotalCirculate.setAvailableAmount(new BigInteger(asset.get("availableAmount").toString()));
                    chainAssetTotalCirculate.setAssetId(Integer.valueOf(asset.get("assetId").toString()));
                    list.add(chainAssetTotalCirculate);
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error("get AccountBalance error....");
            LoggerUtil.logger().error(e);
        }
        return list;
    }

    @Override
    public String getChainPackerInfo(int chainId) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("chainId", chainId);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CS.abbr, (String)"cs_getSeedNodeInfo", map);
            if (response.isSuccess()) {
                Map<String, Object> packerMap = ResponseUtil.getResultMap(response, "cs_getSeedNodeInfo");
                List packerList = (List)packerMap.get("packAddressList");
                for (String packer : packerList) {
                    stringBuffer.append(packer);
                    stringBuffer.append(",");
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
        }
        return "";
    }

    public HashMap accountValid(int chainId, String address, String password) throws NulsException {
        try {
            HashMap<String, Object> callParams = new HashMap<String, Object>(4);
            callParams.put("chainId", chainId);
            callParams.put("address", address);
            callParams.put("password", password);
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_getPriKeyByAddress", callParams);
            if (!cmdResp.isSuccess()) {
                throw new NulsException(CmErrorCode.ERROR_ACCOUNT_VALIDATE);
            }
            HashMap callResult = (HashMap)((HashMap)cmdResp.getResponseData()).get("ac_getPriKeyByAddress");
            if (callResult == null || callResult.size() == 0 || !((Boolean)callResult.get("valid")).booleanValue()) {
                throw new NulsException(CmErrorCode.ERROR_ACCOUNT_VALIDATE);
            }
            return callResult;
        }
        catch (NulsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    @Override
    public ErrorCode transactionSignature(int chainId, String address, String password, Transaction tx) throws NulsException {
        try {
            if (Arrays.equals(CmConstants.BLACK_HOLE_ADDRESS, AddressTool.getAddress((String)address))) {
                return CmErrorCode.ERROR_ADDRESS_ERROR;
            }
            P2PHKSignature p2PHKSignature = new P2PHKSignature();
            HashMap<String, Object> callParams = new HashMap<String, Object>(4);
            callParams.put("chainId", chainId);
            callParams.put("address", address);
            callParams.put("password", password);
            callParams.put("data", RPCUtil.encode((byte[])tx.getHash().getBytes()));
            Response signResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_signDigest", callParams);
            if (!signResp.isSuccess()) {
                LoggerUtil.logger().error("ac_signDigest rpc error....{}=={}", new Object[]{signResp.getResponseErrorCode(), signResp.getResponseComment()});
                return ErrorCode.init((String)signResp.getResponseErrorCode());
            }
            HashMap signResult = (HashMap)((HashMap)signResp.getResponseData()).get("ac_signDigest");
            p2PHKSignature.parse(RPCUtil.decode((String)((String)signResult.get("signature"))), 0);
            TransactionSignature signature = new TransactionSignature();
            ArrayList<P2PHKSignature> p2PHKSignatures = new ArrayList<P2PHKSignature>();
            p2PHKSignatures.add(p2PHKSignature);
            signature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(signature.serialize());
        }
        catch (NulsException e) {
            LoggerUtil.logger().error(e);
            return CmErrorCode.ERROR_SIGNDIGEST;
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return CmErrorCode.ERROR_SIGNDIGEST;
        }
        return null;
    }

    @Override
    public Asset getLocalAssetByLedger(int chainId, int assetId) throws NulsException {
        try {
            HashMap<String, Integer> assetMap = new HashMap<String, Integer>();
            assetMap.put("chainId", chainId);
            assetMap.put("assetId", assetId);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"getAssetRegInfoByAssetId", assetMap);
            if (!response.isSuccess()) {
                LoggerUtil.logger().error("Failed to obtain ledger asset information:chainId={},assetId={},error={}", new Object[]{chainId, assetId, response.getResponseComment()});
                return null;
            }
            Map<String, Object> result = ResponseUtil.getResultMap(response, "getAssetRegInfoByAssetId");
            if (null == result) {
                return null;
            }
            Asset asset = new Asset();
            asset.setAssetName(result.get("assetName").toString());
            asset.setChainId(chainId);
            asset.setAssetId(assetId);
            asset.setSymbol(result.get("assetSymbol").toString());
            asset.setDecimalPlaces(Short.valueOf(result.get("decimalPlace").toString()));
            BigInteger initNumber = new BigInteger(result.get("initNumber").toString());
            long decimal = (long)Math.pow(10.0, Integer.valueOf(asset.getDecimalPlaces()).intValue());
            initNumber = initNumber.multiply(BigInteger.valueOf(decimal));
            asset.setInitNumber(initNumber);
            return asset;
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return null;
        }
    }
}

