/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.rpc.cmd;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.chain.info.CmErrorCode;
import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.dto.AccountBalance;
import io.nuls.chain.model.dto.RegAssetDto;
import io.nuls.chain.model.po.Asset;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.model.po.ChainAsset;
import io.nuls.chain.model.tx.AddAssetToChainTransaction;
import io.nuls.chain.model.tx.DestroyAssetAndChainTransaction;
import io.nuls.chain.model.tx.RemoveAssetFromChainTransaction;
import io.nuls.chain.rpc.call.RpcService;
import io.nuls.chain.rpc.cmd.BaseChainCmd;
import io.nuls.chain.service.AssetService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.util.ChainManagerUtil;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.chain.util.TxUtil;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.CM)
public class AssetCmd
extends BaseChainCmd {
    @Autowired
    private AssetService assetService;
    @Autowired
    private ChainService chainService;
    @Autowired
    private RpcService rpcService;
    @Autowired
    private NulsCoresConfig nulsChainConfig;

    @CmdAnnotation(cmd="cm_assetReg", version=1.0, description="Asset registration")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Asset ChainId,Value range[1-65535]"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]"), @Parameter(parameterName="symbol", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset symbols"), @Parameter(parameterName="assetName", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset Name"), @Parameter(parameterName="initNumber", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="Initial value of assets"), @Parameter(parameterName="decimalPlaces", requestType=@TypeDescriptor(value=short.class), parameterDes="Decimal Places of Assets"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Create an account address for the transaction"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", valueType=String.class, description="transactionhashvalue")}))
    public Response assetReg(Map params) {
        HashMap<String, String> rtMap = new HashMap<String, String>(1);
        try {
            Asset asset = new Asset();
            asset.map2pojo(params);
            if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
                return this.failed(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
            }
            if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getSymbol())) {
                return this.failed(CmErrorCode.ERROR_ASSET_SYMBOL);
            }
            if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getAssetName())) {
                return this.failed(CmErrorCode.ERROR_ASSET_NAME);
            }
            short version = ProtocolGroupManager.getCurrentVersion((int)this.nulsChainConfig.getMainChainId());
            if (version < 7) {
                asset.setDepositNuls(this.nulsChainConfig.getAssetDepositNuls());
                asset.setDestroyNuls(this.nulsChainConfig.getAssetDestroyNuls());
            } else {
                asset.setDepositNuls(BigInteger.ZERO);
                asset.setDestroyNuls(BigInteger.ZERO);
            }
            asset.setAvailable(true);
            BlockChain dbChain = this.chainService.getChain(asset.getChainId());
            if (null == dbChain) {
                return this.failed(CmErrorCode.ERROR_CHAIN_NOT_FOUND);
            }
            if (dbChain.isDelete()) {
                return this.failed(CmErrorCode.ERROR_CHAIN_REG_CMD);
            }
            if (this.assetService.assetExistAndAvailable(asset)) {
                return this.failed(CmErrorCode.ERROR_ASSET_ID_EXIST);
            }
            AddAssetToChainTransaction tx = new AddAssetToChainTransaction();
            if (ChainManagerUtil.getVersion(CmRuntimeInfo.getMainIntChainId()) >= 5) {
                tx.setTxData(TxUtil.parseAssetToTxV5(asset).serialize());
            } else {
                tx.setTxData(TxUtil.parseAssetToTx(asset).serialize());
            }
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            AccountBalance accountBalance = new AccountBalance(null, null);
            ErrorCode ldErrorCode = this.rpcService.getCoinData(String.valueOf(params.get("address")), accountBalance);
            if (null != ldErrorCode) {
                return this.failed(ldErrorCode);
            }
            CoinData coinData = version < 7 ? this.getRegCoinData(asset, CmRuntimeInfo.getMainIntChainId(), CmRuntimeInfo.getMainIntAssetId(), tx.size(), accountBalance) : this.getRegCoinDataV7(asset, CmRuntimeInfo.getMainIntChainId(), CmRuntimeInfo.getMainIntAssetId(), tx.size(), accountBalance);
            tx.setCoinData(coinData.serialize());
            ErrorCode acErrorCode = this.rpcService.transactionSignature(CmRuntimeInfo.getMainIntChainId(), (String)params.get("address"), (String)params.get("password"), tx);
            if (null != acErrorCode) {
                return this.failed(acErrorCode);
            }
            rtMap.put("txHash", tx.getHash().toHex());
            ErrorCode txErrorCode = this.rpcService.newTx(tx);
            if (null != txErrorCode) {
                return this.failed(txErrorCode);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="cm_mainNetAssetReg", version=1.0, description="Asset registration")
    @Parameters(value={@Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Create an account address for the transaction"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", valueType=String.class, description="transactionhashvalue")}))
    public Response mainNetAssetReg(Map params) {
        HashMap<String, String> rtMap = new HashMap<String, String>(1);
        try {
            Asset asset = this.rpcService.getLocalAssetByLedger(CmRuntimeInfo.getMainIntChainId(), Integer.valueOf(params.get("assetId").toString()));
            asset.setAddress(AddressTool.getAddress((String)((String)params.get("address"))));
            if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
                return this.failed(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
            }
            if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getSymbol())) {
                return this.failed(CmErrorCode.ERROR_ASSET_SYMBOL);
            }
            if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getAssetName())) {
                return this.failed(CmErrorCode.ERROR_ASSET_NAME);
            }
            short version = ProtocolGroupManager.getCurrentVersion((int)this.nulsChainConfig.getMainChainId());
            if (version < 7) {
                asset.setDepositNuls(this.nulsChainConfig.getAssetDepositNuls());
                asset.setDestroyNuls(this.nulsChainConfig.getAssetDestroyNuls());
            } else {
                asset.setDepositNuls(BigInteger.ZERO);
                asset.setDestroyNuls(BigInteger.ZERO);
            }
            asset.setAvailable(true);
            BlockChain dbChain = this.chainService.getChain(asset.getChainId());
            if (null == dbChain) {
                return this.failed(CmErrorCode.ERROR_CHAIN_NOT_FOUND);
            }
            if (dbChain.isDelete()) {
                return this.failed(CmErrorCode.ERROR_CHAIN_REG_CMD);
            }
            AddAssetToChainTransaction tx = new AddAssetToChainTransaction();
            LoggerUtil.COMMON_LOG.debug("version= {}", new Object[]{ChainManagerUtil.getVersion(CmRuntimeInfo.getMainIntChainId())});
            if (ChainManagerUtil.getVersion(CmRuntimeInfo.getMainIntChainId()) >= 5) {
                tx.setTxData(TxUtil.parseAssetToTxV5(asset).serialize());
            } else {
                tx.setTxData(TxUtil.parseAssetToTx(asset).serialize());
            }
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            AccountBalance accountBalance = new AccountBalance(null, null);
            ErrorCode ldErrorCode = this.rpcService.getCoinData(String.valueOf(params.get("address")), accountBalance);
            if (null != ldErrorCode) {
                return this.failed(ldErrorCode);
            }
            CoinData coinData = version < 7 ? this.getRegCoinData(asset, CmRuntimeInfo.getMainIntChainId(), CmRuntimeInfo.getMainIntAssetId(), tx.size(), accountBalance) : this.getRegCoinDataV7(asset, CmRuntimeInfo.getMainIntChainId(), CmRuntimeInfo.getMainIntAssetId(), tx.size(), accountBalance);
            tx.setCoinData(coinData.serialize());
            ErrorCode acErrorCode = this.rpcService.transactionSignature(CmRuntimeInfo.getMainIntChainId(), (String)params.get("address"), (String)params.get("password"), tx);
            if (null != acErrorCode) {
                return this.failed(acErrorCode);
            }
            rtMap.put("txHash", tx.getHash().toHex());
            ErrorCode txErrorCode = this.rpcService.newTx(tx);
            if (null != txErrorCode) {
                return this.failed(txErrorCode);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="cm_assetDisable", version=1.0, description="Asset cancellation")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Asset ChainId,Value range[1-65535]"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Create an account address for the transaction"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", valueType=String.class, description="transactionhashvalue")}))
    public Response assetDisable(Map params) {
        HashMap<String, String> rtMap = new HashMap<String, String>(1);
        try {
            Transaction tx;
            int chainId = Integer.parseInt(params.get("chainId").toString());
            int assetId = Integer.parseInt(params.get("assetId").toString());
            byte[] address = AddressTool.getAddress((String)params.get("address").toString());
            String dealAssetKey = CmRuntimeInfo.getAssetKey(chainId, assetId);
            Asset asset = this.assetService.getAsset(dealAssetKey);
            if (asset == null) {
                return this.failed(CmErrorCode.ERROR_ASSET_NOT_EXIST);
            }
            if (!asset.isAvailable()) {
                return this.failed(CmErrorCode.ERROR_ASSET_NOT_EXIST);
            }
            if (!ByteUtils.arrayEquals((byte[])asset.getAddress(), (byte[])address)) {
                return this.failed(CmErrorCode.ERROR_ADDRESS_ERROR);
            }
            BlockChain dbChain = this.chainService.getChain(chainId);
            if (null == dbChain) {
                return this.failed(CmErrorCode.ERROR_ASSET_NOT_EXIST);
            }
            List<String> assetKeyList = dbChain.getSelfAssetKeyList();
            int activeAssetCount = 0;
            String activeKey = "";
            for (String assetKey : assetKeyList) {
                Asset chainAsset = this.assetService.getAsset(assetKey);
                if (null != chainAsset && chainAsset.isAvailable()) {
                    activeKey = assetKey;
                    ++activeAssetCount;
                }
                if (activeAssetCount <= true) continue;
                break;
            }
            if (activeAssetCount == 1 && activeKey.equalsIgnoreCase(dealAssetKey)) {
                tx = new DestroyAssetAndChainTransaction();
                try {
                    if (ChainManagerUtil.getVersion(CmRuntimeInfo.getMainIntChainId()) >= 5) {
                        tx.setTxData(TxUtil.parseChainToTxV5(dbChain, asset).serialize());
                    }
                    tx.setTxData(TxUtil.parseChainToTx(dbChain, asset).serialize());
                }
                catch (IOException e) {
                    LoggerUtil.logger().error((Exception)e);
                    return this.failed("parseToTransaction fail");
                }
            } else {
                tx = new RemoveAssetFromChainTransaction();
                try {
                    if (ChainManagerUtil.getVersion(CmRuntimeInfo.getMainIntChainId()) >= 5) {
                        tx.setTxData(TxUtil.parseAssetToTxV5(asset).serialize());
                    } else {
                        tx.setTxData(TxUtil.parseAssetToTx(asset).serialize());
                    }
                }
                catch (IOException e) {
                    LoggerUtil.logger().error((Exception)e);
                    return this.failed("parseToTransaction fail");
                }
            }
            AccountBalance accountBalance = new AccountBalance(null, null);
            ErrorCode ldErrorCode = this.rpcService.getCoinData(String.valueOf(params.get("address")), accountBalance);
            if (null != ldErrorCode) {
                return this.failed(ldErrorCode);
            }
            CoinData coinData = this.getDisableCoinData(asset, CmRuntimeInfo.getMainIntChainId(), CmRuntimeInfo.getMainIntAssetId(), tx.size(), accountBalance);
            tx.setCoinData(coinData.serialize());
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            ErrorCode acErrorCode = this.rpcService.transactionSignature(CmRuntimeInfo.getMainIntChainId(), (String)params.get("address"), (String)params.get("password"), tx);
            if (null != acErrorCode) {
                return this.failed(acErrorCode);
            }
            rtMap.put("txHash", tx.getHash().toHex());
            ErrorCode txErrorCode = this.rpcService.newTx(tx);
            if (null != txErrorCode) {
                return this.failed(txErrorCode);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="cm_getChainAsset", version=1.0, description="Asset View")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Run ChainId,Value range[1-65535]"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Asset ChainId,Value range[1-65535]"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="chainId", valueType=Integer.class, description="Run ChainId"), @Key(name="assetChainId", valueType=Integer.class, description="Asset Chainid"), @Key(name="assetId", valueType=Integer.class, description="assetid"), @Key(name="asset", valueType=BigInteger.class, description="Asset value")}))
    public Response getChainAsset(Map params) {
        int chainId = Integer.parseInt(params.get("chainId").toString());
        int assetChainId = Integer.parseInt(params.get("assetChainId").toString());
        int assetId = Integer.parseInt(params.get("assetId").toString());
        String assetKey = CmRuntimeInfo.getAssetKey(assetChainId, assetId);
        try {
            ChainAsset chainAsset = this.assetService.getChainAsset(chainId, assetKey);
            HashMap<String, Number> rtMap = new HashMap<String, Number>();
            rtMap.put("chainId", chainId);
            rtMap.put("assetChainId", assetChainId);
            rtMap.put("assetId", assetId);
            rtMap.put("asset", chainAsset.getInitNumber().add(chainAsset.getInNumber()).subtract(chainAsset.getOutNumber()));
            return this.success(rtMap);
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(CmErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="cm_asset", version=1.0, description="Asset registration information query")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Asset ChainId,Value range[1-65535]"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]")})
    @ResponseData(description="Return Chain Information", responseType=@TypeDescriptor(value=RegAssetDto.class))
    public Response getRegAsset(Map params) {
        int chainId = Integer.parseInt(params.get("chainId").toString());
        int assetId = Integer.parseInt(params.get("assetId").toString());
        String assetKey = CmRuntimeInfo.getAssetKey(chainId, assetId);
        try {
            Asset asset = this.assetService.getAsset(assetKey);
            if (null == asset) {
                return this.failed(CmErrorCode.ERROR_ASSET_NOT_EXIST);
            }
            RegAssetDto regAssetDto = new RegAssetDto();
            regAssetDto.setChainId(chainId);
            regAssetDto.setAssetId(assetId);
            regAssetDto.setAddress(AddressTool.getStringAddressByBytes((byte[])asset.getAddress()));
            regAssetDto.setAssetName(asset.getAssetName());
            regAssetDto.setCreateTime(asset.getCreateTime());
            regAssetDto.setDecimalPlaces(asset.getDecimalPlaces());
            regAssetDto.setDepositNuls(asset.getDepositNuls().toString());
            regAssetDto.setDestroyNuls(asset.getDestroyNuls().toString());
            regAssetDto.setEnable(asset.isAvailable());
            regAssetDto.setInitNumber(asset.getInitNumber().toString());
            regAssetDto.setTxHash(asset.getTxHash());
            regAssetDto.setSymbol(asset.getSymbol());
            return this.success(regAssetDto);
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(CmErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }
}

