/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.service.impl;

import io.nuls.base.basic.AddressTool;
import io.nuls.chain.info.CmErrorCode;
import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.dto.ChainEventResult;
import io.nuls.chain.model.po.Asset;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.model.po.ChainAsset;
import io.nuls.chain.service.AssetService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.service.ValidateService;
import io.nuls.chain.util.ChainManagerUtil;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Service;
import io.nuls.core.log.Log;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.model.FormatValidUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service
public class ValidateServiceImpl
implements ValidateService {
    @Autowired
    AssetService assetService;
    @Autowired
    ChainService chainService;
    @Autowired
    private NulsCoresConfig nulsChainConfig;

    @Override
    public ChainEventResult assetDisableValidator(Asset asset) throws Exception {
        double config;
        Asset dbAsset = this.assetService.getAsset(CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId()));
        if (!ByteUtils.arrayEquals((byte[])asset.getAddress(), (byte[])dbAsset.getAddress())) {
            LoggerUtil.logger().error("address={},dbAddr={} ERROR_ADDRESS_ERROR", new Object[]{AddressTool.getStringAddressByBytes((byte[])asset.getAddress()), AddressTool.getStringAddressByBytes((byte[])dbAsset.getAddress())});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ADDRESS_ERROR);
        }
        if (asset.getChainId() != dbAsset.getChainId()) {
            LoggerUtil.logger().error("chainId={},dbChainId={} ERROR_CHAIN_ASSET_NOT_MATCH", new Object[]{asset.getChainId(), dbAsset.getChainId()});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_CHAIN_ASSET_NOT_MATCH);
        }
        ChainAsset chainAsset = this.assetService.getChainAsset(asset.getChainId(), CmRuntimeInfo.getAssetKey(dbAsset.getChainId(), dbAsset.getAssetId()));
        BigDecimal initAsset = new BigDecimal(chainAsset.getInitNumber());
        BigDecimal inAsset = new BigDecimal(chainAsset.getInNumber());
        BigDecimal outAsset = new BigDecimal(chainAsset.getOutNumber());
        BigDecimal currentNumber = initAsset.add(inAsset).subtract(outAsset);
        double actual = currentNumber.divide(initAsset, (int)dbAsset.getDecimalPlaces(), RoundingMode.HALF_DOWN).doubleValue();
        if (actual < (config = Double.parseDouble(this.nulsChainConfig.getAssetRecoveryRate()))) {
            LoggerUtil.logger().error("chainId={},assetId={} actual={},config={},==={}-{}-{}", new Object[]{asset.getChainId(), asset.getAssetId(), actual, config, initAsset, inAsset, outAsset});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_RECOVERY_RATE);
        }
        return ChainEventResult.getResultSuccess();
    }

    @Override
    public ChainEventResult assetDisableValidatorV7(Asset asset) throws Exception {
        Asset dbAsset = this.assetService.getAsset(CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId()));
        if (!ByteUtils.arrayEquals((byte[])asset.getAddress(), (byte[])dbAsset.getAddress())) {
            LoggerUtil.logger().error("address={},dbAddr={} ERROR_ADDRESS_ERROR", new Object[]{AddressTool.getStringAddressByBytes((byte[])asset.getAddress()), AddressTool.getStringAddressByBytes((byte[])dbAsset.getAddress())});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ADDRESS_ERROR);
        }
        if (asset.getChainId() != dbAsset.getChainId()) {
            LoggerUtil.logger().error("chainId={},dbChainId={} ERROR_CHAIN_ASSET_NOT_MATCH", new Object[]{asset.getChainId(), dbAsset.getChainId()});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_CHAIN_ASSET_NOT_MATCH);
        }
        return ChainEventResult.getResultSuccess();
    }

    @Override
    public ChainEventResult chainDisableValidator(BlockChain blockChain) throws Exception {
        if (null == blockChain) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_CHAIN_NOT_FOUND);
        }
        BlockChain dbChain = this.chainService.getChain(blockChain.getChainId());
        List<String> keys = dbChain.getSelfAssetKeyList();
        if (keys.size() == 0) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_CHAIN_ASSET_MUTI);
        }
        String key = keys.get(0);
        Asset dbAsset = this.assetService.getAsset(key);
        if (null == dbAsset) {
            LoggerUtil.logger().error("chainId={} ERROR_ASSET_NOT_EXIST", new Object[]{blockChain.getChainId()});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_NOT_EXIST);
        }
        if (!ByteUtils.arrayEquals((byte[])dbAsset.getAddress(), (byte[])blockChain.getDelAddress())) {
            LoggerUtil.logger().error("chainId={} ERROR_ADDRESS_ERROR", new Object[]{blockChain.getChainId()});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ADDRESS_ERROR);
        }
        return ChainEventResult.getResultSuccess();
    }

    public ChainEventResult batchChainRegBaseValidator(BlockChain blockChain, Asset asset, Map<String, Integer> tempChains, Map<String, Integer> tempAssets) throws Exception {
        boolean isChainDisable;
        BlockChain dbChain = this.chainService.getChain(blockChain.getChainId());
        boolean bl = isChainDisable = dbChain != null && dbChain.isDelete();
        if (ChainManagerUtil.duplicateChainId(blockChain, tempChains) || this.chainService.chainExist(blockChain.getChainId())) {
            LoggerUtil.logger().error("chainId={} exist", new Object[]{blockChain.getChainId()});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_CHAIN_ID_EXIST);
        }
        if (ChainManagerUtil.duplicateMagicNumber(blockChain, tempChains) || this.chainService.hadExistMagicNumber(blockChain.getMagicNumber()) && !isChainDisable) {
            LoggerUtil.logger().error("magicNumber={} exist", new Object[]{blockChain.getMagicNumber()});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_MAGIC_NUMBER_EXIST);
        }
        if (ChainManagerUtil.duplicateChainName(blockChain, tempChains) || this.chainService.hadExistChainName(blockChain.getChainName()) && !isChainDisable) {
            LoggerUtil.logger().error("chainName={} exist", new Object[]{blockChain.getChainName()});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_CHAIN_NAME_EXIST);
        }
        if (this.assetService.regChainAssetExist(asset, tempAssets)) {
            LoggerUtil.logger().error("chainId={} assetId={} exist", new Object[]{asset.getChainId(), asset.getAssetId()});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_ID_EXIST);
        }
        if (0 == blockChain.getVerifierList().size()) {
            LoggerUtil.logger().error("chainId={} assetId={} getVerifierList=0", new Object[]{asset.getChainId(), asset.getAssetId()});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_VERIFIER_LIST_EMPTY);
        }
        if (66 > blockChain.getSignatureByzantineRatio()) {
            LoggerUtil.logger().error("chainId={} assetId={} getSignatureByzantineRatio={} less than {}", new Object[]{asset.getChainId(), asset.getAssetId(), blockChain.getSignatureByzantineRatio(), 66});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_SIGNATURE_BYZANTINE_RATIO);
        }
        return ChainEventResult.getResultSuccess();
    }

    @Override
    public ChainEventResult batchChainRegValidator(BlockChain blockChain, Asset asset, Map<String, Integer> tempChains, Map<String, Integer> tempAssets) throws Exception {
        ChainEventResult chainEventResult = this.batchChainRegBaseValidator(blockChain, asset, tempChains, tempAssets);
        return chainEventResult;
    }

    @Override
    public ChainEventResult batchChainRegValidatorV3(BlockChain blockChain, Asset asset, Map<String, Integer> tempChains, Map<String, Integer> tempAssets) throws Exception {
        ChainEventResult chainEventResult = this.batchChainRegBaseValidator(blockChain, asset, tempChains, tempAssets);
        if (!chainEventResult.isSuccess()) {
            return chainEventResult;
        }
        if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getSymbol())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_SYMBOL);
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getAssetName())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_NAME);
        }
        if (!BigIntegerUtils.isEqual((BigInteger)asset.getDepositNuls(), (BigInteger)this.nulsChainConfig.getAssetDepositNuls())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DEPOSITNULS);
        }
        if (!BigIntegerUtils.isEqual((BigInteger)asset.getDestroyNuls(), (BigInteger)this.nulsChainConfig.getAssetDestroyNuls())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DEPOSITNULS);
        }
        return ChainEventResult.getResultSuccess();
    }

    @Override
    public ChainEventResult batchAssetRegValidator(Asset asset, Map<String, Integer> tempAssets) throws Exception {
        if (this.assetService.assetExist(asset, tempAssets)) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_ID_EXIST);
        }
        if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
        }
        if (null == asset.getSymbol() || asset.getSymbol().length() > Integer.valueOf(this.nulsChainConfig.getAssetSymbolMax()) || asset.getSymbol().length() < 1) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_SYMBOL_LENGTH);
        }
        return ChainEventResult.getResultSuccess();
    }

    @Override
    public ChainEventResult batchAssetRegValidatorV3(Asset asset, Map<String, Integer> tempAssets) throws Exception {
        if (this.assetService.assetExist(asset, tempAssets)) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_ID_EXIST);
        }
        if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getSymbol())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_SYMBOL);
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getAssetName())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_NAME);
        }
        if (!BigIntegerUtils.isEqual((BigInteger)asset.getDepositNuls(), (BigInteger)this.nulsChainConfig.getAssetDepositNuls())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DEPOSITNULS);
        }
        if (!BigIntegerUtils.isEqual((BigInteger)asset.getDestroyNuls(), (BigInteger)this.nulsChainConfig.getAssetDestroyNuls())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DEPOSITNULS);
        }
        return ChainEventResult.getResultSuccess();
    }

    @Override
    public ChainEventResult assetCirculateValidator(int fromChainId, int toChainId, Map<String, BigInteger> fromAssetMap, Map<String, BigInteger> toAssetMap) throws Exception {
        BlockChain fromChain = this.chainService.getChain(fromChainId);
        BlockChain toChain = this.chainService.getChain(toChainId);
        if (fromChainId == toChainId) {
            Log.error((String)"fromChain ==toChain=={} is not cross tx", (Object[])new Object[]{fromChain});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_NOT_CROSS_TX);
        }
        if (fromChainId != 0 && fromChain.isDelete()) {
            Log.info((String)"fromChain is delete,chainId={}", (Object[])new Object[]{fromChain.getChainId()});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_CHAIN_NOT_FOUND);
        }
        if (toChainId != 0 && toChain.isDelete()) {
            Log.info((String)"toChain is delete,chainId={}", (Object[])new Object[]{toChain.getChainId()});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_CHAIN_NOT_FOUND);
        }
        Set<String> toAssets = toAssetMap.keySet();
        for (String toAsset : toAssets) {
            String assetKey = toAsset.toString();
            Asset asset = this.assetService.getAsset(assetKey);
            if (null != asset && asset.isAvailable()) continue;
            Log.info((String)"asset not exist", (Object[])new Object[]{assetKey});
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_NOT_EXIST);
        }
        Set<String> fromAssets = fromAssetMap.keySet();
        for (String fromAsset : fromAssets) {
            BigInteger currentAsset;
            String assetKey = fromAsset.toString();
            Asset asset = this.assetService.getAsset(assetKey);
            if (null == asset || !asset.isAvailable()) {
                Log.info((String)"asset not exist", (Object[])new Object[]{assetKey});
                return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_NOT_EXIST);
            }
            ChainAsset chainAsset = this.assetService.getChainAsset(fromChainId, CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId()));
            if (chainAsset.isFromChainAsset() || !BigIntegerUtils.isLessThan((BigInteger)(currentAsset = chainAsset.getInitNumber().add(chainAsset.getInNumber()).subtract(chainAsset.getOutNumber())), (BigInteger)fromAssetMap.get(assetKey))) continue;
            LoggerUtil.logger().error("fromChainId={},assetKey={}currentAsset={} fromAsset={} BALANCE_NOT_ENOUGH", new Object[]{fromChainId, assetKey, currentAsset, fromAssetMap.get(assetKey)});
            return ChainEventResult.getResultFail(CmErrorCode.BALANCE_NOT_ENOUGH);
        }
        return ChainEventResult.getResultSuccess();
    }

    @Override
    public ChainEventResult batchChainRegValidatorV7(BlockChain blockChain, Asset asset, Map<String, Integer> tempChains, Map<String, Integer> tempAssets) throws Exception {
        ChainEventResult chainEventResult = this.batchChainRegBaseValidator(blockChain, asset, tempChains, tempAssets);
        if (!chainEventResult.isSuccess()) {
            return chainEventResult;
        }
        if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getSymbol())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_SYMBOL);
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getAssetName())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_NAME);
        }
        return ChainEventResult.getResultSuccess();
    }

    @Override
    public ChainEventResult batchChainRegValidatorV15(BlockChain blockChain, Asset asset, Map<String, Integer> tempChains, Map<String, Integer> tempAssets) throws Exception {
        ChainEventResult chainEventResult = this.batchChainRegBaseValidator(blockChain, asset, tempChains, tempAssets);
        if (!chainEventResult.isSuccess()) {
            return chainEventResult;
        }
        if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
        }
        if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getSymbol())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_SYMBOL);
        }
        if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getAssetName())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_NAME);
        }
        return ChainEventResult.getResultSuccess();
    }

    @Override
    public ChainEventResult batchAssetRegValidatorV7(Asset asset, Map<String, Integer> tempAssets) throws Exception {
        if (this.assetService.assetExist(asset, tempAssets)) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_ID_EXIST);
        }
        if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getSymbol())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_SYMBOL);
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getAssetName())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_NAME);
        }
        return ChainEventResult.getResultSuccess();
    }

    @Override
    public ChainEventResult batchAssetRegValidatorV12(Asset asset, Map<String, Integer> tempAssets) throws Exception {
        if (this.assetService.regChainAssetExist(asset, tempAssets)) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_ID_EXIST);
        }
        if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getSymbol())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_SYMBOL);
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getAssetName())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_NAME);
        }
        return ChainEventResult.getResultSuccess();
    }

    @Override
    public ChainEventResult batchAssetRegValidatorV15(Asset asset, Map<String, Integer> tempAssets) throws Exception {
        if (this.assetService.regChainAssetExist(asset, tempAssets)) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_ID_EXIST);
        }
        if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
        }
        if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getSymbol())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_SYMBOL);
        }
        if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getAssetName())) {
            return ChainEventResult.getResultFail(CmErrorCode.ERROR_ASSET_NAME);
        }
        return ChainEventResult.getResultSuccess();
    }
}

