/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.bo;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.common.ConfigBean;
import io.nuls.consensus.model.bo.consensus.Evidence;
import io.nuls.consensus.model.bo.round.MeetingRound;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.po.PunishLogPo;
import io.nuls.consensus.utils.enumeration.ConsensusStatus;
import io.nuls.core.log.logback.NulsLogger;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Chain {
    private boolean packer = false;
    private ConfigBean config;
    private ConsensusStatus consensusStatus;
    private boolean canPacking = false;
    private BlockHeader newestHeader;
    private List<Agent> agentList;
    private List<Deposit> depositList;
    private List<PunishLogPo> yellowPunishList;
    private List<PunishLogPo> redPunishList;
    private Map<String, List<Evidence>> evidenceMap;
    private List<Transaction> redPunishTransactionList;
    private List<MeetingRound> roundList;
    private List<BlockHeader> blockHeaderList;
    private final Lock roundLock = new ReentrantLock();
    private NulsLogger logger;
    private boolean cacheLoaded = false;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    public Chain() {
        this.consensusStatus = ConsensusStatus.RUNNING;
        this.agentList = new ArrayList<Agent>();
        this.depositList = new ArrayList<Deposit>();
        this.yellowPunishList = new ArrayList<PunishLogPo>();
        this.redPunishList = new ArrayList<PunishLogPo>();
        this.evidenceMap = new HashMap<String, List<Evidence>>();
        this.redPunishTransactionList = new ArrayList<Transaction>();
        this.roundList = new ArrayList<MeetingRound>();
    }

    public List<Agent> getNewOrWorkAgentList(long height) {
        ArrayList<Agent> workAgentList = new ArrayList<Agent>();
        for (Agent agent : this.agentList) {
            if (agent.getDelHeight() != -1L && agent.getDelHeight() <= height || agent.getBlockHeight() > height || agent.getBlockHeight() < 0L) continue;
            workAgentList.add(agent);
        }
        return workAgentList;
    }

    public List<Agent> getWorkAgentList(long height) {
        ArrayList<Agent> workAgentList = new ArrayList<Agent>();
        for (Agent agent : this.agentList) {
            if (agent.getDelHeight() != -1L && agent.getDelHeight() <= height || agent.getBlockHeight() > height || agent.getBlockHeight() < 0L) continue;
            List<Deposit> cdList = this.getDepositListByAgentId(agent.getTxHash(), height);
            BigInteger totalDeposit = BigInteger.ZERO;
            for (Deposit dtx : cdList) {
                totalDeposit = totalDeposit.add(dtx.getDeposit());
            }
            if (totalDeposit.compareTo(this.config.getCommissionMin()) < 0) continue;
            workAgentList.add(agent);
        }
        return workAgentList;
    }

    public Set<String> getWorkAddressList(long height) {
        HashSet<String> workAddressList = new HashSet<String>();
        for (Agent agent : this.agentList) {
            if (agent.getDelHeight() != -1L && agent.getDelHeight() <= height || agent.getBlockHeight() > height || agent.getBlockHeight() < 0L) continue;
            List<Deposit> cdList = this.getDepositListByAgentId(agent.getTxHash(), height);
            BigInteger totalDeposit = BigInteger.ZERO;
            for (Deposit dtx : cdList) {
                totalDeposit = totalDeposit.add(dtx.getDeposit());
            }
            if (totalDeposit.compareTo(this.config.getCommissionMin()) < 0) continue;
            workAddressList.add(AddressTool.getStringAddressByBytes((byte[])agent.getPackingAddress()));
        }
        return workAddressList;
    }

    private List<Deposit> getDepositListByAgentId(NulsHash agentHash, long startBlockHeight) {
        ArrayList<Deposit> resultList = new ArrayList<Deposit>();
        for (int i = this.depositList.size() - 1; i >= 0; --i) {
            Deposit deposit = this.depositList.get(i);
            if (deposit.getDelHeight() != -1L && deposit.getDelHeight() <= startBlockHeight || deposit.getBlockHeight() > startBlockHeight || deposit.getBlockHeight() < 0L || !deposit.getAgentHash().equals((Object)agentHash)) continue;
            resultList.add(deposit);
        }
        return resultList;
    }

    public ConfigBean getConfig() {
        return this.config;
    }

    public void setConfig(ConfigBean config) {
        this.config = config;
    }

    public ConsensusStatus getConsensusStatus() {
        return this.consensusStatus;
    }

    public void setConsensusStatus(ConsensusStatus consensusStatus) {
        this.consensusStatus = consensusStatus;
    }

    public boolean isCanPacking() {
        return this.canPacking;
    }

    public void setCanPacking(boolean canPacking) {
        this.canPacking = canPacking;
    }

    public List<Agent> getAgentList() {
        return this.agentList;
    }

    public void setAgentList(List<Agent> agentList) {
        this.agentList = agentList;
    }

    public List<Deposit> getDepositList() {
        return this.depositList;
    }

    public void setDepositList(List<Deposit> depositList) {
        this.depositList = depositList;
    }

    public List<PunishLogPo> getYellowPunishList() {
        return this.yellowPunishList;
    }

    public void setYellowPunishList(List<PunishLogPo> yellowPunishList) {
        this.yellowPunishList = yellowPunishList;
    }

    public List<PunishLogPo> getRedPunishList() {
        return this.redPunishList;
    }

    public void setRedPunishList(List<PunishLogPo> redPunishList) {
        this.redPunishList = redPunishList;
    }

    public Map<String, List<Evidence>> getEvidenceMap() {
        return this.evidenceMap;
    }

    public void setEvidenceMap(Map<String, List<Evidence>> evidenceMap) {
        this.evidenceMap = evidenceMap;
    }

    public List<Transaction> getRedPunishTransactionList() {
        return this.redPunishTransactionList;
    }

    public void setRedPunishTransactionList(List<Transaction> redPunishTransactionList) {
        this.redPunishTransactionList = redPunishTransactionList;
    }

    public List<MeetingRound> getRoundList() {
        return this.roundList;
    }

    public void setRoundList(List<MeetingRound> roundList) {
        this.roundList = roundList;
    }

    public BlockHeader getNewestHeader() {
        return this.newestHeader;
    }

    public void setNewestHeader(BlockHeader newestHeader) {
        this.newestHeader = newestHeader;
    }

    public List<BlockHeader> getBlockHeaderList() {
        return this.blockHeaderList;
    }

    public void setBlockHeaderList(List<BlockHeader> blockHeaderList) {
        this.blockHeaderList = blockHeaderList;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
    }

    public Lock getRoundLock() {
        return this.roundLock;
    }

    public boolean isPacker() {
        return this.packer;
    }

    public void setPacker(boolean packer) {
        this.packer = packer;
    }

    public NulsLogger getLogger() {
        return this.logger;
    }

    public void setLogger(NulsLogger logger) {
        this.logger = logger;
    }

    public boolean isCacheLoaded() {
        return this.cacheLoaded;
    }

    public void setCacheLoaded(boolean cacheLoaded) {
        this.cacheLoaded = cacheLoaded;
    }
}

