/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.dto.output;

import io.nuls.base.basic.AddressTool;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.utils.manager.AgentManager;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import java.math.BigInteger;

@ApiModel(name="Entrustment information")
public class DepositDTO {
    @ApiModelProperty(description="Entrusted amount")
    private String deposit;
    @ApiModelProperty(description="nodeHASH")
    private String agentHash;
    @ApiModelProperty(description="Account address")
    private String address;
    @ApiModelProperty(description="Entrustment time")
    private Long time;
    @ApiModelProperty(description="Entrusted transactionHASH")
    private String txHash;
    @ApiModelProperty(description="The packaging height of entrusted transactions")
    private Long blockHeight;
    @ApiModelProperty(description="Exit commission height")
    private Long delHeight;
    @ApiModelProperty(description="Node status 0:Pending consensus, 1:Consensus reached")
    private int status;
    @ApiModelProperty(description="Node Name")
    private String agentName;
    @ApiModelProperty(description="Node address")
    private String agentAddress;

    public DepositDTO(Deposit deposit) {
        this.deposit = BigIntegerUtils.bigIntegerToString((BigInteger)deposit.getDeposit());
        this.agentHash = deposit.getAgentHash().toHex();
        this.address = AddressTool.getStringAddressByBytes((byte[])deposit.getAddress());
        this.time = deposit.getTime();
        this.txHash = deposit.getTxHash().toHex();
        this.blockHeight = deposit.getBlockHeight();
        this.delHeight = deposit.getDelHeight();
        this.status = deposit.getStatus();
    }

    public DepositDTO(Deposit deposit, Agent agent) {
        this(deposit);
        if (agent != null) {
            this.agentAddress = AddressTool.getStringAddressByBytes((byte[])agent.getAgentAddress());
            this.agentName = ((AgentManager)SpringLiteContext.getBean(AgentManager.class)).getAgentId(agent.getTxHash());
        }
    }

    public String getDeposit() {
        return this.deposit;
    }

    public void setDeposit(String deposit) {
        this.deposit = deposit;
    }

    public String getAgentHash() {
        return this.agentHash;
    }

    public void setAgentHash(String agentHash) {
        this.agentHash = agentHash;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public Long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(Long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public Long getDelHeight() {
        return this.delHeight;
    }

    public void setDelHeight(Long delHeight) {
        this.delHeight = delHeight;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getAgentAddress() {
        return this.agentAddress;
    }

    public void setAgentAddress(String agentAddress) {
        this.agentAddress = agentAddress;
    }
}

