/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.basic.VarInt;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.Arrays;

public class PunishLogPo
extends BaseNulsData {
    private byte type;
    private byte[] address;
    private long time;
    private long height;
    private long roundIndex;
    private short reasonCode;
    private byte[] evidence;
    private int index;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write((int)this.type);
        stream.write(this.address);
        stream.writeUint48(this.time);
        stream.writeVarInt(this.height);
        stream.writeVarInt(this.roundIndex);
        stream.writeShort(this.reasonCode);
        stream.writeBytesWithLength(this.evidence);
        stream.writeUint16(this.index);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.type = byteBuffer.readByte();
        this.address = byteBuffer.readBytes(23);
        this.time = byteBuffer.readUint48();
        this.height = byteBuffer.readVarInt();
        this.roundIndex = byteBuffer.readVarInt();
        this.reasonCode = byteBuffer.readShort();
        this.evidence = byteBuffer.readByLengthByte();
        this.index = byteBuffer.readUint16();
    }

    public int size() {
        int size = 0;
        ++size;
        size += 23;
        size += SerializeUtils.sizeOfUint48();
        size += SerializeUtils.sizeOfVarInt((Long)this.height);
        size += SerializeUtils.sizeOfVarInt((Long)this.roundIndex);
        size += 2;
        size += SerializeUtils.sizeOfBytes((byte[])this.evidence);
        return size += SerializeUtils.sizeOfUint16();
    }

    public long getRoundIndex() {
        return this.roundIndex;
    }

    public void setRoundIndex(long roundIndex) {
        this.roundIndex = roundIndex;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public byte[] getKey() {
        return ByteUtils.concatenate((byte[][])new byte[][]{this.address, {this.type}, SerializeUtils.uint64ToByteArray((long)this.height), new VarInt((long)this.index).encode()});
    }

    public void setReasonCode(short reasonCode) {
        this.reasonCode = reasonCode;
    }

    public void setEvidence(byte[] evidence) {
        this.evidence = evidence;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PunishLogPo)) {
            return false;
        }
        return Arrays.equals(this.getKey(), ((PunishLogPo)((Object)obj)).getKey());
    }

    public short getReasonCode() {
        return this.reasonCode;
    }

    public byte[] getEvidence() {
        return this.evidence;
    }
}

