/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.service.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.common.ConfigBean;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.round.MeetingMember;
import io.nuls.consensus.model.bo.round.MeetingRound;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.dto.input.SearchPunishDTO;
import io.nuls.consensus.model.dto.output.AccountConsensusInfoDTO;
import io.nuls.consensus.model.dto.output.PunishLogDTO;
import io.nuls.consensus.model.dto.output.WholeNetConsensusInfoDTO;
import io.nuls.consensus.model.po.PunishLogPo;
import io.nuls.consensus.service.ChainService;
import io.nuls.consensus.utils.manager.AgentManager;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.DepositManager;
import io.nuls.consensus.utils.manager.PunishManager;
import io.nuls.consensus.utils.manager.RoundManager;
import io.nuls.consensus.utils.validator.BatchValidator;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Component
public class ChainServiceImpl
implements ChainService {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private BatchValidator batchValidator;
    @Autowired
    private PunishManager punishManager;
    @Autowired
    private RoundManager roundManager;
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private DepositManager depositManager;

    @Override
    public Result batchValid(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null || params.get("txList") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            List txHexList = (List)params.get("txList");
            ArrayList<Transaction> txList = new ArrayList<Transaction>();
            for (Object txHex : txHexList) {
                Transaction tx = new Transaction();
                tx.parse(RPCUtil.decode((String)txHex), 0);
                txList.add(tx);
            }
            this.batchValidator.batchValid(txList, chain);
            ArrayList<String> resultTxHashList = new ArrayList<String>();
            for (Transaction tx : txList) {
                resultTxHashList.add(tx.getHash().toHex());
            }
            HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>(2);
            result.put("list", resultTxHashList);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
    }

    @Override
    public Result commitCmd(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null || params.get("txList") == null || params.get("blockHeader") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(2);
        result.put("value", false);
        ArrayList<Transaction> commitSuccessList = new ArrayList<Transaction>();
        BlockHeader blockHeader = new BlockHeader();
        try {
            String headerHex = (String)params.get("blockHeader");
            blockHeader.parse(RPCUtil.decode((String)headerHex), 0);
            List txHexList = (List)params.get("txList");
            for (String txHex : txHexList) {
                Transaction tx = new Transaction();
                tx.parse(RPCUtil.decode((String)txHex), 0);
                if (this.transactionCommit(tx, chain, blockHeader)) {
                    commitSuccessList.add(tx);
                    continue;
                }
                this.transactionBatchRollBack(commitSuccessList, chain, blockHeader);
                result.put("value", false);
                return Result.getFailed((ErrorCode)ConsensusErrorCode.SAVE_FAILED).setData(result);
            }
            result.put("value", true);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            result.put("value", false);
            return Result.getFailed((ErrorCode)e.getErrorCode()).setData(result);
        }
    }

    @Override
    public Result rollbackCmd(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null || params.get("txList") == null || params.get("blockHeader") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(2);
        result.put("value", false);
        try {
            String headerHex = (String)params.get("blockHeader");
            BlockHeader blockHeader = new BlockHeader();
            blockHeader.parse(RPCUtil.decode((String)headerHex), 0);
            List txHexList = (List)params.get("txList");
            for (String txHex : txHexList) {
                Transaction tx = new Transaction();
                tx.parse(RPCUtil.decode((String)txHex), 0);
                this.transactionRollback(tx, chain, blockHeader);
            }
            result.put("value", true);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode()).setData(result);
        }
    }

    @Override
    public Result addEvidenceRecord(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("blockHeader") == null || params.get("evidenceHeader") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            BlockHeader header = new BlockHeader();
            header.parse(RPCUtil.decode((String)((String)params.get("blockHeader"))), 0);
            BlockHeader evidenceHeader = new BlockHeader();
            evidenceHeader.parse(RPCUtil.decode((String)((String)params.get("evidenceHeader"))), 0);
            chain.getLogger().info("Received new bifurcation evidence:" + header.getHeight());
            this.punishManager.addEvidenceRecord(chain, header, evidenceHeader);
            HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(2);
            validResult.put("value", true);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(validResult);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
    }

    @Override
    public Result doubleSpendRecord(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("block") == null || params.get("tx") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            Block block = new Block();
            block.parse(RPCUtil.decode((String)((String)params.get("block"))), 0);
            List txHexList = JSONUtils.json2list((String)((String)params.get("tx")), String.class);
            ArrayList<Transaction> txList = new ArrayList<Transaction>();
            for (String txHex : txHexList) {
                Transaction tx = new Transaction();
                tx.parse(RPCUtil.decode((String)txHex), 0);
                txList.add(tx);
            }
            this.punishManager.addDoubleSpendRecord(chain, txList, block);
            HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(2);
            validResult.put("value", true);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(validResult);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result getWholeInfo(Map<String, Object> params) {
        if (params.get("chainId") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        WholeNetConsensusInfoDTO dto = new WholeNetConsensusInfoDTO();
        List<Agent> agentList = chain.getAgentList();
        if (agentList == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_NOT_EXIST);
        }
        ArrayList<Agent> handleList = new ArrayList<Agent>();
        long startBlockHeight = chain.getNewestHeader().getHeight();
        for (Agent agent : agentList) {
            if (agent.getDelHeight() != -1L && agent.getDelHeight() <= startBlockHeight || agent.getBlockHeight() > startBlockHeight || agent.getBlockHeight() < 0L) continue;
            handleList.add(agent);
        }
        MeetingRound round = this.roundManager.getCurrentRound(chain);
        BigInteger totalDeposit = BigInteger.ZERO;
        int packingAgentCount = 0;
        if (null != round) {
            for (MeetingMember member : round.getMemberList()) {
                totalDeposit = totalDeposit.add(member.getAgent().getDeposit().add(member.getAgent().getTotalDeposit()));
                if (member.getAgent() == null) continue;
                ++packingAgentCount;
            }
        }
        dto.setAgentCount(handleList.size());
        dto.setTotalDeposit(String.valueOf(totalDeposit));
        dto.setConsensusAccountNumber(handleList.size());
        dto.setPackingAgentCount(packingAgentCount);
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData((Object)dto);
    }

    @Override
    public Result getInfo(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("address") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        String address = (String)params.get("address");
        AccountConsensusInfoDTO dto = new AccountConsensusInfoDTO();
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        long startBlockHeight = chain.getNewestHeader().getHeight();
        int agentCount = 0;
        String agentHash = null;
        byte[] addressBytes = AddressTool.getAddress((String)address);
        List<Agent> agentList = chain.getAgentList();
        for (Agent agent : agentList) {
            if (agent.getDelHeight() != -1L && agent.getDelHeight() <= startBlockHeight || agent.getBlockHeight() > startBlockHeight || agent.getBlockHeight() < 0L || !Arrays.equals(agent.getAgentAddress(), addressBytes)) continue;
            agentCount = 1;
            agentHash = agent.getTxHash().toHex();
            break;
        }
        List<Deposit> depositList = chain.getDepositList();
        HashSet<NulsHash> agentSet = new HashSet<NulsHash>();
        BigInteger totalDeposit = BigInteger.ZERO;
        for (Deposit deposit : depositList) {
            if (deposit.getDelHeight() != -1L && deposit.getDelHeight() <= startBlockHeight || deposit.getBlockHeight() > startBlockHeight || deposit.getBlockHeight() < 0L || !Arrays.equals(deposit.getAddress(), addressBytes)) continue;
            agentSet.add(deposit.getAgentHash());
            totalDeposit = totalDeposit.add(deposit.getDeposit());
        }
        dto.setAgentCount(agentCount);
        dto.setAgentHash(agentHash);
        dto.setJoinAgentCount(agentSet.size());
        dto.setTotalDeposit(String.valueOf(totalDeposit));
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData((Object)dto);
    }

    @Override
    public Result getPublishList(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        SearchPunishDTO dto = (SearchPunishDTO)JSONUtils.map2pojo(params, SearchPunishDTO.class);
        int chainId = dto.getChainId();
        String address = dto.getAddress();
        int type = dto.getType();
        if (chainId == 0 || StringUtils.isBlank((String)address)) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        ArrayList<PunishLogDTO> yellowPunishList = null;
        ArrayList<PunishLogDTO> redPunishList = null;
        int typeOfYellow = 2;
        if (type != 1) {
            redPunishList = new ArrayList<PunishLogDTO>();
            for (PunishLogPo po : chain.getRedPunishList()) {
                if (StringUtils.isNotBlank((String)address) && !ByteUtils.arrayEquals((byte[])po.getAddress(), (byte[])AddressTool.getAddress((String)address))) continue;
                redPunishList.add(new PunishLogDTO(po));
            }
        }
        if (type != typeOfYellow) {
            yellowPunishList = new ArrayList<PunishLogDTO>();
            for (PunishLogPo po : chain.getYellowPunishList()) {
                if (StringUtils.isNotBlank((String)address) && !ByteUtils.arrayEquals((byte[])po.getAddress(), (byte[])AddressTool.getAddress((String)address))) continue;
                yellowPunishList.add(new PunishLogDTO(po));
            }
        }
        HashMap<String, ArrayList<PunishLogDTO>> resultMap = new HashMap<String, ArrayList<PunishLogDTO>>(2);
        resultMap.put("redPunish", redPunishList);
        resultMap.put("yellowPunish", yellowPunishList);
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(resultMap);
    }

    @Override
    public Result getCurrentRoundInfo(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            MeetingRound round = this.roundManager.resetRound(chain, true);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData((Object)round);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (Exception e) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
        }
    }

    @Override
    public Result getRoundMemberList(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null || params.get("extend") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            BlockExtendsData extendsData = new BlockExtendsData(RPCUtil.decode((String)((String)params.get("extend"))));
            MeetingRound round = this.roundManager.getRoundByIndex(chain, extendsData.getRoundIndex());
            if (round == null) {
                round = this.roundManager.getRound(chain, extendsData, false);
            }
            ArrayList<String> packAddressList = new ArrayList<String>();
            for (MeetingMember meetingMember : round.getMemberList()) {
                packAddressList.add(AddressTool.getStringAddressByBytes((byte[])meetingMember.getAgent().getPackingAddress()));
            }
            HashMap<String, ArrayList<String>> resultMap = new HashMap<String, ArrayList<String>>(2);
            resultMap.put("packAddressList", packAddressList);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(resultMap);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (Exception e) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
        }
    }

    @Override
    public Result getConsensusConfig(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        ConfigBean configBean = chain.getConfig();
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("seedNodes", configBean.getSeedNodes());
        map.put("inflationAmount", configBean.getInflationAmount());
        map.put("agentAssetId", configBean.getAgentAssetId());
        map.put("agentChainId", configBean.getAgentChainId());
        map.put("awardAssetId", configBean.getAwardAssetId());
        map.put("commissionMin", configBean.getCommissionMin());
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(map);
    }

    @Override
    public Result getAgentChangeInfo(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null || params.get("currentRound") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        BlockExtendsData lastExtendsData = null;
        String lastRoundStr = (String)params.get("lastRound");
        if (lastRoundStr != null) {
            lastExtendsData = new BlockExtendsData(RPCUtil.decode((String)lastRoundStr));
        }
        String currentRoundStr = (String)params.get("currentRound");
        BlockExtendsData currentExtendsData = new BlockExtendsData(RPCUtil.decode((String)currentRoundStr));
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(this.roundManager.getAgentChangeInfo(chain, lastExtendsData, currentExtendsData));
    }

    @Override
    public Result stopChain(Map<String, Object> params) {
        return null;
    }

    @Override
    public Result runChain(Map<String, Object> params) {
        return null;
    }

    @Override
    public Result runMainChain(Map<String, Object> params) {
        return null;
    }

    private boolean transactionCommit(Transaction tx, Chain chain, BlockHeader header) throws NulsException {
        switch (tx.getType()) {
            case 4: 
            case 20: {
                return this.agentManager.createAgentCommit(tx, header, chain);
            }
            case 9: 
            case 23: {
                return this.agentManager.stopAgentCommit(tx, header, chain);
            }
            case 5: 
            case 21: {
                return this.depositManager.depositCommit(tx, header, chain);
            }
            case 6: 
            case 22: {
                return this.depositManager.cancelDepositCommit(tx, header, chain);
            }
            case 7: {
                return this.punishManager.yellowPunishCommit(tx, chain, header);
            }
            case 8: {
                return this.punishManager.redPunishCommit(tx, chain, header);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private void transactionBatchRollBack(List<Transaction> txList, Chain chain, BlockHeader header) throws NulsException {
        for (Transaction tx : txList) {
            this.transactionRollback(tx, chain, header);
        }
    }

    private boolean transactionRollback(Transaction tx, Chain chain, BlockHeader header) throws NulsException {
        switch (tx.getType()) {
            case 4: 
            case 20: {
                return this.agentManager.createAgentRollBack(tx, chain);
            }
            case 9: 
            case 23: {
                return this.agentManager.stopAgentRollBack(tx, chain, header);
            }
            case 5: 
            case 21: {
                return this.depositManager.depositRollBack(tx, chain);
            }
            case 6: 
            case 22: {
                return this.depositManager.cancelDepositRollBack(tx, chain, header);
            }
            case 7: {
                return this.punishManager.yellowPunishRollback(tx, chain, header);
            }
            case 8: {
                return this.punishManager.redPunishRollback(tx, chain, header);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Result getSeedNodeList(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("seedNodeList", chain.getConfig().getSeedNodes().split(","));
        resultMap.put("inflationAmount", chain.getConfig().getInflationAmount().toString());
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(resultMap);
    }
}

