/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.service.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.CancelDeposit;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.dto.input.CreateDepositDTO;
import io.nuls.consensus.model.dto.input.SearchDepositDTO;
import io.nuls.consensus.model.dto.input.WithdrawDTO;
import io.nuls.consensus.model.dto.output.DepositDTO;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.service.DepositService;
import io.nuls.consensus.utils.TxUtil;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.CoinDataManager;
import io.nuls.consensus.utils.validator.TxValidator;
import io.nuls.core.basic.Page;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ObjectUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class DepositServiceImpl
implements DepositService {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private CoinDataManager coinDataManager;
    @Autowired
    private TxValidator validatorManager;

    @Override
    public Result depositToAgent(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        CreateDepositDTO dto = (CreateDepositDTO)JSONUtils.map2pojo(params, CreateDepositDTO.class);
        try {
            ObjectUtils.canNotEmpty((Object)dto);
            ObjectUtils.canNotEmpty((Object)dto.getAddress());
            ObjectUtils.canNotEmpty((Object)dto.getAgentHash());
            ObjectUtils.canNotEmpty((Object)dto.getDeposit());
        }
        catch (RuntimeException e) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        if (!NulsHash.validHash((String)dto.getAgentHash())) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            if (!AddressTool.validAddress((int)dto.getChainId(), (String)dto.getAddress())) {
                throw new NulsException(ConsensusErrorCode.ADDRESS_ERROR);
            }
            HashMap callResult = CallMethodUtils.accountValid(dto.getChainId(), dto.getAddress(), dto.getPassword());
            Transaction tx = new Transaction(5);
            Deposit deposit = TxUtil.createDeposit(dto);
            tx.setTxData(deposit.serialize());
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            CoinData coinData = this.coinDataManager.getCoinData(deposit.getAddress(), chain, new BigInteger(dto.getDeposit()), -1L, tx.size() + 110, chain.getConfig().getAgentChainId(), chain.getConfig().getAgentAssetId());
            tx.setCoinData(coinData.serialize());
            String priKey = (String)callResult.get("priKey");
            CallMethodUtils.transactionSignature(dto.getChainId(), dto.getAddress(), dto.getPassword(), priKey, tx);
            String txStr = RPCUtil.encode((byte[])tx.serialize());
            boolean validResult = this.validatorManager.validateTx(chain, tx);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            CallMethodUtils.sendTx(chain, txStr);
            HashMap<String, String> result = new HashMap<String, String>(16);
            result.put("txHash", tx.getHash().toHex());
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result depositValid(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("tx") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            String txHex = (String)params.get("tx");
            Transaction transaction = new Transaction(5);
            transaction.parse(RPCUtil.decode((String)txHex), 0);
            boolean result = this.validatorManager.validateTx(chain, transaction);
            if (!result) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(2);
            validResult.put("value", true);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(validResult);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
        }
    }

    @Override
    public Result withdraw(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        WithdrawDTO dto = (WithdrawDTO)JSONUtils.map2pojo(params, WithdrawDTO.class);
        if (!NulsHash.validHash((String)dto.getTxHash())) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            if (!AddressTool.validAddress((int)dto.getChainId(), (String)dto.getAddress())) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
            }
            HashMap callResult = CallMethodUtils.accountValid(dto.getChainId(), dto.getAddress(), dto.getPassword());
            NulsHash hash = NulsHash.fromHex((String)dto.getTxHash());
            Transaction depositTransaction = CallMethodUtils.getTransaction(chain, dto.getTxHash());
            if (depositTransaction == null) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_NOT_EXIST);
            }
            CoinData depositCoinData = new CoinData();
            depositCoinData.parse(depositTransaction.getCoinData(), 0);
            Deposit deposit = new Deposit();
            deposit.parse(depositTransaction.getTxData(), 0);
            boolean flag = false;
            for (CoinTo to : depositCoinData.getTo()) {
                if (to.getLockTime() != -1L || to.getAmount().compareTo(deposit.getDeposit()) != 0) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
            }
            Transaction cancelDepositTransaction = new Transaction(6);
            CancelDeposit cancelDeposit = new CancelDeposit();
            cancelDeposit.setAddress(AddressTool.getAddress((String)dto.getAddress()));
            cancelDeposit.setJoinTxHash(hash);
            cancelDepositTransaction.setTime(NulsDateUtils.getCurrentTimeSeconds());
            cancelDepositTransaction.setTxData(cancelDeposit.serialize());
            CoinData coinData = this.coinDataManager.getUnlockCoinData(cancelDeposit.getAddress(), chain, deposit.getDeposit(), 0L, cancelDepositTransaction.size() + 110);
            ((CoinFrom)coinData.getFrom().get(0)).setNonce(CallMethodUtils.getNonce(hash.getBytes()));
            cancelDepositTransaction.setCoinData(coinData.serialize());
            cancelDepositTransaction.setTime(NulsDateUtils.getCurrentTimeSeconds());
            String priKey = (String)callResult.get("priKey");
            CallMethodUtils.transactionSignature(dto.getChainId(), dto.getAddress(), dto.getPassword(), priKey, cancelDepositTransaction);
            String txStr = RPCUtil.encode((byte[])cancelDepositTransaction.serialize());
            boolean validResult = this.validatorManager.validateTx(chain, cancelDepositTransaction);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            CallMethodUtils.sendTx(chain, txStr);
            HashMap<String, String> result = new HashMap<String, String>(16);
            result.put("txHash", cancelDepositTransaction.getHash().toHex());
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result withdrawValid(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("tx") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            String txHex = (String)params.get("tx");
            Transaction transaction = new Transaction(6);
            transaction.parse(RPCUtil.decode((String)txHex), 0);
            boolean result = this.validatorManager.validateTx(chain, transaction);
            if (!result) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(2);
            validResult.put("value", true);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(validResult);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
        }
    }

    @Override
    public Result getDepositList(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        SearchDepositDTO dto = (SearchDepositDTO)JSONUtils.map2pojo(params, SearchDepositDTO.class);
        int pageNumber = dto.getPageNumber();
        int pageSize = dto.getPageSize();
        int chainId = dto.getChainId();
        if (pageNumber == 0) {
            pageNumber = 1;
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        if (pageNumber < 0 || pageSize < 0 || pageSize > 300 || chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        String address = dto.getAddress();
        String agentHash = dto.getAgentHash();
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        List<Deposit> depositList = chain.getDepositList();
        ArrayList<Deposit> handleList = new ArrayList<Deposit>();
        long startBlockHeight = chain.getNewestHeader().getHeight();
        byte[] addressBytes = null;
        if (StringUtils.isNotBlank((String)address)) {
            addressBytes = AddressTool.getAddress((String)address);
        }
        for (Deposit deposit : depositList) {
            if (deposit.getDelHeight() != -1L && deposit.getDelHeight() <= startBlockHeight || deposit.getBlockHeight() > startBlockHeight || deposit.getBlockHeight() < 0L || addressBytes != null && !Arrays.equals(deposit.getAddress(), addressBytes) || agentHash != null && !deposit.getAgentHash().toHex().equals(agentHash)) continue;
            handleList.add(deposit);
        }
        int start = pageNumber * pageSize - pageSize;
        int handleSize = handleList.size();
        Page page = new Page(pageNumber, pageSize, handleSize);
        if (start >= handleSize) {
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData((Object)page);
        }
        ArrayList<DepositDTO> resultList = new ArrayList<DepositDTO>();
        for (int i = start; i < handleSize && i < start + pageSize; ++i) {
            Deposit deposit = (Deposit)((Object)handleList.get(i));
            List<Agent> agentList = chain.getAgentList();
            Agent agent = null;
            for (Agent a : agentList) {
                if (!a.getTxHash().equals((Object)deposit.getAgentHash())) continue;
                agent = a;
                break;
            }
            deposit.setStatus(agent == null ? 0 : agent.getStatus());
            resultList.add(new DepositDTO(deposit, agent));
        }
        page.setList(resultList);
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData((Object)page);
    }
}

