/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.service.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.MultiSignTxSignature;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.CancelDeposit;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.bo.tx.txdata.StopAgent;
import io.nuls.consensus.model.dto.input.CreateMultiAgentDTO;
import io.nuls.consensus.model.dto.input.CreateMultiDepositDTO;
import io.nuls.consensus.model.dto.input.MultiWithdrawDTO;
import io.nuls.consensus.model.dto.input.StopMultiAgentDTO;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.service.MultiSignService;
import io.nuls.consensus.utils.TxUtil;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.CoinDataManager;
import io.nuls.consensus.utils.validator.TxValidator;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class MultiSignServiceImpl
implements MultiSignService {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private CoinDataManager coinDataManager;
    @Autowired
    private TxValidator txValidator;

    @Override
    public Result createMultiAgent(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        CreateMultiAgentDTO dto = (CreateMultiAgentDTO)JSONUtils.map2pojo(params, CreateMultiAgentDTO.class);
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            Log.error((String)ConsensusErrorCode.CHAIN_NOT_EXIST.getMsg());
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            MultiSigAccount multiSigAccount = CallMethodUtils.getMultiSignAccount(dto.getChainId(), dto.getAgentAddress());
            HashMap callResult = null;
            if (StringUtils.isNotBlank((String)dto.getSignAddress()) && StringUtils.isNotBlank((String)dto.getPassword())) {
                callResult = CallMethodUtils.accountValid(dto.getChainId(), dto.getSignAddress(), dto.getPassword());
            }
            Transaction tx = new Transaction(4);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            Agent agent = TxUtil.createAgent(dto);
            tx.setTxData(agent.serialize());
            int txSignSize = multiSigAccount.getM() * 110;
            CoinData coinData = this.coinDataManager.getCoinData(agent.getAgentAddress(), chain, new BigInteger(dto.getDeposit()), -1L, tx.size() + txSignSize, chain.getConfig().getAgentChainId(), chain.getConfig().getAgentAssetId());
            tx.setCoinData(coinData.serialize());
            String priKey = null;
            if (callResult != null && AddressTool.validSignAddress((List)multiSigAccount.getPubKeyList(), (byte[])HexUtil.decode((String)((String)callResult.get("pubKey"))))) {
                priKey = (String)callResult.get("priKey");
            }
            this.buildMultiSignTransactionSignature(tx, multiSigAccount, priKey);
            boolean validResult = this.txValidator.validateTx(chain, tx);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            String txStr = RPCUtil.encode((byte[])tx.serialize());
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            result.put("txHash", tx.getHash().toHex());
            result.put("tx", txStr);
            result.put("completed", false);
            if (callResult != null && multiSigAccount.getM() == 1) {
                CallMethodUtils.sendTx(chain, txStr);
                result.put("completed", true);
            }
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result stopMultiAgent(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        StopMultiAgentDTO dto = (StopMultiAgentDTO)JSONUtils.map2pojo(params, StopMultiAgentDTO.class);
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            Log.error((String)ConsensusErrorCode.CHAIN_NOT_EXIST.getMsg());
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            MultiSigAccount multiSigAccount = CallMethodUtils.getMultiSignAccount(dto.getChainId(), dto.getAddress());
            HashMap callResult = null;
            if (StringUtils.isNotBlank((String)dto.getSignAddress()) && StringUtils.isNotBlank((String)dto.getPassword())) {
                callResult = CallMethodUtils.accountValid(dto.getChainId(), dto.getSignAddress(), dto.getPassword());
            }
            Transaction tx = new Transaction(9);
            StopAgent stopAgent = new StopAgent();
            stopAgent.setAddress(AddressTool.getAddress((String)dto.getAddress()));
            List<Agent> agentList = chain.getAgentList();
            Agent agent = null;
            for (Agent a : agentList) {
                if (a.getDelHeight() > 0L || !Arrays.equals(a.getAgentAddress(), AddressTool.getAddress((String)dto.getAddress()))) continue;
                agent = a;
                break;
            }
            if (agent == null || agent.getDelHeight() > 0L) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.AGENT_NOT_EXIST);
            }
            stopAgent.setCreateTxHash(agent.getTxHash());
            tx.setTxData(stopAgent.serialize());
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            int txSignSize = multiSigAccount.getM() * 110;
            CoinData coinData = this.coinDataManager.getStopAgentCoinData(chain, agent, NulsDateUtils.getCurrentTimeSeconds() + chain.getConfig().getStopAgentLockTime());
            BigInteger fee = TransactionFeeCalculator.getConsensusTxFee((int)(tx.size() + txSignSize + coinData.serialize().length), (long)chain.getConfig().getFeeUnit(((CoinTo)coinData.getTo().get(0)).getAssetsChainId(), ((CoinTo)coinData.getTo().get(0)).getAssetsId()));
            ((CoinTo)coinData.getTo().get(0)).setAmount(((CoinTo)coinData.getTo().get(0)).getAmount().subtract(fee));
            tx.setCoinData(coinData.serialize());
            String priKey = null;
            if (callResult != null && AddressTool.validSignAddress((List)multiSigAccount.getPubKeyList(), (byte[])HexUtil.decode((String)((String)callResult.get("pubKey"))))) {
                priKey = (String)callResult.get("priKey");
            }
            this.buildMultiSignTransactionSignature(tx, multiSigAccount, priKey);
            boolean validResult = this.txValidator.validateTx(chain, tx);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            String txStr = RPCUtil.encode((byte[])tx.serialize());
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            result.put("txHash", tx.getHash().toHex());
            result.put("tx", txStr);
            result.put("completed", false);
            if (callResult != null && multiSigAccount.getM() == 1) {
                CallMethodUtils.sendTx(chain, txStr);
                result.put("completed", true);
            }
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result multiDeposit(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        CreateMultiDepositDTO dto = (CreateMultiDepositDTO)JSONUtils.map2pojo(params, CreateMultiDepositDTO.class);
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            Log.error((String)ConsensusErrorCode.CHAIN_NOT_EXIST.getMsg());
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            MultiSigAccount multiSigAccount = CallMethodUtils.getMultiSignAccount(dto.getChainId(), dto.getAddress());
            HashMap callResult = null;
            if (StringUtils.isNotBlank((String)dto.getSignAddress()) && StringUtils.isNotBlank((String)dto.getPassword())) {
                callResult = CallMethodUtils.accountValid(dto.getChainId(), dto.getSignAddress(), dto.getPassword());
            }
            Transaction tx = new Transaction(5);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            Deposit deposit = TxUtil.createDeposit(dto);
            tx.setTxData(deposit.serialize());
            int txSignSize = multiSigAccount.getM() * 110;
            CoinData coinData = this.coinDataManager.getCoinData(deposit.getAddress(), chain, new BigInteger(dto.getDeposit()), -1L, tx.size() + txSignSize, chain.getConfig().getAgentChainId(), chain.getConfig().getAgentAssetId());
            tx.setCoinData(coinData.serialize());
            String priKey = null;
            if (callResult != null && AddressTool.validSignAddress((List)multiSigAccount.getPubKeyList(), (byte[])HexUtil.decode((String)((String)callResult.get("pubKey"))))) {
                priKey = (String)callResult.get("priKey");
            }
            this.buildMultiSignTransactionSignature(tx, multiSigAccount, priKey);
            boolean validResult = this.txValidator.validateTx(chain, tx);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            String txStr = RPCUtil.encode((byte[])tx.serialize());
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            result.put("txHash", tx.getHash().toHex());
            result.put("tx", txStr);
            result.put("completed", false);
            if (callResult != null && multiSigAccount.getM() == 1) {
                CallMethodUtils.sendTx(chain, txStr);
                result.put("completed", true);
            }
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result multiWithdraw(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        MultiWithdrawDTO dto = (MultiWithdrawDTO)JSONUtils.map2pojo(params, MultiWithdrawDTO.class);
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            Log.error((String)ConsensusErrorCode.CHAIN_NOT_EXIST.getMsg());
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            MultiSigAccount multiSigAccount = CallMethodUtils.getMultiSignAccount(dto.getChainId(), dto.getAddress());
            HashMap callResult = null;
            if (StringUtils.isNotBlank((String)dto.getSignAddress()) && StringUtils.isNotBlank((String)dto.getPassword())) {
                callResult = CallMethodUtils.accountValid(dto.getChainId(), dto.getSignAddress(), dto.getPassword());
            }
            NulsHash hash = NulsHash.fromHex((String)dto.getTxHash());
            Transaction depositTransaction = CallMethodUtils.getTransaction(chain, dto.getTxHash());
            if (depositTransaction == null) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_NOT_EXIST);
            }
            CoinData depositCoinData = new CoinData();
            depositCoinData.parse(depositTransaction.getCoinData(), 0);
            Deposit deposit = new Deposit();
            deposit.parse(depositTransaction.getTxData(), 0);
            boolean flag = false;
            for (CoinTo to : depositCoinData.getTo()) {
                if (to.getLockTime() != -1L || to.getAmount().compareTo(deposit.getDeposit()) != 0) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
            }
            Transaction cancelDepositTransaction = new Transaction(6);
            CancelDeposit cancelDeposit = new CancelDeposit();
            cancelDeposit.setAddress(AddressTool.getAddress((String)dto.getAddress()));
            cancelDeposit.setJoinTxHash(hash);
            cancelDepositTransaction.setTime(NulsDateUtils.getCurrentTimeSeconds());
            cancelDepositTransaction.setTxData(cancelDeposit.serialize());
            int txSignSize = multiSigAccount.getM() * 110;
            CoinData coinData = this.coinDataManager.getUnlockCoinData(cancelDeposit.getAddress(), chain, deposit.getDeposit(), 0L, cancelDepositTransaction.size() + txSignSize);
            ((CoinFrom)coinData.getFrom().get(0)).setNonce(CallMethodUtils.getNonce(hash.getBytes()));
            cancelDepositTransaction.setCoinData(coinData.serialize());
            cancelDepositTransaction.setTime(NulsDateUtils.getCurrentTimeSeconds());
            String priKey = null;
            if (callResult != null && AddressTool.validSignAddress((List)multiSigAccount.getPubKeyList(), (byte[])HexUtil.decode((String)((String)callResult.get("pubKey"))))) {
                priKey = (String)callResult.get("priKey");
            }
            this.buildMultiSignTransactionSignature(cancelDepositTransaction, multiSigAccount, priKey);
            boolean validResult = this.txValidator.validateTx(chain, cancelDepositTransaction);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            String txStr = RPCUtil.encode((byte[])cancelDepositTransaction.serialize());
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            result.put("txHash", cancelDepositTransaction.getHash().toHex());
            result.put("tx", txStr);
            result.put("completed", false);
            if (callResult != null && multiSigAccount.getM() == 1) {
                CallMethodUtils.sendTx(chain, txStr);
                result.put("completed", true);
            }
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
    }

    private void buildMultiSignTransactionSignature(Transaction transaction, MultiSigAccount multiSigAccount, String priKey) throws NulsException {
        MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
        transactionSignature.setM(multiSigAccount.getM());
        transactionSignature.setPubKeyList(multiSigAccount.getPubKeyList());
        try {
            ArrayList<P2PHKSignature> p2PHKSignatures = new ArrayList<P2PHKSignature>();
            if (priKey != null && !priKey.isEmpty()) {
                P2PHKSignature p2PHKSignature = SignatureUtil.createSignatureByPriKey((Transaction)transaction, (String)priKey);
                p2PHKSignatures.add(p2PHKSignature);
            }
            transactionSignature.setP2PHKSignatures(p2PHKSignatures);
            transaction.setTransactionSignature(transactionSignature.serialize());
        }
        catch (IOException e) {
            throw new NulsException(ConsensusErrorCode.SERIALIZE_ERROR);
        }
    }
}

