/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.storage.impl;

import io.nuls.base.data.NulsHash;
import io.nuls.consensus.model.po.AgentPo;
import io.nuls.consensus.storage.AgentStorageService;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.rockdb.model.Entry;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.ArrayList;
import java.util.List;

@Component
public class AgentStorageServiceImpl
implements AgentStorageService {
    @Override
    public boolean save(AgentPo agentPo, int chainID) {
        if (agentPo == null || agentPo.getHash() == null) {
            return false;
        }
        try {
            byte[] key = agentPo.getHash().getBytes();
            byte[] value = agentPo.serialize();
            return RocksDBService.put((String)("consensus_agent" + chainID), (byte[])key, (byte[])value);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public AgentPo get(NulsHash hash, int chainID) {
        if (hash == null) {
            return null;
        }
        try {
            byte[] key = hash.getBytes();
            byte[] value = RocksDBService.get((String)("consensus_agent" + chainID), (byte[])key);
            if (value == null) {
                return null;
            }
            AgentPo agentPo = new AgentPo();
            agentPo.parse(value, 0);
            agentPo.setHash(hash);
            return agentPo;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean delete(NulsHash hash, int chainID) {
        if (hash == null) {
            return false;
        }
        try {
            byte[] key = hash.getBytes();
            return RocksDBService.delete((String)("consensus_agent" + chainID), (byte[])key);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public List<AgentPo> getList(int chainID) throws NulsException {
        List list = RocksDBService.entryList((String)("consensus_agent" + chainID));
        ArrayList<AgentPo> agentList = new ArrayList<AgentPo>();
        for (Entry entry : list) {
            AgentPo po = new AgentPo();
            po.parse((byte[])entry.getValue(), 0);
            NulsHash hash = new NulsHash((byte[])entry.getKey());
            po.setHash(hash);
            agentList.add(po);
        }
        return agentList;
    }

    @Override
    public int size(int chainID) {
        List keyList = RocksDBService.keyList((String)("consensus_agent" + chainID));
        if (keyList != null) {
            return keyList.size();
        }
        return 0;
    }
}

