/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.tx.v2;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.RedPunishData;
import io.nuls.consensus.model.bo.tx.txdata.StopAgent;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.utils.LoggerUtil;
import io.nuls.consensus.utils.manager.AgentManager;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.validator.TxValidator;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Component(value="StopAgentProcessorV2")
public class StopAgentProcessor
implements TransactionProcessor {
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private TxValidator txValidator;

    public int getType() {
        return 9;
    }

    public int getPriority() {
        return 6;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        List<Transaction> contractStopAgentTxList;
        Chain chain = this.chainManager.getChainMap().get(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            result.put("txList", txs);
            result.put("errorCode", ConsensusErrorCode.CHAIN_NOT_EXIST.getCode());
            return result;
        }
        ArrayList<Transaction> invalidTxList = new ArrayList<Transaction>();
        String errorCode = null;
        HashSet<String> redPunishAddressSet = new HashSet<String>();
        HashSet<NulsHash> hashSet = new HashSet<NulsHash>();
        List<Transaction> redPunishTxList = txMap.get(8);
        if (redPunishTxList != null && redPunishTxList.size() > 0) {
            for (Transaction transaction : redPunishTxList) {
                RedPunishData redPunishData = new RedPunishData();
                try {
                    redPunishData.parse(transaction.getTxData(), 0);
                    String addressHex = HexUtil.encode((byte[])redPunishData.getAddress());
                    redPunishAddressSet.add(addressHex);
                }
                catch (NulsException e) {
                    chain.getLogger().error(e);
                }
            }
        }
        if ((contractStopAgentTxList = txMap.get(23)) != null && contractStopAgentTxList.size() > 0) {
            try {
                for (Transaction contractStopAgentTx : contractStopAgentTxList) {
                    StopAgent stopAgent = new StopAgent();
                    stopAgent.parse(contractStopAgentTx.getTxData(), 0);
                    hashSet.add(stopAgent.getCreateTxHash());
                }
            }
            catch (Exception exception) {
                chain.getLogger().error(exception);
            }
        }
        for (Transaction stopAgentTx : txs) {
            try {
                long txTime;
                if (!this.txValidator.validateTx(chain, stopAgentTx)) {
                    invalidTxList.add(stopAgentTx);
                    chain.getLogger().info("Intelligent Contract Exit Node Trading Verification Failed");
                    continue;
                }
                long time = NulsDateUtils.getCurrentTimeSeconds();
                if (blockHeader != null) {
                    time = blockHeader.getTime();
                }
                if ((txTime = stopAgentTx.getTime()) > time + 3600L || txTime < time - 3600L) {
                    invalidTxList.add(stopAgentTx);
                    chain.getLogger().error("Trading time error,txTime:{},time:{}", new Object[]{txTime, time});
                    errorCode = ConsensusErrorCode.ERROR_UNLOCK_TIME.getCode();
                    continue;
                }
                CoinData coinData = new CoinData();
                coinData.parse(stopAgentTx.getCoinData(), 0);
                long unlockedTime = stopAgentTx.getTime() + chain.getConfig().getStopAgentLockTime();
                if (((CoinTo)coinData.getTo().get(0)).getLockTime() != unlockedTime) {
                    invalidTxList.add(stopAgentTx);
                    chain.getLogger().error("Error unlocking time");
                    errorCode = ConsensusErrorCode.ERROR_UNLOCK_TIME.getCode();
                    continue;
                }
                StopAgent stopAgent = new StopAgent();
                stopAgent.parse(stopAgentTx.getTxData(), 0);
                if (!hashSet.add(stopAgent.getCreateTxHash())) {
                    invalidTxList.add(stopAgentTx);
                    chain.getLogger().info("Repeated transactions");
                    errorCode = ConsensusErrorCode.CONFLICT_ERROR.getCode();
                    continue;
                }
                Agent agent = new Agent();
                if (stopAgent.getAddress() == null) {
                    Transaction createAgentTx = CallMethodUtils.getTransaction(chain, stopAgent.getCreateTxHash().toHex());
                    if (createAgentTx == null) {
                        invalidTxList.add(stopAgentTx);
                        chain.getLogger().info("The creation node transaction corresponding to intelligent contract cancellation node transaction does not exist");
                        errorCode = ConsensusErrorCode.CONFLICT_ERROR.getCode();
                        continue;
                    }
                    agent.parse(createAgentTx.getTxData(), 0);
                    stopAgent.setAddress(agent.getAgentAddress());
                }
                if (redPunishAddressSet.isEmpty() || !redPunishAddressSet.contains(HexUtil.encode((byte[])stopAgent.getAddress())) && !redPunishAddressSet.contains(HexUtil.encode((byte[])agent.getPackingAddress()))) continue;
                invalidTxList.add(stopAgentTx);
                chain.getLogger().info("Intelligent contract cancellation node transaction cancellation node does not exist");
                errorCode = ConsensusErrorCode.CONFLICT_ERROR.getCode();
            }
            catch (NulsException e) {
                invalidTxList.add(stopAgentTx);
                chain.getLogger().error("Intelligent Contract Creation Node Transaction Verification Failed");
                chain.getLogger().error(e);
                errorCode = e.getErrorCode().getCode();
            }
            catch (IOException io) {
                invalidTxList.add(stopAgentTx);
                chain.getLogger().error("Intelligent Contract Creation Node Transaction Verification Failed");
                chain.getLogger().error((Exception)io);
                errorCode = ConsensusErrorCode.SERIALIZE_ERROR.getCode();
            }
        }
        result.put("txList", invalidTxList);
        result.put("errorCode", errorCode);
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> commitSuccessList = new ArrayList<Transaction>();
        boolean commitResult = true;
        for (Transaction tx : txs) {
            try {
                if (!this.agentManager.stopAgentCommit(tx, blockHeader, chain)) continue;
                commitSuccessList.add(tx);
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to create node transaction submission");
                chain.getLogger().error(e);
                commitResult = false;
            }
        }
        if (!commitResult) {
            for (Transaction rollbackTx : commitSuccessList) {
                try {
                    this.agentManager.stopAgentRollBack(rollbackTx, chain, blockHeader);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to create node transaction rollback");
                    chain.getLogger().error(e);
                }
            }
        }
        return commitResult;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> rollbackSuccessList = new ArrayList<Transaction>();
        boolean rollbackResult = true;
        for (Transaction tx : txs) {
            try {
                if (!this.agentManager.stopAgentRollBack(tx, chain, blockHeader)) continue;
                rollbackSuccessList.add(tx);
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to stop agent transaction rollback");
                chain.getLogger().error(e);
                rollbackResult = false;
            }
        }
        if (!rollbackResult) {
            for (Transaction commitTx : rollbackSuccessList) {
                try {
                    this.agentManager.stopAgentCommit(commitTx, blockHeader, chain);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to stop agent transaction submission");
                    chain.getLogger().error(e);
                }
            }
        }
        return rollbackResult;
    }
}

