/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.manager;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.CancelDeposit;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.po.DepositPo;
import io.nuls.consensus.storage.DepositStorageService;
import io.nuls.consensus.utils.compare.DepositComparator;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Component
public class DepositManager {
    @Autowired
    private DepositStorageService depositStorageService;

    public void loadDeposits(Chain chain) throws Exception {
        ArrayList<Deposit> allDepositList = new ArrayList<Deposit>();
        List<DepositPo> poList = this.depositStorageService.getList(chain.getConfig().getChainId());
        for (DepositPo po : poList) {
            Deposit deposit = this.poToDeposit(po);
            allDepositList.add(deposit);
        }
        Collections.sort(allDepositList, new DepositComparator());
        chain.setDepositList(allDepositList);
    }

    public void addDeposit(Chain chain, Deposit deposit) {
        chain.getDepositList().add(deposit);
    }

    public void updateDeposit(Chain chain, Deposit deposit) {
        List<Deposit> depositList = chain.getDepositList();
        if (depositList.size() == 0) {
            depositList.add(deposit);
            return;
        }
        for (int index = 0; index < depositList.size(); ++index) {
            if (!deposit.getTxHash().equals((Object)depositList.get(index).getTxHash())) continue;
            depositList.set(index, deposit);
            break;
        }
    }

    public void removeDeposit(Chain chain, NulsHash txHash) throws Exception {
        List<Deposit> depositList = chain.getDepositList();
        if (depositList == null || depositList.size() == 0) {
            return;
        }
        for (Deposit deposit : depositList) {
            if (!txHash.equals((Object)deposit.getTxHash())) continue;
            depositList.remove((Object)deposit);
            return;
        }
    }

    public Deposit poToDeposit(DepositPo po) {
        Deposit deposit = new Deposit();
        deposit.setDeposit(po.getDeposit());
        deposit.setAgentHash(po.getAgentHash());
        deposit.setTime(po.getTime());
        deposit.setDelHeight(po.getDelHeight());
        deposit.setBlockHeight(po.getBlockHeight());
        deposit.setAddress(po.getAddress());
        deposit.setTxHash(po.getTxHash());
        return deposit;
    }

    public DepositPo depositToPo(Deposit deposit) {
        DepositPo po = new DepositPo();
        po.setTxHash(deposit.getTxHash());
        po.setAddress(deposit.getAddress());
        po.setAgentHash(deposit.getAgentHash());
        po.setBlockHeight(deposit.getBlockHeight());
        po.setDelHeight(deposit.getDelHeight());
        po.setDeposit(deposit.getDeposit());
        po.setTime(deposit.getTime());
        return po;
    }

    public boolean depositCommit(Transaction transaction, BlockHeader blockHeader, Chain chain) throws NulsException {
        Deposit deposit = new Deposit();
        deposit.parse(transaction.getTxData(), 0);
        deposit.setTxHash(transaction.getHash());
        deposit.setTime(transaction.getTime());
        deposit.setBlockHeight(blockHeader.getHeight());
        DepositPo depositPo = this.depositToPo(deposit);
        if (!this.depositStorageService.save(depositPo, chain.getConfig().getChainId())) {
            throw new NulsException(ConsensusErrorCode.SAVE_FAILED);
        }
        this.addDeposit(chain, deposit);
        return true;
    }

    public boolean depositRollBack(Transaction transaction, Chain chain) throws NulsException {
        if (!this.depositStorageService.delete(transaction.getHash(), chain.getConfig().getChainId())) {
            throw new NulsException(ConsensusErrorCode.ROLLBACK_FAILED);
        }
        try {
            this.removeDeposit(chain, transaction.getHash());
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
        return true;
    }

    public boolean cancelDepositCommit(Transaction transaction, BlockHeader header, Chain chain) throws NulsException {
        int chainId = chain.getConfig().getChainId();
        CancelDeposit cancelDeposit = new CancelDeposit();
        cancelDeposit.parse(transaction.getTxData(), 0);
        DepositPo po = this.depositStorageService.get(cancelDeposit.getJoinTxHash(), chainId);
        if (po == null) {
            throw new NulsException(ConsensusErrorCode.DATA_NOT_EXIST);
        }
        if (po.getDelHeight() > 0L) {
            throw new NulsException(ConsensusErrorCode.DEPOSIT_WAS_CANCELED);
        }
        po.setDelHeight(header.getHeight());
        if (!this.depositStorageService.save(po, chainId)) {
            throw new NulsException(ConsensusErrorCode.SAVE_FAILED);
        }
        this.updateDeposit(chain, this.poToDeposit(po));
        return true;
    }

    public boolean cancelDepositRollBack(Transaction transaction, Chain chain, BlockHeader header) throws NulsException {
        int chainId = chain.getConfig().getChainId();
        CancelDeposit cancelDeposit = new CancelDeposit();
        cancelDeposit.parse(transaction.getTxData(), 0);
        DepositPo po = this.depositStorageService.get(cancelDeposit.getJoinTxHash(), chainId);
        if (po == null) {
            throw new NulsException(ConsensusErrorCode.DATA_NOT_EXIST);
        }
        if (po.getDelHeight() != header.getHeight()) {
            throw new NulsException(ConsensusErrorCode.DEPOSIT_NEVER_CANCELED);
        }
        po.setDelHeight(-1L);
        if (!this.depositStorageService.save(po, chainId)) {
            throw new NulsException(ConsensusErrorCode.ROLLBACK_FAILED);
        }
        this.updateDeposit(chain, this.poToDeposit(po));
        return true;
    }
}

