/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.callable;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.contract.enums.CmdRegisterMode;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.model.bo.AnalyzerResult;
import io.nuls.contract.model.bo.BatchInfo;
import io.nuls.contract.model.bo.CallableResult;
import io.nuls.contract.model.bo.CallerResult;
import io.nuls.contract.model.bo.ContractContainer;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.dto.ContractPackageDto;
import io.nuls.contract.model.tx.ContractReturnGasTransaction;
import io.nuls.contract.model.tx.ContractTransferTransaction;
import io.nuls.contract.service.ResultAnalyzer;
import io.nuls.contract.service.ResultHanlder;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.contract.vm.program.ProgramInvokeRegisterCmd;
import io.nuls.contract.vm.program.ProgramNewTx;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.model.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class ContractBatchEndCallable
implements Callable<ContractPackageDto> {
    private int chainId;
    private int blockType;
    private long blockHeight;
    private ContractHelper contractHelper;
    private ResultAnalyzer resultAnalyzer;
    private ResultHanlder resultHanlder;

    public ContractBatchEndCallable(int chainId, int blockType, long blockHeight) {
        this.chainId = chainId;
        this.blockType = blockType;
        this.blockHeight = blockHeight;
        this.contractHelper = (ContractHelper)SpringLiteContext.getBean(ContractHelper.class);
        this.resultAnalyzer = (ResultAnalyzer)SpringLiteContext.getBean(ResultAnalyzer.class);
        this.resultHanlder = (ResultHanlder)SpringLiteContext.getBean(ResultHanlder.class);
    }

    @Override
    public ContractPackageDto call() {
        try {
            ChainManager.chainHandle(this.chainId, this.blockType);
            BatchInfo batchInfo = this.contractHelper.getChain(this.chainId).getBatchInfo();
            BlockHeader currentBlockHeader = batchInfo.getCurrentBlockHeader();
            long blockTime = currentBlockHeader.getTime();
            LinkedHashMap<String, ContractContainer> contractContainerMap = batchInfo.getContractContainerMap();
            Collection<ContractContainer> containerList = contractContainerMap.values();
            CallerResult callerResult = new CallerResult();
            List<CallableResult> resultList = callerResult.getCallableResultList();
            for (ContractContainer container : containerList) {
                container.loadFutureList();
                resultList.add(container.getCallableResult());
            }
            ProgramExecutor batchExecutor = batchInfo.getBatchExecutor();
            String preStateRoot = batchInfo.getPreStateRoot();
            AnalyzerResult analyzerResult = this.resultAnalyzer.analysis(callerResult.getCallableResultList());
            List<ContractResult> contractResultList = this.resultHanlder.handleAnalyzerResult(this.chainId, batchExecutor, analyzerResult, preStateRoot);
            ArrayList<byte[]> offlineTxHashList = new ArrayList<byte[]>();
            ArrayList<String> resultTxList = new ArrayList<String>();
            ArrayList<String> resultOrginTxList = new ArrayList<String>();
            for (ContractResult contractResult : contractResultList) {
                String newTx;
                String orginTxHash = contractResult.getHash();
                List<ProgramInvokeRegisterCmd> invokeRegisterCmds = contractResult.getInvokeRegisterCmds();
                for (ProgramInvokeRegisterCmd programInvokeRegisterCmd : invokeRegisterCmds) {
                    if (!programInvokeRegisterCmd.getCmdRegisterMode().equals((Object)CmdRegisterMode.NEW_TX)) continue;
                    ProgramNewTx programNewTx = programInvokeRegisterCmd.getProgramNewTx();
                    String newTxHash = programNewTx.getTxHash();
                    if (StringUtils.isNotBlank((String)newTxHash)) {
                        offlineTxHashList.add(RPCUtil.decode((String)newTxHash));
                    }
                    if (!StringUtils.isNotBlank((String)(newTx = programNewTx.getTxString()))) continue;
                    resultTxList.add(newTx);
                    resultOrginTxList.add(orginTxHash);
                }
                List<ContractTransferTransaction> contractTransferList = contractResult.getContractTransferList();
                for (Transaction transaction : contractTransferList) {
                    newTx = RPCUtil.encode((byte[])transaction.serialize());
                    contractResult.getContractTransferTxStringList().add(newTx);
                    resultTxList.add(newTx);
                    resultOrginTxList.add(orginTxHash);
                    offlineTxHashList.add(transaction.getHash().getBytes());
                }
            }
            ContractReturnGasTransaction contractReturnGasTx = this.contractHelper.makeReturnGasTx(contractResultList, blockTime);
            if (contractReturnGasTx != null) {
                resultTxList.add(RPCUtil.encode((byte[])contractReturnGasTx.serialize()));
            }
            ContractPackageDto dto = new ContractPackageDto(offlineTxHashList, resultTxList, resultOrginTxList);
            dto.makeContractResultMap(contractResultList);
            batchInfo.setContractPackageDto(dto);
            Log.info("[Before End Contract Execution Cost Time] BlockHeight is {}, Total Cost Time is {}", currentBlockHeader.getHeight(), System.currentTimeMillis() - batchInfo.getBeginTime());
            return dto;
        }
        catch (IOException e) {
            Log.error("", e);
            return null;
        }
        catch (InterruptedException e) {
            Log.error("", e);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            Log.error("", e);
            return null;
        }
        catch (Exception e) {
            Log.error("", e);
            return null;
        }
    }
}

