/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.helper;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinTo;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.helper.ContractNewTxFromOtherModuleHandler;
import io.nuls.contract.helper.ContractTransferHandler;
import io.nuls.contract.manager.ContractTempBalanceManager;
import io.nuls.contract.model.bo.ContractBalance;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.vm.program.ProgramAccount;
import io.nuls.contract.vm.program.ProgramNewTx;
import io.nuls.contract.vm.program.ProgramTransfer;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
public class ContractNewTxHandler {
    @Autowired
    private ContractTransferHandler contractTransferHandler;
    @Autowired
    private ContractNewTxFromOtherModuleHandler contractNewTxFromOtherModuleHandler;

    public boolean handleContractNewTx(int chainId, long blockTime, ContractWrapperTransaction tx, ContractResult contractResult, ContractTempBalanceManager tempBalanceManager) throws NulsException {
        Object rollbackTx;
        Iterator reverseIterator;
        BigInteger value;
        boolean mainAsset;
        Map<String, ProgramAccount> accountMap = contractResult.getAccounts();
        if (accountMap != null) {
            Set<Map.Entry<String, ProgramAccount>> entrySet = accountMap.entrySet();
            accountMap.values();
            for (Map.Entry<String, ProgramAccount> accountEntry : entrySet) {
                ProgramAccount account = accountEntry.getValue();
                byte[] contractBytes = account.getAddress();
                String nonce = account.getNonce();
                int assetChainId = account.getAssetChainId();
                int assetId = account.getAssetId();
                if (!StringUtils.isNotBlank((String)nonce)) continue;
                ContractBalance contractBalance = (ContractBalance)tempBalanceManager.getBalance(contractBytes, assetChainId, assetId).getData();
                if (StringUtils.isBlank((String)contractBalance.getPreNonce())) {
                    contractBalance.setPreNonce(contractBalance.getNonce());
                }
                contractBalance.setNonce(nonce);
            }
        }
        ContractData contractData = tx.getContractData();
        byte[] contractAddress = contractData.getContractAddress();
        CoinData coinData = tx.getCoinDataInstance();
        List toList = coinData.getTo();
        if (toList != null && !toList.isEmpty()) {
            for (CoinTo to : toList) {
                if (!Arrays.equals(to.getAddress(), contractAddress)) continue;
                int assetChainId = to.getAssetsChainId();
                int assetId = to.getAssetsId();
                mainAsset = assetChainId == ContractContext.LOCAL_CHAIN_ID && assetId == ContractContext.LOCAL_MAIN_ASSET_ID;
                if (mainAsset) continue;
                tempBalanceManager.getBalance(contractAddress, assetChainId, assetId);
                tempBalanceManager.addTempBalance(contractAddress, to.getAmount(), assetChainId, assetId);
            }
        }
        if ((value = contractData.getValue()).compareTo(BigInteger.ZERO) > 0) {
            tempBalanceManager.getBalance(contractAddress, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID);
            tempBalanceManager.addTempBalance(contractAddress, value, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID);
        }
        boolean isSuccess = true;
        List<Object> orderedInnerTxs = contractResult.getOrderedInnerTxs();
        LinkedList<Object> successedOrderedInnerTxs = new LinkedList<Object>();
        for (Object innerTx : orderedInnerTxs) {
            if (innerTx instanceof ProgramNewTx) {
                isSuccess = this.contractNewTxFromOtherModuleHandler.refreshTempBalance(chainId, contractResult.getContractAddress(), List.of((ProgramNewTx)innerTx), tempBalanceManager);
                if (!isSuccess) {
                    contractResult.setError(true);
                    contractResult.setErrorMessage("Refresh temp balance failed about new transaction from external cmd.");
                    break;
                }
                successedOrderedInnerTxs.add(innerTx);
                continue;
            }
            if (!(innerTx instanceof ProgramTransfer)) continue;
            isSuccess = this.contractTransferHandler.refreshTempBalance(chainId, List.of((ProgramTransfer)innerTx), tempBalanceManager);
            if (!isSuccess) {
                contractResult.setError(true);
                contractResult.setErrorMessage(String.format("Refresh temp balance failed about inner transfer out from contract[%s].", AddressTool.getStringAddressByBytes((byte[])contractResult.getContractAddress())));
                break;
            }
            successedOrderedInnerTxs.add(innerTx);
        }
        if (!isSuccess) {
            reverseIterator = successedOrderedInnerTxs.descendingIterator();
            while (reverseIterator.hasNext()) {
                rollbackTx = reverseIterator.next();
                if (rollbackTx instanceof ProgramNewTx) {
                    this.contractNewTxFromOtherModuleHandler.rollbackTempBalance(chainId, contractResult.getContractAddress(), List.of((ProgramNewTx)rollbackTx), tempBalanceManager);
                    continue;
                }
                if (!(rollbackTx instanceof ProgramTransfer)) continue;
                this.contractTransferHandler.rollbackContractTempBalance(chainId, List.of((ProgramTransfer)rollbackTx), tempBalanceManager);
            }
            contractResult.getTransfers().clear();
            contractResult.getInvokeRegisterCmds().clear();
        } else {
            isSuccess = this.contractTransferHandler.handleContractTransferTxs(chainId, blockTime, contractResult, tempBalanceManager);
            if (!isSuccess) {
                reverseIterator = successedOrderedInnerTxs.descendingIterator();
                while (reverseIterator.hasNext()) {
                    rollbackTx = reverseIterator.next();
                    if (!(rollbackTx instanceof ProgramNewTx)) continue;
                    this.contractNewTxFromOtherModuleHandler.rollbackTempBalance(chainId, contractResult.getContractAddress(), List.of((ProgramNewTx)rollbackTx), tempBalanceManager);
                }
                contractResult.getInvokeRegisterCmds().clear();
            }
        }
        if (!isSuccess) {
            if (value.compareTo(BigInteger.ZERO) > 0) {
                tempBalanceManager.minusTempBalance(contractAddress, value, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID);
            }
            if (toList != null && !toList.isEmpty()) {
                for (CoinTo to : toList) {
                    if (!Arrays.equals(to.getAddress(), contractAddress)) continue;
                    int assetChainId = to.getAssetsChainId();
                    int assetId = to.getAssetsId();
                    mainAsset = assetChainId == ContractContext.LOCAL_CHAIN_ID && assetId == ContractContext.LOCAL_MAIN_ASSET_ID;
                    if (mainAsset) continue;
                    tempBalanceManager.minusTempBalance(contractAddress, to.getAmount(), assetChainId, assetId);
                }
            }
        }
        return isSuccess;
    }
}

