/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.bo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.nuls.base.basic.AddressTool;
import io.nuls.contract.model.bo.ContractInternalCreate;
import io.nuls.contract.model.bo.ContractMergedTransfer;
import io.nuls.contract.model.bo.ContractMultyAssetMergedTransfer;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.tx.ContractTransferTransaction;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.vm.program.ProgramAccount;
import io.nuls.contract.vm.program.ProgramInternalCreate;
import io.nuls.contract.vm.program.ProgramInvokeRegisterCmd;
import io.nuls.contract.vm.program.ProgramTransfer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContractResult {
    private transient ContractWrapperTransaction tx;
    private String hash;
    private long txTime;
    private int txOrder;
    private long blockHeight;
    private byte[] sender;
    private byte[] contractAddress;
    private String result;
    private long gasUsed;
    private long price;
    private long value;
    private boolean revert;
    private boolean error;
    private String errorMessage;
    private String stackTrace;
    private boolean acceptDirectTransfer;
    private int tokenType;
    private boolean isNrc20;
    private String tokenName;
    private String tokenSymbol;
    private int tokenDecimals;
    private BigInteger tokenTotalSupply;
    private List<ProgramTransfer> transfers = new ArrayList<ProgramTransfer>();
    private List<ContractMergedTransfer> mergedTransferList = new ArrayList<ContractMergedTransfer>();
    private transient List<ContractTransferTransaction> contractTransferList = new ArrayList<ContractTransferTransaction>();
    private List<String> contractTransferTxStringList = new ArrayList<String>();
    private List<String> events = new ArrayList<String>();
    private List<String> debugEvents = new ArrayList<String>();
    private List<ProgramInvokeRegisterCmd> invokeRegisterCmds = new ArrayList<ProgramInvokeRegisterCmd>();
    private String remark;
    private boolean isTerminated;
    private Set<String> contractAddressInnerCallSet;
    private List<ContractMultyAssetMergedTransfer> mergerdMultyAssetTransferList = new ArrayList<ContractMultyAssetMergedTransfer>();
    private List<ContractInternalCreate> internalCreates = new ArrayList<ContractInternalCreate>();
    private transient List<ProgramInternalCreate> programInternalCreates = new ArrayList<ProgramInternalCreate>();
    private transient Object txTrack;
    private transient Map<String, ProgramAccount> accounts;
    private transient List<Object> orderedInnerTxs = new ArrayList<Object>();

    public List<ContractInternalCreate> getInternalCreates() {
        return this.internalCreates;
    }

    public void setInternalCreates(List<ContractInternalCreate> internalCreates) {
        this.internalCreates = internalCreates;
    }

    public List<ProgramInternalCreate> getProgramInternalCreates() {
        return this.programInternalCreates;
    }

    public void setProgramInternalCreates(List<ProgramInternalCreate> programInternalCreates) {
        this.programInternalCreates = programInternalCreates;
    }

    public Map<String, ProgramAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Map<String, ProgramAccount> accounts) {
        this.accounts = accounts;
    }

    public boolean isSuccess() {
        return !this.error && !this.revert;
    }

    @JsonIgnore
    public Object getTxTrack() {
        return this.txTrack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContractResult)) {
            return false;
        }
        ContractResult result = (ContractResult)o;
        return !(this.getHash() != null ? !this.getHash().equals(result.getHash()) : result.getHash() != null);
    }

    public int hashCode() {
        int result = this.getHash() != null ? this.getHash().hashCode() : 0;
        return result;
    }

    private static ContractResult genFailed(ContractData contractData) {
        ContractResult contractResult = new ContractResult();
        contractResult.setContractAddress(contractData.getContractAddress());
        contractResult.setGasUsed(contractData.getGasLimit());
        contractResult.setPrice(contractData.getPrice());
        contractResult.setSender(contractData.getSender());
        contractResult.setValue(contractData.getValue().longValue());
        contractResult.setError(true);
        contractResult.setRevert(true);
        return contractResult;
    }

    public static ContractResult genFailed(ContractData contractData, String msg) {
        ContractResult result = ContractResult.genFailed(contractData);
        result.setErrorMessage(msg);
        return result;
    }

    public String toString() {
        return "ContractResult{success='" + this.isSuccess() + "', hash='" + this.hash + "', txOrder=" + this.txOrder + ", txTime=" + this.txTime + ", sender=" + AddressTool.getStringAddressByBytes((byte[])this.sender) + ", contractAddress=" + AddressTool.getStringAddressByBytes((byte[])this.contractAddress) + ", result='" + this.result + "', gasUsed=" + this.gasUsed + ", price=" + this.price + ", value=" + this.value + ", revert=" + this.revert + ", error=" + this.error + ", errorMessage='" + this.errorMessage + "', stackTrace='" + this.stackTrace + "', acceptDirectTransfer=" + this.acceptDirectTransfer + ", isNrc20=" + this.isNrc20 + ", transfersSize=" + (this.transfers != null ? this.transfers.size() : 0) + ", mergedTransferList=" + (this.mergedTransferList != null ? this.mergedTransferList.size() : 0) + ", mergerdMultyAssetTransferList=" + (this.mergerdMultyAssetTransferList != null ? this.mergerdMultyAssetTransferList.size() : 0) + ", contractTransferList=" + (this.contractTransferList != null ? this.contractTransferList.size() : 0) + ", invokeRegisterCmds=" + (this.invokeRegisterCmds != null ? this.invokeRegisterCmds.size() : 0) + ", events=" + this.events + ", remark='" + this.remark + "', isTerminated=" + this.isTerminated + ", contractAddressInnerCallSet=" + (this.contractAddressInnerCallSet != null ? this.contractAddressInnerCallSet.size() : 0) + "}";
    }

    public ContractWrapperTransaction getTx() {
        return this.tx;
    }

    public void setTx(ContractWrapperTransaction tx) {
        this.tx = tx;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public long getTxTime() {
        return this.txTime;
    }

    public void setTxTime(long txTime) {
        this.txTime = txTime;
    }

    public int getTxOrder() {
        return this.txOrder;
    }

    public void setTxOrder(int txOrder) {
        this.txOrder = txOrder;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public byte[] getSender() {
        return this.sender;
    }

    public void setSender(byte[] sender) {
        this.sender = sender;
    }

    public byte[] getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(byte[] contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public long getGasUsed() {
        return this.gasUsed;
    }

    public void setGasUsed(long gasUsed) {
        this.gasUsed = gasUsed;
    }

    public long getPrice() {
        return this.price;
    }

    public void setPrice(long price) {
        this.price = price;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public boolean isRevert() {
        return this.revert;
    }

    public void setRevert(boolean revert) {
        this.revert = revert;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public boolean isAcceptDirectTransfer() {
        return this.acceptDirectTransfer;
    }

    public void setAcceptDirectTransfer(boolean acceptDirectTransfer) {
        this.acceptDirectTransfer = acceptDirectTransfer;
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(int tokenType) {
        this.tokenType = tokenType;
    }

    public boolean isNrc20() {
        return this.isNrc20;
    }

    public void setNrc20(boolean nrc20) {
        this.isNrc20 = nrc20;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public String getTokenSymbol() {
        return this.tokenSymbol;
    }

    public void setTokenSymbol(String tokenSymbol) {
        this.tokenSymbol = tokenSymbol;
    }

    public int getTokenDecimals() {
        return this.tokenDecimals;
    }

    public void setTokenDecimals(int tokenDecimals) {
        this.tokenDecimals = tokenDecimals;
    }

    public BigInteger getTokenTotalSupply() {
        return this.tokenTotalSupply;
    }

    public void setTokenTotalSupply(BigInteger tokenTotalSupply) {
        this.tokenTotalSupply = tokenTotalSupply;
    }

    public List<ProgramTransfer> getTransfers() {
        return this.transfers;
    }

    public void setTransfers(List<ProgramTransfer> transfers) {
        this.transfers = transfers;
    }

    public List<ContractMergedTransfer> getMergedTransferList() {
        return this.mergedTransferList;
    }

    public void setMergedTransferList(List<ContractMergedTransfer> mergedTransferList) {
        this.mergedTransferList = mergedTransferList;
    }

    public List<ContractMultyAssetMergedTransfer> getMergerdMultyAssetTransferList() {
        return this.mergerdMultyAssetTransferList;
    }

    public void setMergerdMultyAssetTransferList(List<ContractMultyAssetMergedTransfer> mergerdMultyAssetTransferList) {
        this.mergerdMultyAssetTransferList = mergerdMultyAssetTransferList;
    }

    public List<ContractTransferTransaction> getContractTransferList() {
        return this.contractTransferList;
    }

    public void setContractTransferList(List<ContractTransferTransaction> contractTransferList) {
        this.contractTransferList = contractTransferList;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    public List<String> getDebugEvents() {
        return this.debugEvents;
    }

    public void setDebugEvents(List<String> debugEvents) {
        this.debugEvents = debugEvents;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void setTerminated(boolean terminated) {
        this.isTerminated = terminated;
    }

    public Set<String> getContractAddressInnerCallSet() {
        return this.contractAddressInnerCallSet;
    }

    public void setContractAddressInnerCallSet(Set<String> contractAddressInnerCallSet) {
        this.contractAddressInnerCallSet = contractAddressInnerCallSet;
    }

    public void setTxTrack(Object txTrack) {
        this.txTrack = txTrack;
    }

    public List<ProgramInvokeRegisterCmd> getInvokeRegisterCmds() {
        return this.invokeRegisterCmds;
    }

    public void setInvokeRegisterCmds(List<ProgramInvokeRegisterCmd> invokeRegisterCmds) {
        this.invokeRegisterCmds = invokeRegisterCmds;
    }

    public List<Object> getOrderedInnerTxs() {
        return this.orderedInnerTxs;
    }

    public void setOrderedInnerTxs(List<Object> orderedInnerTxs) {
        this.orderedInnerTxs = orderedInnerTxs;
    }

    public List<String> getContractTransferTxStringList() {
        return this.contractTransferTxStringList;
    }

    public void setContractTransferTxStringList(List<String> contractTransferTxStringList) {
        this.contractTransferTxStringList = contractTransferTxStringList;
    }
}

