/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.NulsHash;
import io.nuls.contract.model.bo.ContractMergedTransfer;
import io.nuls.contract.model.bo.Output;
import io.nuls.contract.model.dto.ContractOutputDto;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.TypeDescriptor;
import java.util.ArrayList;
import java.util.List;

@ApiModel
public class ContractMergedTransferDto {
    @ApiModelProperty(description="Contract generation transaction\uff1aContract transfer transactionhash")
    private String txHash;
    @ApiModelProperty(description="Transferred contract address")
    private String from;
    @ApiModelProperty(description="Transfer amount")
    private String value;
    @ApiModelProperty(description="Transferred address list", type=@TypeDescriptor(value=List.class, collectionElement=ContractOutputDto.class))
    private List<ContractOutputDto> outputs;
    @ApiModelProperty(description="Call contract transactionshash\uff08Source transactionhashContract trading is derived from calling contract trading\uff09")
    private String orginTxHash;

    public ContractMergedTransferDto() {
    }

    public ContractMergedTransferDto(ContractMergedTransfer transfer) {
        this.from = AddressTool.getStringAddressByBytes((byte[])transfer.getFrom());
        this.value = ContractUtil.bigInteger2String(transfer.getValue());
        NulsHash thatHash = transfer.getHash();
        this.txHash = thatHash == null ? null : thatHash.toHex();
        NulsHash thatOrginTxHash = transfer.getOrginHash();
        this.orginTxHash = thatOrginTxHash == null ? null : thatOrginTxHash.toHex();
        this.makeOutputs(transfer.getOutputs());
    }

    private void makeOutputs(List<Output> outputs) {
        if (outputs != null && !outputs.isEmpty()) {
            this.outputs = new ArrayList<ContractOutputDto>(outputs.size());
            for (Output output : outputs) {
                this.outputs.add(new ContractOutputDto(output));
            }
        }
    }

    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<ContractOutputDto> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ContractOutputDto> outputs) {
        this.outputs = outputs;
    }

    public String getOrginTxHash() {
        return this.orginTxHash;
    }

    public void setOrginTxHash(String orginTxHash) {
        this.orginTxHash = orginTxHash;
    }
}

