/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinFrom;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel
public class InputDto {
    @ApiModelProperty(description="Enter address")
    private String address;
    @ApiModelProperty(description="Asset ChainID")
    private int assetsChainId;
    @ApiModelProperty(description="assetID")
    private int assetsId;
    @ApiModelProperty(description="Spending amount")
    private String amount;
    @ApiModelProperty(description="Address ledgernoncevalue")
    private String nonce;
    @ApiModelProperty(description="Unlock transaction tags\uff080 - Non unlocked transactions,1 - Unlock transaction\uff09")
    private byte locked;

    public InputDto(CoinFrom from) {
        this.address = AddressTool.getStringAddressByBytes((byte[])from.getAddress());
        this.assetsChainId = from.getAssetsChainId();
        this.assetsId = from.getAssetsId();
        this.amount = ContractUtil.bigInteger2String(from.getAmount());
        this.nonce = RPCUtil.encode((byte[])from.getNonce());
        this.locked = from.getLocked();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getAssetsChainId() {
        return this.assetsChainId;
    }

    public void setAssetsChainId(int assetsChainId) {
        this.assetsChainId = assetsChainId;
    }

    public int getAssetsId() {
        return this.assetsId;
    }

    public void setAssetsId(int assetsId) {
        this.assetsId = assetsId;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public byte getLocked() {
        return this.locked;
    }

    public void setLocked(byte locked) {
        this.locked = locked;
    }
}

