/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.rpc.call;

import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.HashMap;
import java.util.Map;

public class ChainManagerCall {
    public static boolean isCrossAssets(int chainId, int assetId) throws NulsException {
        HashMap<String, Integer> params = new HashMap<String, Integer>(4);
        params.put("chainId", chainId);
        params.put("assetId", assetId);
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CM.abbr, (String)"cm_asset", params);
            return callResp.isSuccess();
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static int getCrossAssetsDecimals(int chainId, int assetId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>(4);
        params.put("chainId", chainId);
        params.put("assetId", assetId);
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CM.abbr, (String)"cm_asset", params);
            if (!callResp.isSuccess()) {
                return 0;
            }
            Map resData = (Map)callResp.getResponseData();
            Map resultMap = (Map)resData.get("cm_asset");
            Object decimalPlaces = resultMap.get("decimalPlaces");
            if (decimalPlaces == null) {
                return 0;
            }
            return Integer.parseInt(decimalPlaces.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }
}

