/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.rpc.call;

import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.util.Log;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LedgerCall {
    public static Map<String, Object> getBalanceAndNonce(Chain chain, int assetChainId, int assetId, String address) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chain.getConfig().getChainId());
        params.put("assetChainId", assetChainId);
        params.put("assetId", assetId);
        params.put("address", address);
        params.put("isConfirmed", false);
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"getBalanceNonce", params);
            if (!callResp.isSuccess()) {
                return null;
            }
            return (HashMap)((HashMap)callResp.getResponseData()).get("getBalanceNonce");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static Map<String, Object> getConfirmedBalanceAndNonce(Chain chain, int assetChainId, int assetId, String address) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chain.getConfig().getChainId());
        params.put("assetChainId", assetChainId);
        params.put("assetId", assetId);
        params.put("address", address);
        params.put("isConfirmed", true);
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"getBalanceNonce", params);
            if (!callResp.isSuccess()) {
                return null;
            }
            return (HashMap)((HashMap)callResp.getResponseData()).get("getBalanceNonce");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static Map commitNRC20Assets(int chainId, String name, String symbol, short decimal, BigInteger totalSupply, String nrc20ContractAddress) throws NulsException {
        String cmd = "chainAssetContractReg";
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chainId);
            params.put("assetName", name);
            params.put("initNumber", totalSupply.toString());
            params.put("decimalPlace", decimal);
            params.put("assetSymbol", symbol);
            params.put("contractAddress", nrc20ContractAddress);
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)cmd, params);
            if (!callResp.isSuccess()) {
                Log.error("Call interface [{}] error, ErrorCode is {}, ResponseComment:{}", cmd, callResp.getResponseErrorCode(), callResp.getResponseComment());
                return null;
            }
            HashMap result = (HashMap)((HashMap)callResp.getResponseData()).get(cmd);
            return result;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static boolean rollBackNRC20Assets(int chainId, String nrc20ContractAddress) throws NulsException {
        String cmd = "chainAssetContractRollBack";
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chainId);
            params.put("contractAddress", nrc20ContractAddress);
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)cmd, params);
            if (!callResp.isSuccess()) {
                Log.error("Call interface [{}] error, ErrorCode is {}, ResponseComment:{}", cmd, callResp.getResponseErrorCode(), callResp.getResponseComment());
                return false;
            }
            HashMap result = (HashMap)((HashMap)callResp.getResponseData()).get(cmd);
            return Boolean.parseBoolean(result.get("value").toString());
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static List<Map> getRegTokenList(int chainId) throws NulsException {
        String cmd = "getAssetRegInfo";
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>(4);
            params.put("chainId", chainId);
            params.put("assetType", 2);
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)cmd, params);
            if (!callResp.isSuccess()) {
                Log.error("Call interface [{}] error, ErrorCode is {}, ResponseComment:{}", cmd, callResp.getResponseErrorCode(), callResp.getResponseComment());
                return null;
            }
            Map resultMap = (Map)((HashMap)callResp.getResponseData()).get(cmd);
            List resultList = (List)resultMap.get("assets");
            return resultList;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }
}

