/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.service.impl;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.contract.callable.ContractBatchEndCallable;
import io.nuls.contract.callable.ContractTxCallable;
import io.nuls.contract.helper.ContractConflictChecker;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.helper.ContractNewTxHandler;
import io.nuls.contract.manager.ContractTempBalanceManager;
import io.nuls.contract.model.bo.BatchInfo;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.ContractContainer;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.dto.ContractPackageDto;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.service.ContractCaller;
import io.nuls.contract.service.ContractExecutor;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.thread.commom.NulsThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Component
public class ContractCallerImpl
implements ContractCaller {
    private static ExecutorService TX_EXECUTOR_SERVICE;
    private static final ExecutorService BATCH_END_SERVICE;
    @Autowired
    private ContractExecutor contractExecutor;
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ContractNewTxHandler contractNewTxHandler;

    @Override
    public Result callTx(int chainId, ContractContainer container, ProgramExecutor batchExecutor, ContractWrapperTransaction tx, String preStateRoot) {
        try {
            ContractData contractData = tx.getContractData();
            Integer blockType = Chain.currentThreadBlockType();
            byte[] contractAddressBytes = contractData.getContractAddress();
            String contract = AddressTool.getStringAddressByBytes((byte[])contractAddressBytes);
            BatchInfo batchInfo = this.contractHelper.getChain(chainId).getBatchInfo();
            ContractConflictChecker checker = batchInfo.getChecker();
            BlockHeader currentBlockHeader = batchInfo.getCurrentBlockHeader();
            long blockTime = currentBlockHeader.getTime();
            long lastestHeight = currentBlockHeader.getHeight() - 1L;
            ContractTxCallable txCallable = new ContractTxCallable(chainId, blockType, blockTime, batchExecutor, contract, tx, lastestHeight, preStateRoot, checker, container);
            Future<ContractResult> contractResultFuture = TX_EXECUTOR_SERVICE.submit(txCallable);
            String hash = tx.getHash().toHex();
            batchInfo.getContractMap().put(hash, contractResultFuture);
            if (Log.isDebugEnabled()) {
                Log.debug("contract-tx-executor-pool put hash [{}]", hash);
            }
            container.getFutureList().add(contractResultFuture);
            return ContractUtil.getSuccess();
        }
        catch (Exception e) {
            Log.error(e);
            return ContractUtil.getFailed();
        }
    }

    @Override
    public Result callBatchEnd(int chainId, long blockHeight) {
        try {
            Log.info("[Call Before End] contract batch, blockHeight is {}", blockHeight);
            BatchInfo batchInfo = this.contractHelper.getChain(chainId).getBatchInfo();
            Integer blockType = Chain.currentThreadBlockType();
            ContractBatchEndCallable callable = new ContractBatchEndCallable(chainId, blockType, blockHeight);
            Future<ContractPackageDto> contractPackageDtoFuture = BATCH_END_SERVICE.submit(callable);
            batchInfo.setContractPackageDtoFuture(contractPackageDtoFuture);
            batchInfo.setBeforeEndTime(System.currentTimeMillis());
            return ContractUtil.getSuccess();
        }
        catch (Exception e) {
            Log.error(e);
            return ContractUtil.getFailed();
        }
    }

    @Override
    public List<ContractResult> reCallTx(ProgramExecutor batchExecutor, List<ContractWrapperTransaction> reCallTxList, int chainId, String preStateRoot) throws NulsException {
        BlockHeader currentBlockHeader = this.contractHelper.getBatchInfoCurrentBlockHeader(chainId);
        long blockTime = currentBlockHeader.getTime();
        long lastestHeight = currentBlockHeader.getHeight() - 1L;
        ContractTempBalanceManager tempBalanceManager = this.contractHelper.getBatchInfoTempBalanceManager(chainId);
        ArrayList<ContractResult> resultList = new ArrayList<ContractResult>();
        for (ContractWrapperTransaction tx : reCallTxList) {
            Log.info("[ReCall] Tx hash is {}", tx.getHash().toHex());
            ContractData contractData = tx.getContractData();
            switch (tx.getType()) {
                case 16: {
                    ContractResult contractResult = this.contractExecutor.call(batchExecutor, contractData, lastestHeight, preStateRoot, ContractUtil.extractPublicKey(tx));
                    ContractUtil.makeContractResult(tx, contractResult);
                    if (contractResult.isSuccess()) {
                        this.contractNewTxHandler.handleContractNewTx(chainId, blockTime, tx, contractResult, tempBalanceManager);
                    }
                    this.commitContract(contractResult);
                    resultList.add(contractResult);
                    break;
                }
            }
        }
        return resultList;
    }

    private void commitContract(ContractResult contractResult) {
        if (!contractResult.isSuccess()) {
            return;
        }
        Object txTrackObj = contractResult.getTxTrack();
        if (txTrackObj != null && txTrackObj instanceof ProgramExecutor) {
            ProgramExecutor txTrack = (ProgramExecutor)txTrackObj;
            txTrack.commit();
            if (Log.isDebugEnabled()) {
                Log.debug("One of reCall's Batch contract[{}] commit", AddressTool.getStringAddressByBytes((byte[])contractResult.getContractAddress()));
            }
        }
    }

    static {
        int threadCount = 4;
        TX_EXECUTOR_SERVICE = new ThreadPoolExecutor(threadCount, threadCount, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NulsThreadFactory("contract-tx-executor-pool"));
        BATCH_END_SERVICE = Executors.newSingleThreadExecutor((ThreadFactory)new NulsThreadFactory("contract-batch-end-pool"));
    }
}

