/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.storage.impl;

import io.nuls.base.data.NulsHash;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.storage.ContractExecuteResultStorageService;
import io.nuls.contract.util.ContractDBUtil;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rockdb.service.RocksDBService;

@Component
public class ContractExecuteResultStorageServiceImpl
implements ContractExecuteResultStorageService {
    private final String baseArea = "contract_execute_result_";

    @Override
    public Result saveContractExecuteResult(int chainId, NulsHash hash, ContractResult executeResult) {
        try {
            boolean result = ContractDBUtil.putModel("contract_execute_result_" + chainId, hash.getBytes(), executeResult);
            if (result) {
                return ContractUtil.getSuccess();
            }
            return ContractUtil.getFailed();
        }
        catch (Exception e) {
            Log.error("save contract execute result error", e);
            return ContractUtil.getFailed();
        }
    }

    @Override
    public Result deleteContractExecuteResult(int chainId, NulsHash hash) {
        try {
            boolean result = RocksDBService.delete((String)("contract_execute_result_" + chainId), (byte[])hash.getBytes());
            if (result) {
                return ContractUtil.getSuccess();
            }
            return ContractUtil.getFailed();
        }
        catch (Exception e) {
            Log.error("delete contract execute result error", e);
            return ContractUtil.getFailed();
        }
    }

    @Override
    public boolean isExistContractExecuteResult(int chainId, NulsHash hash) {
        if (hash == null) {
            return false;
        }
        byte[] contractExecuteResult = new byte[]{};
        try {
            contractExecuteResult = RocksDBService.get((String)("contract_execute_result_" + chainId), (byte[])hash.getBytes());
        }
        catch (Exception e) {
            Log.error("check contract execute result error", e);
            return false;
        }
        return contractExecuteResult != null;
    }

    @Override
    public ContractResult getContractExecuteResult(int chainId, NulsHash hash) {
        if (hash == null) {
            return null;
        }
        try {
            return ContractDBUtil.getModel("contract_execute_result_" + chainId, hash.getBytes(), ContractResult.class);
        }
        catch (Exception e) {
            Log.error("get contract execute result error", e);
            return null;
        }
    }
}

