/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.tx.common;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.CommonAdvice;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.enums.BlockType;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.model.bo.BatchInfoV8;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.dto.ContractPackageDto;
import io.nuls.contract.model.po.ContractOfflineTxHashPo;
import io.nuls.contract.storage.ContractOfflineTxHashListStorageService;
import io.nuls.contract.tx.v1.CallContractProcessor;
import io.nuls.contract.tx.v8.CallContractProcessorV8;
import io.nuls.contract.util.Log;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class TransactionCommitAdvice
implements CommonAdvice {
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ContractOfflineTxHashListStorageService contractOfflineTxHashListStorageService;
    @Autowired
    private CallContractProcessor callContractProcessor;
    @Autowired
    private CallContractProcessorV8 callContractProcessorV8;

    public void begin(int chainId, List<Transaction> txList, BlockHeader header) {
        Log.info("height: {} call begin", header != null ? header.getHeight() : 0L);
        try {
            ChainManager.chainHandle(chainId, BlockType.VERIFY_BLOCK.type());
            Short currentVersion = ProtocolGroupManager.getCurrentVersion((int)chainId);
            if (currentVersion >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
                BatchInfoV8 batchInfo = this.contractHelper.getChain(chainId).getBatchInfoV8();
                if (batchInfo != null) {
                    Log.info("height: {}, contract execute txDataSize is {}, commit txDataSize is {}", header != null ? header.getHeight() : 0L, batchInfo.getContractResultMap().size(), txList.size());
                    List<byte[]> offlineTxHashList = batchInfo.getOfflineTxHashList();
                    if (offlineTxHashList != null && !offlineTxHashList.isEmpty()) {
                        this.contractOfflineTxHashListStorageService.saveOfflineTxHashList(chainId, header.getHash().getBytes(), new ContractOfflineTxHashPo(offlineTxHashList));
                    }
                }
            } else {
                ContractPackageDto contractPackageDto = this.contractHelper.getChain(chainId).getBatchInfo().getContractPackageDto();
                if (contractPackageDto != null) {
                    Log.info("height: {}, contract execute txDataSize is {}, commit txDataSize is {}", header != null ? header.getHeight() : 0L, contractPackageDto.getContractResultMap().keySet().size(), txList.size());
                    List<byte[]> offlineTxHashList = contractPackageDto.getOfflineTxHashList();
                    if (offlineTxHashList != null && !offlineTxHashList.isEmpty()) {
                        this.contractOfflineTxHashListStorageService.saveOfflineTxHashList(chainId, header.getHash().getBytes(), new ContractOfflineTxHashPo(contractPackageDto.getOfflineTxHashList()));
                    }
                }
            }
            if (currentVersion >= ContractContext.UPDATE_VERSION_V250) {
                List<Transaction> crossTxList = txList.stream().filter(tx -> tx.getType() == 10).collect(Collectors.toList());
                if (currentVersion >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
                    this.callContractProcessorV8.commit(chainId, crossTxList, header);
                } else {
                    this.callContractProcessor.commit(chainId, crossTxList, header);
                }
            }
        }
        catch (Exception e) {
            Log.error(e);
            throw new RuntimeException(e);
        }
    }

    public void end(int chainId, List<Transaction> txList, BlockHeader blockHeader) {
        Log.info("height: {} call end", blockHeader != null ? blockHeader.getHeight() : 0L);
        Chain chain = this.contractHelper.getChain(chainId);
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
            chain.setBatchInfoV8(null);
        } else {
            chain.setBatchInfo(null);
        }
    }
}

