/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.tx.v13;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.model.bo.BatchInfoV8;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.tx.CallContractTransaction;
import io.nuls.contract.model.txdata.CallContractData;
import io.nuls.contract.processor.CallContractTxProcessor;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.validator.CallContractTxValidator;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="CallContractProcessorV13")
public class CallContractProcessorV13
implements TransactionProcessor {
    @Autowired
    private CallContractTxProcessor callContractTxProcessor;
    @Autowired
    private CallContractTxValidator callContractTxValidator;
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ChainManager chainManager;

    public int getType() {
        return 16;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        ChainManager.chainHandle(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Transaction> errorList = new ArrayList<Transaction>();
        result.put("txList", errorList);
        String errorCode = null;
        for (Transaction tx : txs) {
            CallContractTransaction callTx = new CallContractTransaction();
            callTx.copyTx(tx);
            try {
                Result validate = this.callContractTxValidator.validateV13(chainId, callTx);
                if (!validate.isFailed()) continue;
                errorCode = validate.getErrorCode().getCode();
                errorList.add(tx);
            }
            catch (NulsException e) {
                Log.error(e);
                errorCode = e.getErrorCode().getCode();
                errorList.add(tx);
            }
        }
        result.put("errorCode", errorCode);
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader header) {
        try {
            BatchInfoV8 batchInfo = this.contractHelper.getChain(chainId).getBatchInfoV8();
            if (batchInfo != null) {
                Map<String, ContractResult> contractResultMap = batchInfo.getContractResultMap();
                for (Transaction tx : txs) {
                    String txHash = tx.getHash().toString();
                    ContractResult contractResult = contractResultMap.get(txHash);
                    if (contractResult == null) {
                        Log.warn("empty contract result with txHash: {}, txType: {}", txHash, tx.getType());
                        continue;
                    }
                    ContractWrapperTransaction wrapperTx = contractResult.getTx();
                    wrapperTx.setContractResult(contractResult);
                    this.callContractTxProcessor.onCommitV8(chainId, wrapperTx);
                }
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        try {
            ChainManager.chainHandle(chainId);
            for (Transaction tx : txs) {
                CallContractData call;
                if (tx.getType() == 10) {
                    if (ProtocolGroupManager.getCurrentVersion((int)chainId) < ContractContext.UPDATE_VERSION_V250 || (call = ContractUtil.parseCrossChainTx(tx, this.chainManager)) == null) {
                        continue;
                    }
                } else {
                    call = new CallContractData();
                    call.parse(tx.getTxData(), 0);
                }
                this.callContractTxProcessor.onRollbackV8(chainId, new ContractWrapperTransaction(tx, call));
            }
            return true;
        }
        catch (NulsException e) {
            Log.error(e);
            return false;
        }
    }
}

