/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.util;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.base.signture.MultiSignTxSignature;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.enums.TokenTypeStatus;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.model.bo.BatchInfo;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractTempTransaction;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.dto.AccountAmountDto;
import io.nuls.contract.model.dto.ContractTokenTransferInfo;
import io.nuls.contract.model.po.ContractAddressInfoPo;
import io.nuls.contract.model.po.ContractTokenTransferInfoPo;
import io.nuls.contract.model.tx.CallContractTransaction;
import io.nuls.contract.model.tx.ContractBaseTransaction;
import io.nuls.contract.model.tx.ContractReturnGasTransaction;
import io.nuls.contract.model.tx.ContractTransferTransaction;
import io.nuls.contract.model.tx.CreateContractTransaction;
import io.nuls.contract.model.tx.CrossTokenContractTransaction;
import io.nuls.contract.model.tx.DeleteContractTransaction;
import io.nuls.contract.model.txdata.CallContractData;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.model.txdata.CreateContractData;
import io.nuls.contract.model.txdata.DeleteContractData;
import io.nuls.contract.rpc.call.BlockCall;
import io.nuls.contract.rpc.call.ChainManagerCall;
import io.nuls.contract.util.CompareTxTimeDesc;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramMethod;
import io.nuls.contract.vm.program.ProgramMethodArg;
import io.nuls.contract.vm.program.ProgramMultyAssetValue;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.message.MessageUtil;
import io.nuls.core.rpc.model.message.Response;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ContractUtil {
    public static String[][] twoDimensionalArray(Object[] args, String[] types) {
        if (args == null) {
            return null;
        }
        if (types != null && types.length != args.length) {
            throw new NulsRuntimeException(ContractErrorCode.PARAMETER_ERROR);
        }
        int length = args.length;
        String[][] two = new String[length][];
        for (int i = 0; i < length; ++i) {
            Object arg = args[i];
            if (arg == null) {
                two[i] = new String[0];
                continue;
            }
            if (arg instanceof String) {
                String argStr = (String)arg;
                if (types != null && StringUtils.isBlank((String)argStr) && !"String".equalsIgnoreCase(types[i])) {
                    two[i] = new String[0];
                    continue;
                }
                two[i] = new String[]{argStr};
                continue;
            }
            if (arg.getClass().isArray()) {
                int len = Array.getLength(arg);
                String[] result = new String[len];
                for (int k = 0; k < len; ++k) {
                    result[k] = ContractUtil.valueOf(Array.get(arg, k));
                }
                two[i] = result;
                continue;
            }
            if (arg instanceof ArrayList) {
                ArrayList resultArg = (ArrayList)arg;
                int size = resultArg.size();
                String[] result = new String[size];
                for (int k = 0; k < size; ++k) {
                    result[k] = ContractUtil.valueOf(resultArg.get(k));
                }
                two[i] = result;
                continue;
            }
            two[i] = new String[]{ContractUtil.valueOf(arg)};
        }
        return two;
    }

    public static byte[] extractContractAddressFromTxData(Transaction tx) {
        if (tx == null) {
            return null;
        }
        int txType = tx.getType();
        if (txType == 15 || txType == 16 || txType == 17) {
            return ContractUtil.extractContractAddressFromTxData(tx.getTxData());
        }
        return null;
    }

    private static byte[] extractContractAddressFromTxData(byte[] txData) {
        if (txData == null) {
            return null;
        }
        int length = txData.length;
        if (length < 46) {
            return null;
        }
        byte[] contractAddress = new byte[23];
        System.arraycopy(txData, 23, contractAddress, 0, 23);
        return contractAddress;
    }

    public static ContractWrapperTransaction parseContractTransaction(ContractTempTransaction tx, ChainManager chainManager) throws NulsException {
        ContractWrapperTransaction contractTransaction = null;
        BaseNulsData contractData = null;
        boolean isContractTx = true;
        switch (tx.getType()) {
            case 16: {
                CallContractData call = new CallContractData();
                call.parse(tx.getTxData(), 0);
                contractData = call;
                break;
            }
            case 15: {
                CreateContractData create = new CreateContractData();
                create.parse(tx.getTxData(), 0);
                contractData = create;
                break;
            }
            case 10: {
                if (ProtocolGroupManager.getCurrentVersion((int)tx.getChainId()) < ContractContext.UPDATE_VERSION_V250) {
                    isContractTx = false;
                    break;
                }
                contractData = ContractUtil.parseCrossChainTx(tx, chainManager);
                if (contractData != null) break;
                isContractTx = false;
                break;
            }
            case 17: {
                DeleteContractData delete = new DeleteContractData();
                delete.parse(tx.getTxData(), 0);
                contractData = delete;
                break;
            }
            default: {
                Log.warn("Non-contract tx detected. Tx hash is {}, type is {}", tx.getHash().toString(), tx.getType());
                isContractTx = false;
            }
        }
        if (isContractTx) {
            contractTransaction = new ContractWrapperTransaction(tx, tx.getTxHex(), (ContractData)contractData);
        }
        return contractTransaction;
    }

    public static CallContractData parseCrossChainTx(Transaction tx, ChainManager chainManager) throws NulsException {
        CoinData coinData = tx.getCoinDataInstance();
        List toList = coinData.getTo();
        CoinTo coinTo = (CoinTo)toList.get(0);
        byte[] toAddress = coinTo.getAddress();
        int chainIdByToAddress = AddressTool.getChainIdByAddress((byte[])toAddress);
        if (chainIdByToAddress != ContractContext.MAIN_CHAIN_ID) {
            if (Log.isDebugEnabled()) {
                Log.warn("Receiver[{}]Non main chain address, not cross chain transfer transaction", AddressTool.getStringAddressByBytes((byte[])toAddress));
            }
            return null;
        }
        int assetsChainId = coinTo.getAssetsChainId();
        Chain chain = chainManager.getChainMap().get(assetsChainId);
        if (chain == null) {
            if (Log.isDebugEnabled()) {
                Log.warn("Unknown Chain[{}]", assetsChainId);
            }
            return null;
        }
        int assetsId = coinTo.getAssetsId();
        Map<String, String> tokenAssetsContractAddressInfoMap = chain.getTokenAssetsContractAddressInfoMap();
        String nrcContractAddress = tokenAssetsContractAddressInfoMap.get(assetsChainId + "-" + assetsId);
        if (StringUtils.isBlank((String)nrcContractAddress)) {
            if (Log.isDebugEnabled()) {
                Log.warn("Unregistered contract assets[{}]", assetsChainId + "-" + assetsId);
            }
            return null;
        }
        boolean isCrossAssets = ChainManagerCall.isCrossAssets(assetsChainId, assetsId);
        if (!isCrossAssets) {
            if (Log.isDebugEnabled()) {
                Log.warn("No cross chain assets registered[{}]", assetsChainId + "-" + assetsId);
            }
            return null;
        }
        List fromList = coinData.getFrom();
        CoinFrom from = (CoinFrom)fromList.get(0);
        byte[] fromAddress = from.getAddress();
        BigInteger amount = coinTo.getAmount();
        CallContractData contractData = new CallContractData();
        contractData.setSender(null);
        contractData.setGasLimit(300000L);
        contractData.setPrice(25L);
        contractData.setMethodName("crossChainTokenTransfer");
        contractData.setValue(BigInteger.ZERO);
        String[][] args = new String[][]{{nrcContractAddress}, {AddressTool.getStringAddressByBytes((byte[])fromAddress)}, {AddressTool.getStringAddressByBytes((byte[])toAddress)}, {amount.toString()}, {String.valueOf(assetsChainId)}, {String.valueOf(assetsId)}};
        contractData.setArgsCount((short)args.length);
        contractData.setArgs(args);
        contractData.setContractAddress(ContractContext.CROSS_CHAIN_SYSTEM_CONTRACT);
        return contractData;
    }

    public static String[][] twoDimensionalArray(Object[] args) {
        return ContractUtil.twoDimensionalArray(args, null);
    }

    public static String valueOf(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static ContractTokenTransferInfoPo convertJsonToTokenTransferInfoPo(int chainId, String event) {
        if (StringUtils.isBlank((String)event)) {
            return null;
        }
        try {
            Map eventMap = JSONUtils.json2map((String)event);
            String eventName = (String)eventMap.get("event");
            String contractAddress = (String)eventMap.get("contractAddress");
            if (ContractContext.getTokenType(contractAddress) != TokenTypeStatus.NRC20.status()) {
                return null;
            }
            ContractTokenTransferInfoPo po = new ContractTokenTransferInfoPo();
            po.setContractAddress(contractAddress);
            if ("TransferEvent".equals(eventName)) {
                Map data = (Map)eventMap.get("payload");
                Collection values = data.values();
                int i = 0;
                for (Object object : values) {
                    String transferEventdata = (String)object;
                    if ((i == 0 || i == 1) && AddressTool.validAddress((int)chainId, (String)transferEventdata)) {
                        byte[] addressBytes = AddressTool.getAddress((String)transferEventdata);
                        if (i == 0) {
                            po.setFrom(addressBytes);
                        } else {
                            po.setTo(addressBytes);
                        }
                    }
                    if (i == 2) {
                        po.setValue(StringUtils.isBlank((String)transferEventdata) ? BigInteger.ZERO : new BigInteger(transferEventdata));
                        break;
                    }
                    ++i;
                }
                return po;
            }
            return null;
        }
        catch (Exception e) {
            Log.error(e);
            return null;
        }
    }

    public static ContractTokenTransferInfo convertJsonToTokenTransferInfo(int chainId, String event) {
        if (StringUtils.isBlank((String)event)) {
            return null;
        }
        try {
            Map eventMap = JSONUtils.json2map((String)event);
            String eventName = (String)eventMap.get("event");
            String contractAddress = (String)eventMap.get("contractAddress");
            ContractAddressInfoPo contractAddressInfo = ContractContext.getContractAddressInfo(contractAddress);
            int tokenType = contractAddressInfo.getTokenType();
            ContractTokenTransferInfo info = new ContractTokenTransferInfo();
            info.setContractAddress(contractAddress);
            if ("TransferEvent".equals(eventName)) {
                if (tokenType != TokenTypeStatus.NRC20.status()) {
                    return null;
                }
                Map data = (Map)eventMap.get("payload");
                info.setTokenType(TokenTypeStatus.NRC20.status());
                info.setName(contractAddressInfo.getNrc20TokenName());
                info.setSymbol(contractAddressInfo.getNrc20TokenSymbol());
                info.setDecimals(contractAddressInfo.getDecimals());
                Collection values = data.values();
                int i = 0;
                for (Object object : values) {
                    String transferEventdata = (String)object;
                    if ((i == 0 || i == 1) && AddressTool.validAddress((int)chainId, (String)transferEventdata)) {
                        if (i == 0) {
                            info.setFrom(transferEventdata);
                        } else {
                            info.setTo(transferEventdata);
                        }
                    }
                    if (i == 2) {
                        info.setValue(StringUtils.isBlank((String)transferEventdata) ? "0" : transferEventdata);
                        break;
                    }
                    ++i;
                }
                return info;
            }
            if ("Transfer".equals(eventName)) {
                if (tokenType != TokenTypeStatus.NRC721.status()) {
                    return null;
                }
                Map data = (Map)eventMap.get("payload");
                info.setTokenType(TokenTypeStatus.NRC721.status());
                info.setName(contractAddressInfo.getNrc20TokenName());
                info.setSymbol(contractAddressInfo.getNrc20TokenSymbol());
                Collection values = data.values();
                int i = 0;
                for (Object object : values) {
                    String transferEventdata = (String)object;
                    if ((i == 0 || i == 1) && AddressTool.validAddress((int)chainId, (String)transferEventdata)) {
                        if (i == 0) {
                            info.setFrom(transferEventdata);
                        } else {
                            info.setTo(transferEventdata);
                        }
                    }
                    if (i == 2) {
                        info.setValue(StringUtils.isBlank((String)transferEventdata) ? "0" : transferEventdata);
                        break;
                    }
                    ++i;
                }
                return info;
            }
            if ("TransferSingle".equals(eventName)) {
                if (tokenType != TokenTypeStatus.NRC1155.status()) {
                    return null;
                }
                Map data = (Map)eventMap.get("payload");
                info.setTokenType(TokenTypeStatus.NRC1155.status());
                info.setName(contractAddressInfo.getNrc20TokenName());
                info.setSymbol(contractAddressInfo.getNrc20TokenSymbol());
                Collection values = data.values();
                int i = 0;
                for (Object object : values) {
                    String transferEventdata = (String)object;
                    if (i <= 2 && AddressTool.validAddress((int)chainId, (String)transferEventdata)) {
                        if (i == 0) {
                            info.setOperator(transferEventdata);
                        } else if (i == 1) {
                            info.setFrom(transferEventdata);
                        } else {
                            info.setTo(transferEventdata);
                        }
                    }
                    if (i == 3) {
                        info.setId(StringUtils.isBlank((String)transferEventdata) ? "0" : transferEventdata);
                    } else if (i == 4) {
                        info.setValue(StringUtils.isBlank((String)transferEventdata) ? "0" : transferEventdata);
                        break;
                    }
                    ++i;
                }
                return info;
            }
            if ("TransferBatch".equals(eventName)) {
                if (tokenType != TokenTypeStatus.NRC1155.status()) {
                    return null;
                }
                Map data = (Map)eventMap.get("payload");
                info.setTokenType(TokenTypeStatus.NRC1155.status());
                info.setName(contractAddressInfo.getNrc20TokenName());
                info.setSymbol(contractAddressInfo.getNrc20TokenSymbol());
                Collection datas = data.values();
                int i = 0;
                for (Object object : datas) {
                    String transferEventdata;
                    if (i <= 2 && AddressTool.validAddress((int)chainId, (String)(transferEventdata = (String)object))) {
                        if (i == 0) {
                            info.setOperator(transferEventdata);
                        } else if (i == 1) {
                            info.setFrom(transferEventdata);
                        } else {
                            info.setTo(transferEventdata);
                        }
                    }
                    if (i == 3) {
                        List ids = (List)object;
                        String[] _ids = null;
                        if (ids != null) {
                            _ids = new String[ids.size()];
                            ids.toArray(_ids);
                        }
                        info.setIds(_ids);
                    } else if (i == 4) {
                        List values = (List)object;
                        String[] _values = null;
                        if (values != null) {
                            _values = new String[values.size()];
                            values.toArray(_values);
                        }
                        info.setValues(_values);
                        break;
                    }
                    ++i;
                }
                return info;
            }
            return null;
        }
        catch (Exception e) {
            Log.error(e);
            return null;
        }
    }

    public static String[] big2strArray(BigInteger[] bigArray) {
        String[] result = new String[bigArray.length];
        for (int i = 0; i < bigArray.length; ++i) {
            result[i] = bigArray[i].toString();
        }
        return result;
    }

    public static BigInteger[] str2bigArray(String[] strArrays) {
        BigInteger[] result = new BigInteger[strArrays.length];
        for (int i = 0; i < strArrays.length; ++i) {
            result[i] = new BigInteger(strArrays[i]);
        }
        return result;
    }

    public static boolean isContractTransaction(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int txType = tx.getType();
        return txType == 15 || txType == 16 || txType == 17 || txType == 18 || txType == 10 || txType == 19;
    }

    public static boolean isGasCostContractTransaction(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int txType = tx.getType();
        return txType == 15 || txType == 16;
    }

    public static boolean isLockContract(int chainId, long blockHeight) throws NulsException {
        long bestBlockHeight;
        long confirmCount;
        return blockHeight > 0L && (confirmCount = (bestBlockHeight = BlockCall.getLatestHeight(chainId)) - blockHeight) < 7L;
    }

    public static boolean isLockContract(long lastestHeight, long blockHeight) throws NulsException {
        long confirmCount;
        return blockHeight > 0L && (confirmCount = lastestHeight - blockHeight) < 7L;
    }

    public static byte[] getStateRoot(BlockHeader blockHeader) {
        if (blockHeader == null || blockHeader.getExtend() == null) {
            return null;
        }
        byte[] stateRoot = blockHeader.getStateRoot();
        if (stateRoot != null && stateRoot.length > 0) {
            return stateRoot;
        }
        try {
            BlockExtendsData extendsData = blockHeader.getExtendsData();
            stateRoot = extendsData.getStateRoot();
            blockHeader.setStateRoot(stateRoot);
            return stateRoot;
        }
        catch (Exception e) {
            Log.error("parse stateRoot error.", e);
            return null;
        }
    }

    public static String bigInteger2String(BigInteger bigInteger) {
        if (bigInteger == null) {
            return null;
        }
        return bigInteger.toString();
    }

    public static String simplifyErrorMsg(String errorMsg) {
        String resultMsg = "contract error - ";
        if (StringUtils.isBlank((String)errorMsg)) {
            return resultMsg;
        }
        if (errorMsg.contains("Exception:")) {
            String[] msgs = errorMsg.split("Exception:", 2);
            return resultMsg + msgs[1].trim();
        }
        return resultMsg + errorMsg;
    }

    public static Result checkVmResultAndReturn(String errorMessage, Result defaultResult) {
        if (StringUtils.isBlank((String)errorMessage)) {
            return defaultResult;
        }
        if (ContractUtil.isNotEnoughGasError(errorMessage)) {
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_GAS_LIMIT).setMsg(errorMessage);
        }
        return defaultResult;
    }

    private static boolean isNotEnoughGasError(String errorMessage) {
        if (errorMessage == null) {
            return false;
        }
        return errorMessage.contains("not enough gas");
    }

    public static boolean isNotEnoughGasError(ContractResult contractResult) {
        if (contractResult.isSuccess()) {
            return false;
        }
        return ContractUtil.isNotEnoughGasError(contractResult.getErrorMessage());
    }

    public static boolean isTerminatedContract(int status) {
        return 2 == status;
    }

    public static boolean isTransferMethod(String method) {
        return "transfer".equals(method) || "transferFrom".equals(method);
    }

    public static String argToString(String[][] args) {
        if (args == null) {
            return "";
        }
        Object result = "";
        for (Object[] objectArray : args) {
            result = (String)result + Arrays.toString(objectArray) + "| ";
        }
        return result;
    }

    public static boolean checkPrice(long price) {
        return price >= 25L;
    }

    public static boolean checkGasLimit(long gas) {
        return gas > 0L && gas <= 10000000L;
    }

    public static void createTable(String name) {
        if (!RocksDBService.existTable((String)name)) {
            try {
                RocksDBService.createTable((String)name);
            }
            catch (Exception e) {
                Log.error(e);
                throw new NulsRuntimeException(ContractErrorCode.CONTRACT_OTHER_ERROR);
            }
        }
    }

    public static boolean isLegalContractAddress(int chainId, byte[] addressBytes) {
        if (addressBytes == null) {
            return false;
        }
        return AddressTool.validContractAddress((byte[])addressBytes, (int)chainId);
    }

    public static void put(Map<String, Set<ContractResult>> map, String contractAddress, ContractResult result) {
        Set<ContractResult> resultSet = map.get(contractAddress);
        if (resultSet == null) {
            resultSet = new HashSet<ContractResult>();
            map.put(contractAddress, resultSet);
        }
        resultSet.add(result);
    }

    public static void putAll(int chainId, Map<String, Set<ContractResult>> map, ContractResult contractResult) {
        Set<String> addressSet = ContractUtil.collectAddress(chainId, contractResult);
        for (String address : addressSet) {
            ContractUtil.put(map, address, contractResult);
        }
    }

    public static Set<String> collectAddress(int chainId, ContractResult result) {
        HashSet<String> set = new HashSet<String>();
        set.add(AddressTool.getStringAddressByBytes((byte[])result.getContractAddress()));
        Set<String> innerCallSet = result.getContractAddressInnerCallSet();
        if (innerCallSet != null) {
            set.addAll(innerCallSet);
        }
        result.getTransfers().stream().forEach(transfer -> {
            if (ContractUtil.isLegalContractAddress(chainId, transfer.getFrom())) {
                set.add(AddressTool.getStringAddressByBytes((byte[])transfer.getFrom()));
            }
            if (ContractUtil.isLegalContractAddress(chainId, transfer.getTo())) {
                set.add(AddressTool.getStringAddressByBytes((byte[])transfer.getTo()));
            }
        });
        return set;
    }

    public static List<ContractResult> deduplicationAndOrder(List<ContractResult> contractResultList) {
        return contractResultList.stream().collect(Collectors.toSet()).stream().collect(Collectors.toList()).stream().sorted(CompareTxTimeDesc.getInstance()).collect(Collectors.toList());
    }

    public static Map<String, Set<ContractResult>> collectAddressMap(int chainId, List<ContractResult> contractResultList) {
        HashMap<String, Set<ContractResult>> map = new HashMap<String, Set<ContractResult>>();
        for (ContractResult result : contractResultList) {
            ContractUtil.put(map, AddressTool.getStringAddressByBytes((byte[])result.getContractAddress()), result);
            result.getContractAddressInnerCallSet().stream().forEach(inner -> ContractUtil.put(map, inner, result));
            result.getTransfers().stream().forEach(transfer -> {
                if (ContractUtil.isLegalContractAddress(chainId, transfer.getFrom())) {
                    ContractUtil.put(map, AddressTool.getStringAddressByBytes((byte[])transfer.getFrom()), result);
                }
                if (ContractUtil.isLegalContractAddress(chainId, transfer.getTo())) {
                    ContractUtil.put(map, AddressTool.getStringAddressByBytes((byte[])transfer.getTo()), result);
                }
            });
        }
        return map;
    }

    public static void makeContractResult(ContractWrapperTransaction tx, ContractResult contractResult) {
        contractResult.setTx(tx);
        contractResult.setTxTime(tx.getTime());
        contractResult.setHash(tx.getHash().toString());
        contractResult.setTxOrder(tx.getOrder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean makeContractResultAndCheckGasSerial(ContractWrapperTransaction tx, ContractResult contractResult, BatchInfo batchInfo) {
        int i = 0;
        while (true) {
            BatchInfo batchInfo2 = batchInfo;
            synchronized (batchInfo2) {
                int txOrder = tx.getOrder();
                int serialOrder = batchInfo.getSerialOrder();
                if (serialOrder == txOrder) {
                    if (Log.isDebugEnabled()) {
                        Log.debug("Serial tradingorder - [{}]", txOrder);
                    }
                    batchInfo.setSerialOrder(serialOrder + 1);
                    contractResult.setTx(tx);
                    contractResult.setTxTime(tx.getTime());
                    contractResult.setHash(tx.getHash().toString());
                    contractResult.setTxOrder(tx.getOrder());
                    boolean checkGas = ContractUtil.checkGas(contractResult, batchInfo);
                    batchInfo.notifyAll();
                    return checkGas;
                }
                ++i;
                if (Log.isDebugEnabled()) {
                    Log.debug("Waiting transactionsorder - [{}], [{}]Thread wait count - [{}]", txOrder, Thread.currentThread().getName(), i);
                }
                try {
                    batchInfo.wait(5000L);
                }
                catch (InterruptedException e) {
                    Log.error(e);
                }
                if (i > 4) {
                    return false;
                }
            }
        }
    }

    private static boolean checkGas(ContractResult contractResult, BatchInfo batchInfo) {
        long gasUsed = contractResult.getGasUsed();
        boolean isAdded = batchInfo.addGasCostTotal(gasUsed, contractResult.getHash());
        if (!isAdded) {
            contractResult.setError(true);
            contractResult.setErrorMessage("Exceed tx count [600] or gas limit of block [13,000,000 gas], the contract transaction [" + contractResult.getHash() + "] revert to package queue.");
        }
        return isAdded;
    }

    public static Result getSuccess() {
        return Result.getSuccess((ErrorCode)ContractErrorCode.SUCCESS);
    }

    public static Result getFailed() {
        return Result.getFailed((ErrorCode)ContractErrorCode.FAILED);
    }

    public static String asString(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] asBytes(String string) {
        return Base64.getDecoder().decode(string);
    }

    public static BigDecimal toNuls(BigInteger na) {
        return new BigDecimal(na).movePointLeft(8);
    }

    public static BigInteger toNa(BigDecimal nuls) {
        return nuls.scaleByPowerOfTen(8).toBigInteger();
    }

    public static BigInteger minus(BigInteger a, BigInteger b) {
        BigInteger result = a.subtract(b);
        if (result.compareTo(BigInteger.ZERO) < 0) {
            throw new RuntimeException("Negative number detected.");
        }
        return result;
    }

    public static ContractBaseTransaction convertContractTx(int chainId, Transaction tx) {
        ContractBaseTransaction resultTx = null;
        switch (tx.getType()) {
            case 15: {
                resultTx = new CreateContractTransaction();
                break;
            }
            case 16: {
                resultTx = new CallContractTransaction();
                break;
            }
            case 17: {
                resultTx = new DeleteContractTransaction();
                break;
            }
            case 18: {
                resultTx = new ContractTransferTransaction();
                break;
            }
            case 19: {
                resultTx = new ContractReturnGasTransaction();
                break;
            }
            case 10: {
                if (ProtocolGroupManager.getCurrentVersion((int)chainId) < ContractContext.UPDATE_VERSION_V250) break;
                resultTx = new CrossTokenContractTransaction();
                break;
            }
        }
        if (resultTx != null) {
            resultTx.copyTx(tx);
        }
        return resultTx;
    }

    public static Response wrapperFailed(Result result) {
        if (result != null) {
            ErrorCode errorCode = result.getErrorCode();
            String msg = result.getMsg();
            if (StringUtils.isBlank((String)msg)) {
                msg = errorCode.getMsg();
            }
            Response res = MessageUtil.newFailResponse((String)"", (String)msg);
            res.setResponseErrorCode(errorCode.getCode());
            return res;
        }
        return MessageUtil.newFailResponse((String)"", (ErrorCode)ContractErrorCode.FAILED);
    }

    public static int extractTxTypeFromTx(String txString) throws NulsException {
        String txTypeHexString = txString.substring(0, 4);
        NulsByteBuffer byteBuffer = new NulsByteBuffer(RPCUtil.decode((String)txTypeHexString));
        return byteBuffer.readUint16();
    }

    public static byte[] extractPublicKey(Transaction tx) throws NulsException {
        List p2PHKSignatures;
        if (tx.getTransactionSignature() == null) {
            return null;
        }
        if (tx.isMultiSignTx()) {
            MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
            transactionSignature.parse(tx.getTransactionSignature(), 0);
            p2PHKSignatures = transactionSignature.getP2PHKSignatures();
        } else {
            TransactionSignature signature = new TransactionSignature();
            try {
                signature.parse(tx.getTransactionSignature(), 0);
            }
            catch (NulsException e) {
                Log.error(e);
                return null;
            }
            p2PHKSignatures = signature.getP2PHKSignatures();
        }
        P2PHKSignature p2PHKSignature = (P2PHKSignature)p2PHKSignatures.get(0);
        byte[] publicKey = p2PHKSignature.getPublicKey();
        return publicKey;
    }

    public static void mapAddBigInteger(LinkedHashMap<String, BigInteger> map, byte[] address, int assetChainId, int assetId, BigInteger amount) {
        String addressKey = ContractUtil.addressKey(address, assetChainId, assetId);
        BigInteger currentAmount = map.get(addressKey);
        if (currentAmount == null) {
            map.put(addressKey, amount);
        } else {
            map.put(addressKey, currentAmount.add(amount));
        }
    }

    public static String addressKey(byte[] address, int assetChainId, int assetId) {
        return ContractUtil.asString(address) + "_" + assetChainId + "_" + assetId;
    }

    public static String addressLockedKey(byte[] address, int assetChainId, int assetId, long lockedTime) {
        return ContractUtil.asString(address) + "_" + assetChainId + "_" + assetId + "_" + lockedTime;
    }

    public static String toString(String[][] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(Arrays.toString(a[i]));
            if (i == iMax) break;
            b.append(", ");
            ++i;
        }
        b.append(']');
        return b.toString();
    }

    public static void addDebugEvents(List<String> debugEvents, Result result) {
        if (debugEvents.isEmpty()) {
            return;
        }
        Object msg = result.getMsg();
        if (msg == null) {
            msg = "";
        }
        msg = (String)msg + ", debugEvents: " + debugEvents.toString();
        result.setMsg((String)msg);
    }

    public static List<ProgramMultyAssetValue> extractMultyAssetInfoFromCallTransactionBeforeP20(CoinData coinData) {
        List toList = coinData.getTo();
        if (toList == null || toList.isEmpty()) {
            return null;
        }
        ArrayList<ProgramMultyAssetValue> list = null;
        for (CoinTo to : toList) {
            if (to.getAssetsChainId() == ContractContext.LOCAL_CHAIN_ID && to.getAssetsId() == ContractContext.LOCAL_MAIN_ASSET_ID) continue;
            if (list == null) {
                list = new ArrayList<ProgramMultyAssetValue>();
            }
            list.add(new ProgramMultyAssetValue(to.getAmount(), to.getAssetsChainId(), to.getAssetsId()));
        }
        return list;
    }

    public static List<ProgramMultyAssetValue> extractMultyAssetInfoFromCallTransactionAfterP20(CallContractData callContractData, CoinData coinData) {
        List toList = coinData.getTo();
        if (toList == null || toList.isEmpty()) {
            return null;
        }
        ArrayList<ProgramMultyAssetValue> list = null;
        for (CoinTo to : toList) {
            if (to.getAssetsChainId() == ContractContext.LOCAL_CHAIN_ID && to.getAssetsId() == ContractContext.LOCAL_MAIN_ASSET_ID || !Arrays.equals(to.getAddress(), callContractData.getContractAddress())) continue;
            if (list == null) {
                list = new ArrayList<ProgramMultyAssetValue>();
            }
            list.add(new ProgramMultyAssetValue(to.getAmount(), to.getAssetsChainId(), to.getAssetsId()));
        }
        return list;
    }

    public static String[][] multyAssetStringArray(List<ProgramMultyAssetValue> multyAssetValues) {
        int length;
        if (multyAssetValues == null || (length = multyAssetValues.size()) == 0) {
            return null;
        }
        String[][] array = new String[length][];
        for (int i = 0; i < length; ++i) {
            ProgramMultyAssetValue value = multyAssetValues.get(i);
            array[i] = new String[]{value.getValue().toString(), String.valueOf(value.getAssetChainId()), String.valueOf(value.getAssetId())};
        }
        return array;
    }

    public static String[][] multyAssetStringArray(ProgramMultyAssetValue[] multyAssetValues) {
        int length;
        if (multyAssetValues == null || (length = multyAssetValues.length) == 0) {
            return null;
        }
        String[][] array = new String[length][];
        for (int i = 0; i < length; ++i) {
            ProgramMultyAssetValue value = multyAssetValues[i];
            array[i] = new String[]{value.getValue().toString(), String.valueOf(value.getAssetChainId()), String.valueOf(value.getAssetId())};
        }
        return array;
    }

    public static String[][] nulsValueToOthersStringArray(AccountAmountDto[] nulsValueToOthers) {
        int length;
        if (nulsValueToOthers == null || (length = nulsValueToOthers.length) == 0) {
            return null;
        }
        String[][] array = new String[length][];
        for (int i = 0; i < length; ++i) {
            AccountAmountDto dto = nulsValueToOthers[i];
            array[i] = new String[]{dto.getValue().toString(), dto.getTo()};
        }
        return array;
    }

    public static ProgramMultyAssetValue[] multyAssetObjectArray(String[][] multyAssetValues) {
        int length;
        if (multyAssetValues == null || (length = multyAssetValues.length) == 0) {
            return null;
        }
        ProgramMultyAssetValue[] array = new ProgramMultyAssetValue[length];
        for (int i = 0; i < length; ++i) {
            String[] value = multyAssetValues[i];
            array[i] = new ProgramMultyAssetValue(new BigInteger(value[0]), Integer.valueOf(value[1]), Integer.valueOf(value[2]));
        }
        return array;
    }

    public static String methodSignature(ProgramMethod method) {
        List<ProgramMethodArg> args = method.getArgs();
        StringBuilder key = new StringBuilder(method.getName()).append("(");
        if (args != null && !args.isEmpty()) {
            for (int i = 0; i < args.size(); ++i) {
                key.append(args.get(i).getType()).append(",");
            }
            key.deleteCharAt(key.length() - 1);
        }
        key.append(")");
        return key.toString();
    }
}

