/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.validator;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.common.NCUtils;
import io.nuls.common.NulsCoresConfig;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.tx.CreateContractTransaction;
import io.nuls.contract.model.txdata.CreateContractData;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.FormatValidUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@Component
public class CreateContractTxValidator {
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private NulsCoresConfig contractConfig;

    public Result validate(int chainId, CreateContractTransaction tx) throws NulsException {
        List fromList;
        block12: {
            block13: {
                CoinData coinData = tx.getCoinDataInstance();
                fromList = coinData.getFrom();
                List toList = coinData.getTo();
                int toListSize = toList.size();
                if (toListSize == 0) break block12;
                if (toListSize != 1) break block13;
                CoinTo coinTo = (CoinTo)toList.get(0);
                byte[] blockHoleAddress = AddressTool.getAddress((byte[])HexUtil.decode((String)this.contractConfig.getBlackHolePublicKey()), (int)this.contractConfig.getChainId());
                if (Arrays.equals(blockHoleAddress, coinTo.getAddress())) break block12;
            }
            Log.error("contract create error: The contract coin to is not empty.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_TO_EMPTY_ERROR);
        }
        CreateContractData txData = (CreateContractData)tx.getTxDataObj();
        byte[] sender = txData.getSender();
        boolean existSender = false;
        Chain chain = this.contractHelper.getChain(chainId);
        int feeAssetId = chain.getConfig().getAssetId();
        int feeAssetChainId = chain.getConfig().getAssetId();
        for (CoinFrom from : fromList) {
            if (!ContractContext.FEE_ASSETS_SET.contains(NCUtils.getTokenId(from.getAssetsChainId(), from.getAssetsId()))) {
                Log.error("contract create error: The chain id or assets id of coin from is error.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_ASSETS_ERROR);
            }
            if (!existSender && Arrays.equals(from.getAddress(), sender)) {
                existSender = true;
            }
            feeAssetId = from.getAssetsId();
            feeAssetChainId = from.getAssetsChainId();
        }
        Set addressSet = SignatureUtil.getAddressFromTX((Transaction)tx, (int)chainId);
        if (!existSender || !addressSet.contains(AddressTool.getStringAddressByBytes((byte[])sender))) {
            Log.error("contract create error: The contract creator is not the transaction creator.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_CREATOR_ERROR);
        }
        String alias = txData.getAlias();
        if (!FormatValidUtils.validAlias((String)alias)) {
            Log.error("contract create error: The contract alias format error.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_ALIAS_FORMAT_ERROR);
        }
        if (!ContractUtil.checkPrice(txData.getPrice())) {
            Log.error("contract create error: The gas price is error.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_MINIMUM_PRICE_ERROR);
        }
        if (!ContractUtil.checkGasLimit(txData.getGasLimit())) {
            Log.error("contract create error: The value of gas limit ranges from 1 to 10,000,000.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_GAS_LIMIT_ERROR);
        }
        byte[] contractAddress = txData.getContractAddress();
        if (!ContractUtil.isLegalContractAddress(chainId, contractAddress)) {
            Log.error("contract create error: Illegal contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.ILLEGAL_CONTRACT_ADDRESS);
        }
        BigInteger realFee = tx.getFee();
        BigInteger scFee = BigInteger.valueOf(txData.getGasLimit()).multiply(BigInteger.valueOf(txData.getPrice()));
        scFee = new BigDecimal(scFee).multiply(BigDecimal.valueOf(chain.getConfig().getFeeCoefficient(feeAssetChainId, feeAssetId))).toBigInteger();
        BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)tx.size(), (long)chain.getConfig().getFeeUnit(feeAssetChainId, feeAssetId)).add(scFee);
        if (realFee.compareTo(fee) >= 0) {
            return ContractUtil.getSuccess();
        }
        Log.error("contract create error: The contract transaction fee is not right.");
        return Result.getFailed((ErrorCode)ContractErrorCode.FEE_NOT_RIGHT);
    }
}

