/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.BiMap;
import io.nuls.contract.vm.code.VariableType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ObjectRef {
    public static final Map<String, Integer> map = new HashMap<String, Integer>();
    private final String ref;
    private final String desc;
    private final int[] dimensions;
    @JsonIgnore
    private final VariableType variableType;

    public ObjectRef(String ref, String desc, int ... dimensions) {
        this.ref = ref;
        this.desc = desc;
        this.dimensions = dimensions;
        this.variableType = VariableType.valueOf(this.desc);
    }

    public ObjectRef(String str, BiMap<String, String> classNames) {
        String[] parts = str.split(",");
        int[] dimensions = new int[parts.length - 2];
        for (int i = 0; i < dimensions.length; ++i) {
            int dimension;
            dimensions[i] = dimension = Integer.valueOf(parts[i + 2]).intValue();
        }
        this.ref = parts[0];
        String s = parts[1];
        String s1 = (String)classNames.get((Object)s);
        if (s1 != null) {
            s = s1;
        }
        this.desc = s;
        this.dimensions = dimensions;
        this.variableType = VariableType.valueOf(this.desc);
    }

    public String getEncoded(BiMap<String, String> classNames) {
        StringBuilder sb = new StringBuilder();
        String s = this.desc;
        String s1 = (String)classNames.inverse().get((Object)s);
        if (s1 != null) {
            s = s1;
        }
        sb.append(this.ref).append(",").append(s);
        for (int dimension : this.dimensions) {
            sb.append(",").append(dimension);
        }
        return sb.toString();
    }

    public boolean isArray() {
        return this.dimensions != null && this.dimensions.length > 0;
    }

    public String getRef() {
        return this.ref;
    }

    public String getDesc() {
        return this.desc;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectRef objectRef = (ObjectRef)o;
        if (this.ref != null ? !this.ref.equals(objectRef.ref) : objectRef.ref != null) {
            return false;
        }
        if (this.desc != null ? !this.desc.equals(objectRef.desc) : objectRef.desc != null) {
            return false;
        }
        return Arrays.equals(this.dimensions, objectRef.dimensions);
    }

    public int hashCode() {
        int result = this.ref != null ? this.ref.hashCode() : 0;
        result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public String toString() {
        return "ObjectRef{ref=" + this.ref + ", desc=" + this.desc + ", dimensions=" + Arrays.toString(this.dimensions) + "}";
    }
}

