/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.instructions.references;

import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.natives.NativeMethod;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.tree.MethodInsnNode;

public class Invokevirtual {
    private static final String RESIZE_CLASS_NAME = "java/util/HashMap";
    private static final String RESIZE_METHOD_NAME = "resize";
    private static final String RESIZE_METHOD_DESC = "()[Ljava/util/HashMap$Node;";
    private static final String CAPACITY_METHOD_NAME = "capacity";
    private static final String CAPACITY_METHOD_DESC = "()I";

    public static void invokevirtual(Frame frame) {
        MethodCode methodCode;
        Result result;
        MethodInsnNode methodInsnNode = frame.methodInsnNode();
        String className = methodInsnNode.owner;
        String methodName = methodInsnNode.name;
        String methodDesc = methodInsnNode.desc;
        List<VariableType> variableTypes = VariableType.parseArgs(methodDesc);
        MethodArgs methodArgs = new MethodArgs(variableTypes, frame.operandStack, false);
        ObjectRef objectRef = methodArgs.objectRef;
        if (objectRef == null) {
            frame.throwNullPointerException();
            return;
        }
        String type = objectRef.getVariableType().getType();
        if (!Objects.equals(className, type) && !objectRef.getVariableType().isPrimitiveType()) {
            className = type;
        }
        if (objectRef.isArray()) {
            className = "java/lang/Object";
        }
        if ((result = NativeMethod.run(methodCode = frame.methodArea.loadMethod(className, methodName, methodDesc), methodArgs, frame)) != null) {
            return;
        }
        if (ProtocolGroupManager.getCurrentVersion((int)ContractContext.LOCAL_CHAIN_ID) >= ContractContext.UPDATE_VERSION_CONTRACT_BALANCE && methodCode.isMethod(RESIZE_CLASS_NAME, RESIZE_METHOD_NAME, RESIZE_METHOD_DESC)) {
            MethodCode sizeMethod = frame.vm.methodArea.loadMethod(className, "size", CAPACITY_METHOD_DESC);
            frame.vm.run(sizeMethod, methodArgs.frameArgs, false);
            Object sizeResult = frame.vm.getResultValue();
            int size = (Integer)sizeResult;
            if (size > 65536) {
                frame.throwRuntimeException("Max size of map is 65536");
                return;
            }
            if (size > 3072) {
                MethodCode capacityMethod = frame.vm.methodArea.loadMethod(className, CAPACITY_METHOD_NAME, CAPACITY_METHOD_DESC);
                frame.vm.run(capacityMethod, methodArgs.frameArgs, false);
                Object capacityResult = frame.vm.getResultValue();
                int capacity = (Integer)capacityResult;
                int resizeCount = Invokevirtual.log2(65536 / capacity) - 1;
                if (resizeCount > 0) {
                    for (int i = 0; i < resizeCount; ++i) {
                        frame.vm.run(methodCode, methodArgs.frameArgs, true);
                    }
                }
            }
        }
        frame.vm.run(methodCode, methodArgs.frameArgs, true);
    }

    static int log2(int digit) {
        int count = 0;
        while ((digit /= 2) != 0) {
            ++count;
        }
        return count;
    }
}

