/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.program;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class ProgramCreateData
extends BaseNulsData {
    private final byte hard = (byte)-1;
    private byte[] sender;
    private byte[] salt;
    private byte[] codeHash;

    public ProgramCreateData(byte[] sender, byte[] salt, byte[] codeHash) {
        this.sender = sender;
        this.salt = salt;
        this.codeHash = codeHash;
    }

    public int size() {
        int size = 1;
        size += 23;
        size += SerializeUtils.sizeOfBytes((byte[])this.salt);
        return size += SerializeUtils.sizeOfBytes((byte[])this.codeHash);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(-1);
        stream.write(this.sender);
        stream.writeBytesWithLength(this.salt);
        stream.writeBytesWithLength(this.codeHash);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        byteBuffer.readByte();
        this.sender = byteBuffer.readBytes(23);
        this.salt = byteBuffer.readByLengthByte();
        this.codeHash = byteBuffer.readByLengthByte();
    }

    public byte getHard() {
        return -1;
    }

    public byte[] getSender() {
        return this.sender;
    }

    public void setSender(byte[] sender) {
        this.sender = sender;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public byte[] getCodeHash() {
        return this.codeHash;
    }

    public void setCodeHash(byte[] codeHash) {
        this.codeHash = codeHash;
    }
}

