/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.program;

import io.nuls.contract.vm.program.ProgramMethodArg;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.TypeDescriptor;
import java.util.List;

@ApiModel(name="Contract Method Details")
public class ProgramMethod {
    @ApiModelProperty(description="Method Name")
    private String name;
    @ApiModelProperty(description="Method description")
    private String desc;
    @ApiModelProperty(description="Method parameter list", type=@TypeDescriptor(value=List.class, collectionElement=ProgramMethodArg.class))
    private List<ProgramMethodArg> args;
    @ApiModelProperty(description="return type")
    private String returnArg;
    @ApiModelProperty(description="View Method\uff08Call this method and the data will not be linked\uff09")
    private boolean view;
    @ApiModelProperty(description="Is it an event")
    private boolean event;
    @ApiModelProperty(description="Is it an acceptable method for transferring main chain assets")
    private boolean payable;
    @ApiModelProperty(description="Is it an acceptable method for transferring other assets")
    private boolean payableMultyAsset;
    @ApiModelProperty(description="Is the method return valueJSONserialize")
    private boolean jsonSerializable;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public List<ProgramMethodArg> getArgs() {
        return this.args;
    }

    public void setArgs(List<ProgramMethodArg> args) {
        this.args = args;
    }

    public String getReturnArg() {
        return this.returnArg;
    }

    public void setReturnArg(String returnArg) {
        this.returnArg = returnArg;
    }

    public boolean isView() {
        return this.view;
    }

    public void setView(boolean view) {
        this.view = view;
    }

    public boolean isEvent() {
        return this.event;
    }

    public void setEvent(boolean event) {
        this.event = event;
    }

    public boolean isPayable() {
        return this.payable;
    }

    public void setPayable(boolean payable) {
        this.payable = payable;
    }

    public boolean isPayableMultyAsset() {
        return this.payableMultyAsset;
    }

    public void setPayableMultyAsset(boolean payableMultyAsset) {
        this.payableMultyAsset = payableMultyAsset;
    }

    public boolean isJsonSerializable() {
        return this.jsonSerializable;
    }

    public void setJsonSerializable(boolean jsonSerializable) {
        this.jsonSerializable = jsonSerializable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramMethod that = (ProgramMethod)o;
        if (this.view != that.view) {
            return false;
        }
        if (this.event != that.event) {
            return false;
        }
        if (this.payable != that.payable) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.desc != null ? !this.desc.equals(that.desc) : that.desc != null) {
            return false;
        }
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        return this.returnArg != null ? this.returnArg.equals(that.returnArg) : that.returnArg == null;
    }

    public boolean equalsTokenMethod(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramMethod that = (ProgramMethod)o;
        if (this.view != that.view) {
            return false;
        }
        if (this.event != that.event) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.args != null) {
            if (that.args == null) {
                return false;
            }
            if (!this.isEqualTokenArgs(this.args, that.args)) {
                return false;
            }
        } else if (that.args != null) {
            return false;
        }
        return this.returnArg != null ? this.returnArg.equals(that.returnArg) : that.returnArg == null;
    }

    public String[] argsType2Array() {
        if (this.args != null && this.args.size() > 0) {
            int size = this.args.size();
            String[] result = new String[size];
            for (int i = 0; i < size; ++i) {
                result[i] = this.args.get(i).getType();
            }
            return result;
        }
        return null;
    }

    private boolean isEqualTokenArgs(List<ProgramMethodArg> a, List<ProgramMethodArg> b) {
        if (a.size() != b.size()) {
            return false;
        }
        int size = a.size();
        for (int i = 0; i < size; ++i) {
            ProgramMethodArg argB;
            ProgramMethodArg argA = a.get(i);
            if (argA.equalsTokenArg(argB = b.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
        result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
        result = 31 * result + (this.returnArg != null ? this.returnArg.hashCode() : 0);
        result = 31 * result + (this.view ? 1 : 0);
        result = 31 * result + (this.event ? 1 : 0);
        result = 31 * result + (this.payable ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ProgramMethod{name=" + this.name + ", desc=" + this.desc + ", args=" + this.args + ", returnArg=" + this.returnArg + ", view=" + this.view + ", event=" + this.event + ", payable=" + this.payable + "}";
    }
}

