/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.message;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.crosschain.base.message.base.BaseMessage;
import io.nuls.crosschain.base.model.bo.Circulation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CirculationMessage
extends BaseMessage {
    private List<Circulation> circulationList;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        if (this.circulationList != null && this.circulationList.size() > 0) {
            for (Circulation circulation : this.circulationList) {
                stream.writeNulsData((BaseNulsData)circulation);
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        ArrayList<Circulation> circulationList = new ArrayList<Circulation>();
        while (!byteBuffer.isFinished()) {
            int course = byteBuffer.getCursor();
            byteBuffer.setCursor(course);
            circulationList.add((Circulation)byteBuffer.readNulsData((BaseNulsData)new Circulation()));
        }
        this.circulationList = circulationList;
    }

    public int size() {
        int size = 0;
        if (this.circulationList != null && this.circulationList.size() > 0) {
            for (Circulation circulation : this.circulationList) {
                size += SerializeUtils.sizeOfNulsData((NulsData)circulation);
            }
        }
        return size;
    }

    public List<Circulation> getCirculationList() {
        return this.circulationList;
    }

    public void setCirculationList(List<Circulation> circulationList) {
        this.circulationList = circulationList;
    }
}

