/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.model.bo.txdata;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.crosschain.base.message.base.BaseMessage;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RegisteredChainMessage
extends BaseMessage {
    private List<ChainInfo> chainInfoList;

    public RegisteredChainMessage() {
    }

    public RegisteredChainMessage(List<ChainInfo> chainInfoList) {
        this.chainInfoList = chainInfoList;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        if (this.chainInfoList != null && this.chainInfoList.size() > 0) {
            for (ChainInfo chainInfo : this.chainInfoList) {
                stream.writeNulsData((BaseNulsData)chainInfo);
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        ArrayList<ChainInfo> chainInfoList = new ArrayList<ChainInfo>();
        while (!byteBuffer.isFinished()) {
            int course = byteBuffer.getCursor();
            byteBuffer.setCursor(course);
            chainInfoList.add((ChainInfo)byteBuffer.readNulsData((BaseNulsData)new ChainInfo()));
        }
        this.chainInfoList = chainInfoList;
    }

    public int size() {
        int size = 0;
        if (this.chainInfoList != null && this.chainInfoList.size() > 0) {
            for (ChainInfo chainInfo : this.chainInfoList) {
                size += SerializeUtils.sizeOfNulsData((NulsData)chainInfo);
            }
        }
        return size;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegisteredChainMessage) {
            RegisteredChainMessage message = (RegisteredChainMessage)((Object)obj);
            try {
                if (this.getChainInfoList() == null && message.getChainInfoList() == null) {
                    return true;
                }
                if (this.getChainInfoList() == null && message.getChainInfoList() != null) {
                    return false;
                }
                if (this.getChainInfoList() != null && message.getChainInfoList() == null) {
                    return false;
                }
                if (this.getChainInfoList().size() != message.getChainInfoList().size()) {
                    return false;
                }
                if (Arrays.equals(this.serialize(), message.serialize())) {
                    return true;
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e);
            }
        }
        return false;
    }

    public List<ChainInfo> getChainInfoList() {
        return this.chainInfoList;
    }

    public void setChainInfoList(List<ChainInfo> chainInfoList) {
        this.chainInfoList = chainInfoList;
    }

    public void addChainInfo(ChainInfo chainInfo) {
        this.chainInfoList.remove((Object)chainInfo);
        this.chainInfoList.add(chainInfo);
    }

    public boolean haveOtherChain(int registerChainId, int mainChainId) {
        for (ChainInfo chainInfo : this.chainInfoList) {
            if (chainInfo.getChainId() == registerChainId || chainInfo.getChainId() == mainChainId) continue;
            return true;
        }
        return false;
    }
}

