/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.rpc.call;

import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.model.bo.Chain;
import java.util.HashMap;

public class TransactionCall {
    public static boolean sendTx(Chain chain, String tx) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chain.getConfig().getChainId());
        params.put("tx", tx);
        try {
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_newTx", params);
            if (!cmdResp.isSuccess()) {
                String errorCode = cmdResp.getResponseErrorCode();
                chain.getLogger().error("Call interface [{}] error, ErrorCode is {}, ResponseComment:{}", new Object[]{"tx_newTx", errorCode, cmdResp.getResponseComment()});
                throw new NulsException(ErrorCode.init((String)errorCode));
            }
            return true;
        }
        catch (NulsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NulsException(NulsCrossChainErrorCode.INTERFACE_CALL_FAILED);
        }
    }
}

