/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.servive.impl;

import com.google.common.collect.Lists;
import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.service.ResetLocalVerifierService;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.rpc.call.AccountCall;
import io.nuls.crosschain.rpc.call.BlockCall;
import io.nuls.crosschain.rpc.call.ConsensusCall;
import io.nuls.crosschain.rpc.call.LedgerCall;
import io.nuls.crosschain.rpc.call.TransactionCall;
import io.nuls.crosschain.srorage.LocalVerifierService;
import io.nuls.crosschain.utils.TxUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import io.nuls.crosschain.utils.manager.CoinDataManager;
import io.nuls.crosschain.utils.manager.LocalVerifierManager;
import io.nuls.crosschain.utils.thread.ResetOtherChainVerifierListHandler;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Component
public class ResetLocalVerifierServiceImpl
implements ResetLocalVerifierService {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private CoinDataManager coinDataManager;
    @Autowired
    NulsCoresConfig nulsCrossChainConfig;
    @Autowired
    LocalVerifierService localVerifierService;
    @Autowired
    LocalVerifierManager localVerifierManager;
    private Set<String> resetOtherVerifierTxList = new HashSet<String>();

    private CoinData assemblyCoinFrom(Chain chain, String addressStr) throws NulsException {
        BigInteger NORMAL_PRICE_PRE_1024_BYTES;
        byte[] address = AddressTool.getAddress((String)addressStr);
        if (!AddressTool.validAddress((int)chain.getChainId(), (String)addressStr)) {
            chain.getLogger().error("Cross chain transaction transfer out account is not a local chain account");
            throw new NulsException(NulsCrossChainErrorCode.ADDRESS_IS_NOT_THE_CURRENT_CHAIN);
        }
        int assetChainId = chain.getChainId();
        int assetId = this.nulsCrossChainConfig.getAssetId();
        Map<String, Object> result = LedgerCall.getBalanceAndNonce(chain, addressStr, assetChainId, assetId);
        byte[] nonce = RPCUtil.decode((String)((String)result.get("nonce")));
        BigInteger balance = new BigInteger(result.get("available").toString());
        if (BigIntegerUtils.isLessThan((BigInteger)balance, (BigInteger)(NORMAL_PRICE_PRE_1024_BYTES = BigInteger.valueOf(chain.getConfig().getFeeUnit(chain.getChainId(), 1))))) {
            chain.getLogger().error("Insufficient account balance");
            throw new NulsException(NulsCrossChainErrorCode.INSUFFICIENT_BALANCE);
        }
        CoinData coinData = new CoinData();
        coinData.setFrom(List.of(new CoinFrom(address, assetChainId, assetId, NORMAL_PRICE_PRE_1024_BYTES, nonce, 0)));
        coinData.setTo(List.of(new CoinTo(address, assetChainId, assetId, BigInteger.ZERO)));
        return coinData;
    }

    @Override
    public Result createResetLocalVerifierTx(int chainId, String address, String password) {
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        if (StringUtils.isBlank((String)address) && StringUtils.isBlank((String)password)) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CHAIN_NOT_EXIST);
        }
        if (!this.nulsCrossChainConfig.getSeedNodeList().contains(address)) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        try {
            Transaction tx = new Transaction(61);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            tx.setCoinData(this.assemblyCoinFrom(chain, address).serialize());
            TransactionSignature transactionSignature = new TransactionSignature();
            ArrayList<P2PHKSignature> p2PHKSignatures = new ArrayList<P2PHKSignature>();
            P2PHKSignature p2PHKSignature = AccountCall.signDigest(address, password, tx.getHash().getBytes());
            p2PHKSignatures.add(p2PHKSignature);
            transactionSignature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(transactionSignature.serialize());
            if (!TransactionCall.sendTx(chain, RPCUtil.encode((byte[])tx.serialize()))) {
                chain.getLogger().error("Failed to reset the transaction sending module of this chain's validator list transaction\n\n");
                throw new NulsException(NulsCrossChainErrorCode.INTERFACE_CALL_FAILED);
            }
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("txHash", tx.getHash().toHex());
            return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error("Exception caught while creating and resetting the validator list transaction in this chain", (Exception)((Object)e));
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (Throwable e) {
            chain.getLogger().error("Unknown exception caught during the creation and reset of this chain's validator list transaction,{}", new Object[]{e.getMessage(), e});
            return Result.getFailed((ErrorCode)CommonCodeConstanst.SYS_UNKOWN_EXCEPTION);
        }
    }

    @Override
    public Map<String, Object> validate(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (chain == null) {
            result.put("txList", txs);
            result.put("errorCode", NulsCrossChainErrorCode.CHAIN_NOT_EXIST.getCode());
            return result;
        }
        List invalidCtxList = txs.stream().skip(1L).collect(Collectors.toList());
        String errorCode = null;
        Transaction tx = txs.get(0);
        try {
            CoinData coinData = tx.getCoinDataInstance();
            if (coinData.getFrom().size() != 1) {
                result.put("txList", txs);
                result.put("errorCode", NulsCrossChainErrorCode.COINDATA_VERIFY_FAIL.getCode());
                return result;
            }
            if (coinData.getFromAddressList().stream().noneMatch(d -> this.nulsCrossChainConfig.getSeedNodeList().contains(d))) {
                result.put("txList", txs);
                result.put("errorCode", NulsCrossChainErrorCode.MUST_SEED_ADDRESS_SIGN.getCode());
                return result;
            }
            TransactionSignature transactionSignature = new TransactionSignature();
            transactionSignature.parse(tx.getTransactionSignature(), 0);
            byte[] txHashByte = tx.getHash().getBytes();
            if (transactionSignature.getP2PHKSignatures().size() != 1) {
                chain.getLogger().error("signatures can not be null");
                throw new NulsException(NulsCrossChainErrorCode.SIGNATURE_ERROR);
            }
            P2PHKSignature signature = (P2PHKSignature)transactionSignature.getP2PHKSignatures().get(0);
            if (!ECKey.verify((byte[])txHashByte, (byte[])signature.getSignData().getSignBytes(), (byte[])signature.getPublicKey())) {
                chain.getLogger().error("Signature verification failed");
                throw new NulsException(NulsCrossChainErrorCode.SIGNATURE_ERROR);
            }
            String signAddress = AddressTool.getStringAddressByBytes((byte[])AddressTool.getAddress((byte[])signature.getPublicKey(), (int)chain.getChainId()));
            if (!this.nulsCrossChainConfig.getSeedNodeList().contains(signAddress)) {
                chain.getLogger().error("Signature verification failed");
                throw new NulsException(NulsCrossChainErrorCode.SIGNATURE_ERROR);
            }
        }
        catch (NulsException e) {
            invalidCtxList.add(tx);
            chain.getLogger().error("reset local verifier Transaction Verification Failure");
            chain.getLogger().error(e);
            errorCode = e.getErrorCode().getCode();
        }
        result.put("txList", invalidCtxList);
        result.put("errorCode", errorCode);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTx(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return false;
        }
        Transaction tx = txs.get(0);
        HashSet<String> allAgentPackingAddress = new HashSet<String>(ConsensusCall.getWorkAgentList(chain));
        allAgentPackingAddress.addAll(this.nulsCrossChainConfig.getSeedNodeList());
        chain.getLogger().info("Obtain the latest block address list for the current network\uff08Including seed nodes\uff09:{}", new Object[]{allAgentPackingAddress});
        this.localVerifierService.backup(chainId, blockHeader.getHeight());
        chain.getSwitchVerifierLock().writeLock().lock();
        try {
            boolean res = LocalVerifierManager.initLocalVerifier(chain, new ArrayList<String>(allAgentPackingAddress));
            if (!res) {
                chain.getLogger().error("Failed to reset the list of validators on this chain");
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            chain.getLogger().error(e.getMessage(), e);
        }
        finally {
            chain.getSwitchVerifierLock().writeLock().unlock();
        }
        chain.getLogger().info("Reset the list of validators in this chain completed:{}", new Object[]{chain.getVerifierList()});
        int syncStatus = BlockCall.getBlockStatus(chain);
        List<ChainInfo> otherChainInfoList = this.chainManager.getRegisteredCrossChainList().stream().filter(d -> d.getChainId() != chainId).collect(Collectors.toList());
        ArrayList newTxList = Lists.newArrayList();
        otherChainInfoList.forEach(chainInfo -> {
            try {
                newTxList.add(TxUtil.createVerifierInitTx(chain.getVerifierList(), tx.getTime(), chainInfo.getChainId()));
            }
            catch (IOException e) {
                chain.getLogger().error("Transaction failure in assembling and resetting the main network validator list for parallel chain storage", (Exception)e);
            }
        });
        if (otherChainInfoList.size() != newTxList.size()) {
            return false;
        }
        newTxList.forEach(initOtherVerifierTx -> {
            chain.getCrossTxThreadPool().execute(new ResetOtherChainVerifierListHandler(chain, (Transaction)initOtherVerifierTx, syncStatus));
            String txHash = initOtherVerifierTx.getHash().toHex();
            this.resetOtherVerifierTxList.add(txHash);
            chain.getLogger().info("Initiate a transaction to reset the main chain verifier list stored in parallel chains,txHash:{}", new Object[]{txHash});
        });
        return true;
    }

    @Override
    public boolean rollbackTx(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return false;
        }
        return this.localVerifierService.rollback(chainId, blockHeader.getHeight());
    }

    @Override
    public boolean isResetOtherVerifierTx(String txHash) {
        return this.resetOtherVerifierTxList.contains(txHash);
    }

    @Override
    public void finishResetOtherVerifierTx(String txHash) {
        this.resetOtherVerifierTxList.remove(txHash);
    }
}

