/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.crosschain.base.message.BroadCtxHashMessage;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainChangeData;
import io.nuls.crosschain.base.model.bo.txdata.VerifierInitData;
import io.nuls.crosschain.base.utils.enumeration.ChainInfoChangeType;
import io.nuls.crosschain.model.bo.BroadFailFlag;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.po.VerifierChangeSendFailPO;
import io.nuls.crosschain.rpc.call.NetWorkCall;
import io.nuls.crosschain.srorage.ConvertCtxService;
import io.nuls.crosschain.srorage.CrossChangeBroadFailService;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.srorage.SendHeightService;
import io.nuls.crosschain.srorage.VerifierChangeBroadFailedService;
import io.nuls.crosschain.utils.MessageUtil;
import io.nuls.crosschain.utils.TxUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Component
public class BroadCtxUtil {
    @Autowired
    private static ChainManager chainManager;
    @Autowired
    private static SendHeightService sendHeightService;
    @Autowired
    private static NulsCoresConfig config;
    @Autowired
    private static ConvertCtxService convertCtxService;
    @Autowired
    private static CtxStatusService ctxStatusService;
    @Autowired
    private static VerifierChangeBroadFailedService verifierChangeBroadFailedService;
    @Autowired
    private static CrossChangeBroadFailService crossChangeBroadFailService;

    public static boolean broadCtxHash(Chain chain, NulsHash ctxHash, long cacheHeight, Map<Integer, Byte> crossStatusMap, Map<Integer, BroadFailFlag> broadFailMap) {
        int chainId = chain.getChainId();
        BroadCtxHashMessage message = new BroadCtxHashMessage();
        message.setConvertHash(ctxHash);
        Transaction ctx = ctxStatusService.get(ctxHash, chainId).getTx();
        try {
            if (ctx.getType() == config.getCrossCtxType() || ctx.getType() == 26) {
                return BroadCtxUtil.broadCrossTransferTx(chain, ctx, message, crossStatusMap, broadFailMap);
            }
            if (ctx.getType() == 24) {
                return BroadCtxUtil.broadVerifierChangeTx(chain, message, cacheHeight, crossStatusMap, broadFailMap);
            }
            if (ctx.getType() == 25) {
                VerifierInitData verifierInitData = new VerifierInitData();
                verifierInitData.parse(ctx.getTxData(), 0);
                if (!NetWorkCall.broadcast(verifierInitData.getRegisterChainId(), message, "recvCtxHash", true)) {
                    BroadFailFlag broadFailFlag = broadFailMap.get(verifierInitData.getRegisterChainId());
                    if (broadFailFlag == null) {
                        broadFailFlag = new BroadFailFlag();
                    }
                    broadFailFlag.setVerifierInitFlag(true);
                    broadFailMap.put(verifierInitData.getRegisterChainId(), broadFailFlag);
                    return false;
                }
                chain.getLogger().info("Verifier initialized transaction broadcast successfully,chainId:{}", new Object[]{verifierInitData.getRegisterChainId()});
            } else if (ctx.getType() == 60) {
                return BroadCtxUtil.broadCrossChainChangeTx(chain, message, cacheHeight, crossStatusMap, broadFailMap, ctx);
            }
            return true;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
    }

    private static boolean broadCrossTransferTx(Chain chain, Transaction ctx, BroadCtxHashMessage message, Map<Integer, Byte> crossStatusMap, Map<Integer, BroadFailFlag> broadFailMap) throws NulsException, IOException {
        boolean broadResult;
        BroadFailFlag broadFailFlag;
        boolean haveConflict;
        int toId = chain.getChainId();
        if (config.isMainNet()) {
            toId = AddressTool.getChainIdByAddress((byte[])((CoinTo)ctx.getCoinDataInstance().getTo().get(0)).getAddress());
        }
        boolean bl = haveConflict = (broadFailFlag = broadFailMap.get(toId)) != null && (broadFailFlag.isVerifierInitFlag() || broadFailFlag.isVerifierChangeFlag());
        if (haveConflict) {
            return false;
        }
        byte broadStatus = BroadCtxUtil.getBroadStatus(chain, toId, crossStatusMap);
        if (broadStatus == 0) {
            return true;
        }
        if (broadStatus == 1) {
            broadResult = false;
        } else {
            if (!config.isMainNet()) {
                NulsHash convertHash = TxUtil.friendConvertToMain(chain, ctx, 10).getHash();
                message.setConvertHash(convertHash);
                chain.getLogger().info("Broadcast cross chain transfer transactions to the main network, this chain protocolhash:{}Corresponding main network protocolhash:{}", new Object[]{ctx.getHash().toHex(), convertHash.toHex()});
            }
            broadResult = NetWorkCall.broadcast(toId, message, "recvCtxHash", true);
        }
        if (!broadResult) {
            if (broadFailFlag == null) {
                broadFailFlag = new BroadFailFlag();
            }
            broadFailFlag.setCrossChainTransferFlag(true);
            broadFailMap.put(toId, broadFailFlag);
            return false;
        }
        return true;
    }

    private static boolean broadVerifierChangeTx(Chain chain, BroadCtxHashMessage message, long cacheHeight, Map<Integer, Byte> crossStatusMap, Map<Integer, BroadFailFlag> broadFailMap) {
        int chainId = chain.getChainId();
        if (!chain.isMainChain()) {
            boolean haveConflict;
            BroadFailFlag broadFailFlag = broadFailMap.get(chainId);
            boolean bl = haveConflict = broadFailFlag != null && (broadFailFlag.isVerifierInitFlag() || broadFailFlag.isVerifierChangeFlag() || broadFailFlag.isCrossChainTransferFlag() || broadFailFlag.isCrossChainChangeFlag());
            if (haveConflict) {
                return false;
            }
            byte broadStatus = BroadCtxUtil.getBroadStatus(chain, chainId, crossStatusMap);
            if (broadStatus == 0) {
                return true;
            }
            if (broadStatus == 1 || !NetWorkCall.broadcast(chainId, message, "recvCtxHash", true)) {
                if (broadFailFlag == null) {
                    broadFailFlag = new BroadFailFlag();
                }
                broadFailFlag.setVerifierChangeFlag(true);
                broadFailMap.put(chainId, broadFailFlag);
                return false;
            }
            return true;
        }
        boolean broadResult = true;
        if (chainManager.getRegisteredCrossChainList() == null || chainManager.getRegisteredCrossChainList().isEmpty() || chainManager.getRegisteredCrossChainList().size() == 1) {
            chain.getLogger().info("No registration chain information available");
            return true;
        }
        VerifierChangeSendFailPO po = verifierChangeBroadFailedService.get(cacheHeight, chainId);
        HashSet<Integer> broadFailChains = new HashSet<Integer>();
        if (po != null) {
            for (Integer toChainId : po.getChains()) {
                boolean haveConflict;
                BroadFailFlag broadFailFlag = broadFailMap.get(toChainId);
                boolean bl = haveConflict = broadFailFlag != null && (broadFailFlag.isVerifierInitFlag() || broadFailFlag.isVerifierChangeFlag() || broadFailFlag.isCrossChainTransferFlag() || broadFailFlag.isCrossChainChangeFlag());
                if (haveConflict) {
                    broadFailChains.add(toChainId);
                    continue;
                }
                byte broadStatus = BroadCtxUtil.getBroadStatus(chain, toChainId, crossStatusMap);
                if (broadStatus == 0 || broadStatus != 1 && NetWorkCall.broadcast(toChainId, message, "recvCtxHash", true)) continue;
                broadResult = false;
                broadFailChains.add(toChainId);
                if (broadFailFlag == null) {
                    broadFailFlag = new BroadFailFlag();
                }
                broadFailFlag.setVerifierChangeFlag(true);
                broadFailMap.put(chainId, broadFailFlag);
            }
        } else {
            for (ChainInfo chainInfo : chainManager.getRegisteredCrossChainList()) {
                boolean haveConflict;
                int toChainId = chainInfo.getChainId();
                if (toChainId == chainId) continue;
                BroadFailFlag broadFailFlag = broadFailMap.get(toChainId);
                boolean bl = haveConflict = broadFailFlag != null && (broadFailFlag.isVerifierInitFlag() || broadFailFlag.isVerifierChangeFlag() || broadFailFlag.isCrossChainTransferFlag());
                if (haveConflict) {
                    broadFailChains.add(toChainId);
                    continue;
                }
                byte broadStatus = BroadCtxUtil.getBroadStatus(chain, toChainId, crossStatusMap);
                if (broadStatus == 0 || broadStatus != 1 && NetWorkCall.broadcast(toChainId, message, "recvCtxHash", true)) continue;
                broadResult = false;
                broadFailChains.add(toChainId);
                if (broadFailFlag == null) {
                    broadFailFlag = new BroadFailFlag();
                }
                broadFailFlag.setVerifierChangeFlag(true);
                broadFailMap.put(chainId, broadFailFlag);
            }
        }
        if (broadFailChains.isEmpty()) {
            verifierChangeBroadFailedService.delete(cacheHeight, chainId);
        } else {
            VerifierChangeSendFailPO failPO = new VerifierChangeSendFailPO(broadFailChains);
            verifierChangeBroadFailedService.save(cacheHeight, failPO, chainId);
        }
        return broadResult;
    }

    private static boolean broadCrossChainChangeTx(Chain chain, BroadCtxHashMessage message, long cacheHeight, Map<Integer, Byte> crossStatusMap, Map<Integer, BroadFailFlag> broadFailMap, Transaction ctx) {
        int chainId = chain.getChainId();
        if (!chain.isMainChain()) {
            chain.getLogger().error("The current chain is not the main network, and there should be no cross chain registration change transaction");
            return true;
        }
        RegisteredChainChangeData txData = new RegisteredChainChangeData();
        try {
            txData.parse(ctx.getTxData(), 0);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
        int toChainId = txData.getRegisterChainId();
        if (txData.getType() == ChainInfoChangeType.INIT_REGISTER_CHAIN.getType()) {
            boolean haveConflict;
            BroadFailFlag broadFailFlag = broadFailMap.get(toChainId);
            boolean bl = haveConflict = broadFailFlag != null && (broadFailFlag.isVerifierInitFlag() || broadFailFlag.isVerifierChangeFlag());
            if (haveConflict) {
                return false;
            }
            byte broadStatus = BroadCtxUtil.getBroadStatus(chain, toChainId, crossStatusMap);
            if (broadStatus == 0) {
                chain.getLogger().warn("The message receiving chain does not exist,toChainId:{}", new Object[]{toChainId});
                return true;
            }
            if (broadStatus == 1 || !NetWorkCall.broadcast(toChainId, message, "recvCtxHash", true)) {
                if (broadFailFlag == null) {
                    broadFailFlag = new BroadFailFlag();
                }
                broadFailFlag.setCrossChainChangeFlag(true);
                broadFailMap.put(toChainId, broadFailFlag);
                return false;
            }
            chain.getLogger().info("Cross chain change message broadcast successful\uff1atoChainId:{}", new Object[]{toChainId});
            return true;
        }
        VerifierChangeSendFailPO po = crossChangeBroadFailService.get(cacheHeight, chainId);
        HashSet<Integer> broadFailChains = new HashSet<Integer>();
        Set<Object> broadChains = new HashSet();
        if (po != null) {
            broadChains = po.getChains();
        } else {
            for (ChainInfo chainInfo : chainManager.getRegisteredCrossChainList()) {
                broadChains.add(chainInfo.getChainId());
            }
            if (txData.getType() == ChainInfoChangeType.NEW_REGISTER_CHAIN.getType()) {
                broadChains.remove(toChainId);
            }
            broadChains.remove(config.getMainChainId());
        }
        broadChains.remove(config.getMainChainId());
        chain.getLogger().info("Cross chain transactions need to be broadcasted tobroadChains:{}", new Object[]{broadChains});
        boolean broadResult = true;
        for (Integer n : broadChains) {
            boolean haveConflict;
            BroadFailFlag broadFailFlag = broadFailMap.get(n);
            boolean bl = haveConflict = broadFailFlag != null && (broadFailFlag.isVerifierInitFlag() || broadFailFlag.isVerifierChangeFlag());
            if (haveConflict) {
                broadFailChains.add(n);
                continue;
            }
            byte broadStatus = BroadCtxUtil.getBroadStatus(chain, n, crossStatusMap);
            if (broadStatus == 0) {
                chain.getLogger().warn("The message receiving chain does not exist,toChainId:{}", new Object[]{n});
                continue;
            }
            if (broadStatus != 1 && NetWorkCall.broadcast(n, message, "recvCtxHash", true)) continue;
            broadResult = false;
            broadFailChains.add(n);
            if (broadFailFlag == null) {
                broadFailFlag = new BroadFailFlag();
            }
            broadFailFlag.setVerifierChangeFlag(true);
            broadFailMap.put(chainId, broadFailFlag);
        }
        if (broadFailChains.isEmpty()) {
            crossChangeBroadFailService.delete(cacheHeight, chainId);
        } else {
            VerifierChangeSendFailPO verifierChangeSendFailPO = new VerifierChangeSendFailPO(broadFailChains);
            crossChangeBroadFailService.save(cacheHeight, verifierChangeSendFailPO, chainId);
            chain.getLogger().warn("Cross chain change message broadcast failed chainsbroadFailChains\uff1a{}", new Object[]{broadFailChains});
        }
        return broadResult;
    }

    private static byte getBroadStatus(Chain chain, int chainId, Map<Integer, Byte> crossStatusMap) {
        byte broadStatus;
        if (crossStatusMap == null) {
            broadStatus = MessageUtil.canSendMessage(chain, chainId);
        } else if (crossStatusMap.containsKey(chainId)) {
            broadStatus = crossStatusMap.get(chainId);
        } else {
            broadStatus = MessageUtil.canSendMessage(chain, chainId);
            crossStatusMap.put(chainId, broadStatus);
        }
        return broadStatus;
    }
}

