/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.Coin;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.crosschain.base.model.bo.txdata.VerifierChangeData;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.rpc.call.ConsensusCall;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class CommonUtil {
    @Autowired
    private static NulsCoresConfig config;

    public static <T> T getInstanceRpcStr(String data, Class<? extends BaseNulsData> clazz) throws NulsException {
        if (StringUtils.isBlank((String)data)) {
            throw new NulsException(NulsCrossChainErrorCode.DATA_NOT_FOUND);
        }
        return CommonUtil.getInstance(RPCUtil.decode((String)data), clazz);
    }

    public static <T> T getInstance(byte[] bytes, Class<? extends BaseNulsData> clazz) throws NulsException {
        if (null == bytes || bytes.length == 0) {
            throw new NulsException(NulsCrossChainErrorCode.DATA_NOT_FOUND);
        }
        try {
            BaseNulsData baseNulsData = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            baseNulsData.parse(new NulsByteBuffer(bytes));
            return (T)baseNulsData;
        }
        catch (NulsException e) {
            Log.error((Throwable)e);
            throw new NulsException(NulsCrossChainErrorCode.DESERIALIZE_ERROR);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            throw new NulsException(NulsCrossChainErrorCode.DESERIALIZE_ERROR);
        }
    }

    public static boolean isNulsAsset(Coin coin) {
        return CommonUtil.isNulsAsset(coin.getAssetsChainId(), coin.getAssetsId());
    }

    public static boolean isNulsAsset(int chainId, int assetId) {
        return chainId == config.getMainChainId() && assetId == config.getMainAssetId();
    }

    public static boolean isLocalAsset(Coin coin) {
        return CommonUtil.isLocalAsset(coin.getAssetsChainId(), coin.getAssetsId());
    }

    public static boolean isLocalAsset(int chainId, int assetId) {
        return chainId == config.getChainId() && assetId == config.getAssetId();
    }

    public static List<P2PHKSignature> getMisMatchSigns(Chain chain, TransactionSignature transactionSignature, List<String> addressList) {
        ArrayList<P2PHKSignature> misMatchSignList = new ArrayList<P2PHKSignature>();
        transactionSignature.setP2PHKSignatures(transactionSignature.getP2PHKSignatures().parallelStream().distinct().collect(Collectors.toList()));
        Iterator iterator = transactionSignature.getP2PHKSignatures().iterator();
        HashSet<String> signedList = new HashSet<String>();
        while (iterator.hasNext()) {
            P2PHKSignature signature = (P2PHKSignature)iterator.next();
            boolean isMatchSign = false;
            String validAddress = AddressTool.getAddressString((byte[])signature.getPublicKey(), (int)chain.getChainId());
            if (signedList.contains(validAddress)) break;
            for (String address : addressList) {
                if (!address.equals(validAddress)) continue;
                signedList.add(address);
                isMatchSign = true;
                break;
            }
            if (isMatchSign) continue;
            misMatchSignList.add(signature);
            iterator.remove();
        }
        chain.getLogger().debug("Verification successful account list,signedList:{}", new Object[]{signedList});
        return misMatchSignList;
    }

    public static int getByzantineCount(Chain chain, int agentCount) {
        int byzantineRatio = chain.getConfig().getByzantineRatio();
        int minPassCount = agentCount * byzantineRatio / 100;
        if (minPassCount == 0) {
            minPassCount = 1;
        }
        chain.getLogger().debug("The current number of consensus nodes is\uff1a{},The minimum number of signatures is:{}", new Object[]{agentCount, minPassCount});
        return minPassCount;
    }

    public static int getByzantineCount(Transaction ctx, List<String> packAddressList, Chain chain) throws NulsException {
        int agentCount = packAddressList.size();
        int chainId = chain.getChainId();
        int byzantineRatio = chain.getConfig().getByzantineRatio();
        if (ctx.getType() == 24) {
            VerifierChangeData verifierChangeData = new VerifierChangeData();
            verifierChangeData.parse(ctx.getTxData(), 0);
            if (verifierChangeData.getCancelAgentList() != null) {
                agentCount += verifierChangeData.getCancelAgentList().size();
            }
            if (verifierChangeData.getRegisterAgentList() != null) {
                agentCount -= verifierChangeData.getRegisterAgentList().size();
            }
        } else if (ctx.getType() == config.getCrossCtxType()) {
            int fromChainId = AddressTool.getChainIdByAddress((byte[])((CoinFrom)ctx.getCoinDataInstance().getFrom().get(0)).getAddress());
            int toChainId = AddressTool.getChainIdByAddress((byte[])((CoinTo)ctx.getCoinDataInstance().getTo().get(0)).getAddress());
            if ((chainId == fromChainId || chainId != toChainId && config.isMainNet()) && (byzantineRatio += 10) > 100) {
                byzantineRatio = 100;
            }
        }
        int minPassCount = agentCount * byzantineRatio / 100;
        if (minPassCount == 0) {
            minPassCount = 1;
        }
        chain.getLogger().debug("The current number of consensus nodes is\uff1a{},The minimum number of signatures is:{}", new Object[]{agentCount, minPassCount});
        return minPassCount;
    }

    public static int getByzantineCount(List<String> packAddressList, Chain chain, boolean isFromChain) {
        int minPassCount;
        int agentCount = packAddressList.size();
        int byzantineRatio = chain.getConfig().getByzantineRatio();
        if (isFromChain && (byzantineRatio += 10) > 100) {
            byzantineRatio = 100;
        }
        if ((minPassCount = agentCount * byzantineRatio / 100) == 0) {
            minPassCount = 1;
        }
        chain.getLogger().debug("The current number of consensus nodes is\uff1a{},The minimum number of signatures is:{}", new Object[]{agentCount, minPassCount});
        return minPassCount;
    }

    public static List<String> getCurrentPackAddressList(Chain chain) {
        Map packerInfo = ConsensusCall.getPackerInfo(chain);
        return (List)packerInfo.get("packAddressList");
    }
}

