/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Coin;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import io.nuls.crosschain.base.message.BroadCtxSignMessage;
import io.nuls.crosschain.base.message.GetCtxStateMessage;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.bo.txdata.CrossTransferData;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainChangeData;
import io.nuls.crosschain.base.model.bo.txdata.VerifierChangeData;
import io.nuls.crosschain.base.model.bo.txdata.VerifierInitData;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.bo.CtxStateEnum;
import io.nuls.crosschain.model.bo.message.UntreatedMessage;
import io.nuls.crosschain.model.bo.message.WaitBroadSignMessage;
import io.nuls.crosschain.model.po.CtxStatusPO;
import io.nuls.crosschain.rpc.call.AccountCall;
import io.nuls.crosschain.rpc.call.ConsensusCall;
import io.nuls.crosschain.rpc.call.NetWorkCall;
import io.nuls.crosschain.srorage.ConvertCtxService;
import io.nuls.crosschain.srorage.ConvertHashService;
import io.nuls.crosschain.srorage.CtxStateService;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.utils.MessageUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Component
public class TxUtil {
    @Autowired
    private static NulsCoresConfig config;
    @Autowired
    private static ConvertCtxService convertCtxService;
    @Autowired
    private static CtxStatusService ctxStatusService;
    @Autowired
    private static ConvertHashService convertHashService;
    @Autowired
    private static CtxStateService ctxStateService;
    @Autowired
    private static ChainManager chainManager;

    public static Transaction friendConvertToMain(Chain chain, Transaction friendCtx, int ctxType) throws NulsException, IOException {
        return TxUtil.friendConvertToMain(chain, friendCtx, ctxType, false);
    }

    public static Transaction friendConvertToMain(Chain chain, Transaction friendCtx, int ctxType, boolean needSign) throws NulsException, IOException {
        Transaction mainCtx = new Transaction(ctxType);
        mainCtx.setRemark(friendCtx.getRemark());
        mainCtx.setTime(friendCtx.getTime());
        mainCtx.setTxData(friendCtx.getTxData());
        CoinData realCoinData = friendCtx.getCoinDataInstance();
        TxUtil.restoreCoinData(realCoinData);
        mainCtx.setCoinData(realCoinData.serialize());
        int fromChainId = AddressTool.getChainIdByAddress((byte[])((CoinFrom)realCoinData.getFrom().get(0)).getAddress());
        if (chain.getChainId() == fromChainId) {
            CrossTransferData crossTransferData = new CrossTransferData();
            crossTransferData.parse(friendCtx.getTxData(), 0);
            crossTransferData.setSourceHash(friendCtx.getHash().getBytes());
            mainCtx.setTxData(crossTransferData.serialize());
        } else {
            mainCtx.setTxData(friendCtx.getTxData());
        }
        if (needSign) {
            mainCtx.setTransactionSignature(friendCtx.getTransactionSignature());
        }
        chain.getLogger().debug("The cross chain transaction of this chain protocol is transferred to the main network protocol, and the cross chain transaction is completed!");
        return mainCtx;
    }

    public static Transaction mainConvertToFriend(Transaction mainCtx, int ctxType) {
        Transaction friendCtx = new Transaction(ctxType);
        friendCtx.setRemark(mainCtx.getRemark());
        friendCtx.setTime(mainCtx.getTime());
        friendCtx.setTxData(mainCtx.getTxData());
        friendCtx.setCoinData(mainCtx.getCoinData());
        return friendCtx;
    }

    public static Transaction createVerifierChangeTx(List<String> registerAgentList, List<String> cancelAgentList, long time, int chainId) throws IOException {
        Transaction verifierChangeTx = new Transaction(24);
        verifierChangeTx.setTime(time);
        if (registerAgentList != null) {
            registerAgentList.sort(Comparator.naturalOrder());
        }
        if (cancelAgentList != null) {
            cancelAgentList.sort(Comparator.naturalOrder());
        }
        VerifierChangeData verifierChangeData = new VerifierChangeData(registerAgentList, cancelAgentList, chainId);
        verifierChangeTx.setTxData(verifierChangeData.serialize());
        return verifierChangeTx;
    }

    public static Transaction createVerifierInitTx(List<String> verifierList, long time, int registerChainId) throws IOException {
        Transaction verifierInitTx = new Transaction(25);
        verifierInitTx.setTime(time);
        VerifierInitData verifierInitData = new VerifierInitData(registerChainId, verifierList);
        verifierInitTx.setTxData(verifierInitData.serialize());
        return verifierInitTx;
    }

    public static Transaction createCrossChainChangeTx(long time, int registerChainId, int type) throws IOException {
        Transaction crossChainChangeTx = new Transaction(60);
        crossChainChangeTx.setTime(time);
        ArrayList<ChainInfo> chainInfoList = new ArrayList<ChainInfo>();
        RegisteredChainChangeData txData = new RegisteredChainChangeData(registerChainId, type, chainInfoList);
        crossChainChangeTx.setTxData(txData.serialize());
        return crossChainChangeTx;
    }

    public static Transaction createCrossChainChangeTx(ChainInfo chainInfo, long time, int registerChainId, int type) throws IOException {
        Transaction crossChainChangeTx = new Transaction(60);
        crossChainChangeTx.setTime(time);
        ArrayList<ChainInfo> chainInfoList = new ArrayList<ChainInfo>();
        chainInfoList.add(chainInfo);
        RegisteredChainChangeData txData = new RegisteredChainChangeData(registerChainId, type, chainInfoList);
        crossChainChangeTx.setTxData(txData.serialize());
        return crossChainChangeTx;
    }

    public static Transaction createCrossChainChangeTx(List<ChainInfo> chainInfoList, long time, int registerChainId, int type) throws IOException {
        Transaction crossChainChangeTx = new Transaction(60);
        crossChainChangeTx.setTime(time);
        RegisteredChainChangeData txData = new RegisteredChainChangeData(registerChainId, type, chainInfoList);
        crossChainChangeTx.setTxData(txData.serialize());
        return crossChainChangeTx;
    }

    public static void verifierChangeWait(Chain chain, long height) {
        while (chainManager.getChainHeaderMap().get(chain.getChainId()).getHeight() < height - 1L) {
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                chain.getLogger().error((Exception)e);
            }
        }
    }

    public static void localCtxByzantine(Transaction ctx, Chain chain) {
        if (config.getCrossTxDropTime() > ctx.getTime()) {
            chain.getLogger().warn("The cross-chain transaction has expired and is no longer signed locally");
            return;
        }
        int chainId = chain.getChainId();
        NulsHash hash = ctx.getHash();
        try {
            Map packerInfo = ConsensusCall.getPackerInfo(chain);
            String password = (String)packerInfo.get("password");
            List localPackers = (List)packerInfo.get("addresses");
            List packAddressList = (List)packerInfo.get("packAddressList");
            NulsHash convertHash = hash;
            if (!config.isMainNet()) {
                Transaction mainCtx = TxUtil.friendConvertToMain(chain, ctx, 10);
                convertHash = mainCtx.getHash();
                convertCtxService.save(hash, mainCtx, chainId);
            }
            CtxStatusPO ctxStatusPO = new CtxStatusPO(ctx, TxStatusEnum.UNCONFIRM.getStatus());
            if (!localPackers.isEmpty()) {
                BroadCtxSignMessage message = new BroadCtxSignMessage();
                message.setLocalHash(hash);
                TransactionSignature transactionSignature = new TransactionSignature();
                if (ctx.getTransactionSignature() != null) {
                    transactionSignature.parse(ctx.getTransactionSignature(), 0);
                } else {
                    ArrayList p2PHKSignatures = new ArrayList();
                    transactionSignature.setP2PHKSignatures(p2PHKSignatures);
                }
                for (String packerAddress : localPackers) {
                    P2PHKSignature p2PHKSignature;
                    if (!chain.getVerifierList().contains(packerAddress)) continue;
                    if (config.isMainNet()) {
                        if (ctx.getType() == 10 && ctx.getCoinDataInstance().getFromAddressList().contains(packerAddress)) {
                            message.setSignature(((P2PHKSignature)transactionSignature.getP2PHKSignatures().get(0)).serialize());
                        } else {
                            p2PHKSignature = AccountCall.signDigest(packerAddress, password, hash.getBytes());
                            transactionSignature.getP2PHKSignatures().add(p2PHKSignature);
                            message.setSignature(p2PHKSignature.serialize());
                        }
                    } else {
                        p2PHKSignature = AccountCall.signDigest(packerAddress, password, convertHash.getBytes());
                        transactionSignature.getP2PHKSignatures().add(p2PHKSignature);
                        message.setSignature(p2PHKSignature.serialize());
                    }
                    NetWorkCall.broadcast(chainId, message, "recvCtxSign", false);
                }
                MessageUtil.signByzantineInChain(chain, ctx, transactionSignature, packAddressList, hash);
            } else {
                ctxStatusService.save(hash, ctxStatusPO, chainId);
            }
            if (chain.getFutureMessageMap().containsKey(hash)) {
                chain.getLogger().debug("Transfer this cross chain transaction:{}Received signature placed in message queue", new Object[]{hash.toHex()});
                chain.getSignMessageByzantineQueue().addAll((Collection<UntreatedMessage>)chain.getFutureMessageMap().remove(hash));
            }
        }
        catch (NulsException | IOException e) {
            chain.getLogger().error((Exception)e);
        }
    }

    public static void handleResetOtherVerifierListCtx(Transaction ctx, Chain chain) {
        int chainId = chain.getChainId();
        NulsHash hash = ctx.getHash();
        String hashHex = hash.toHex();
        List<String> verifierList = chain.getVerifierList();
        Map packerInfo = ConsensusCall.getPackerInfo(chain);
        String password = (String)packerInfo.get("password");
        String address = (String)packerInfo.get("address");
        BroadCtxSignMessage message = new BroadCtxSignMessage();
        message.setLocalHash(hash);
        CtxStatusPO ctxStatusPO = new CtxStatusPO(ctx, TxStatusEnum.UNCONFIRM.getStatus());
        boolean byzantinePass = false;
        boolean sign = verifierList.contains(address);
        if (sign) {
            chain.getLogger().info("This node is a consensus node that signs cross chain transactions,Hash:{}", new Object[]{hashHex});
            try {
                P2PHKSignature p2PHKSignature = AccountCall.signDigest(address, password, hash.getBytes());
                message.setSignature(p2PHKSignature.serialize());
                TransactionSignature signature = new TransactionSignature();
                ArrayList<P2PHKSignature> p2PHKSignatureList = new ArrayList<P2PHKSignature>();
                p2PHKSignatureList.add(p2PHKSignature);
                signature.setP2PHKSignatures(p2PHKSignatureList);
                ctx.setTransactionSignature(signature.serialize());
                byzantinePass = MessageUtil.verifierInitLocalByzantine(chain, ctx, signature, verifierList, hash, Float.valueOf(1.0f));
            }
            catch (Exception e) {
                chain.getLogger().error(e);
                chain.getLogger().error("Signature error!,hash:{}", new Object[]{hashHex});
                return;
            }
            if (!chain.getWaitBroadSignMap().keySet().contains(hash)) {
                chain.getWaitBroadSignMap().put(hash, new HashSet());
            }
            chain.getWaitBroadSignMap().get(hash).add(new WaitBroadSignMessage(null, message));
        } else {
            chain.getLogger().debug("This node is not a consensus node and will not sign this transaction,Hash:{}", new Object[]{hashHex});
            ctxStatusService.save(hash, ctxStatusPO, chainId);
        }
        if (byzantinePass) {
            chain.getFutureMessageMap().remove(hash);
        } else if (chain.getFutureMessageMap().containsKey(hash)) {
            chain.getSignMessageByzantineQueue().addAll((Collection<UntreatedMessage>)chain.getFutureMessageMap().remove(hash));
        }
        MessageUtil.broadcastCtx(chain, hash, chainId, hashHex);
    }

    public static void handleNewCtx(Transaction ctx, Chain chain, List<String> cancelList) {
        boolean sign;
        int chainId = chain.getChainId();
        NulsHash hash = ctx.getHash();
        String hashHex = hash.toHex();
        Map packerInfo = ConsensusCall.getPackerInfo(chain);
        List localPackers = (List)packerInfo.get("addresses");
        List verifierList = chain.getVerifierList();
        if (ctx.getType() == 25) {
            packerInfo = ConsensusCall.getSeedNodeList(chain);
            verifierList = (List)packerInfo.get("packAddressList");
        } else {
            packerInfo = ConsensusCall.getPackerInfo(chain);
        }
        String password = (String)packerInfo.get("password");
        String address = (String)packerInfo.get("address");
        CtxStatusPO ctxStatusPO = new CtxStatusPO(ctx, TxStatusEnum.UNCONFIRM.getStatus());
        boolean byzantinePass = false;
        boolean bl = sign = !StringUtils.isBlank((String)address) && verifierList.contains(address);
        if (sign && cancelList != null) {
            boolean bl2 = sign = !cancelList.contains(address);
        }
        if (sign) {
            chain.getLogger().info("This node is a consensus node that signs cross chain transactions,Hash:{}", new Object[]{hashHex});
            TransactionSignature signature = new TransactionSignature();
            HashSet<WaitBroadSignMessage> messageList = new HashSet<WaitBroadSignMessage>();
            ArrayList<P2PHKSignature> p2PHKSignatureList = new ArrayList<P2PHKSignature>();
            for (String packageAddress : localPackers) {
                try {
                    P2PHKSignature p2PHKSignature = AccountCall.signDigest(packageAddress, password, hash.getBytes());
                    BroadCtxSignMessage message = new BroadCtxSignMessage();
                    message.setLocalHash(hash);
                    message.setSignature(p2PHKSignature.serialize());
                    messageList.add(new WaitBroadSignMessage(null, message));
                    p2PHKSignatureList.add(p2PHKSignature);
                }
                catch (Exception e) {
                    chain.getLogger().error(e);
                    chain.getLogger().error("Signature error!,hash:{}", new Object[]{hashHex});
                    return;
                }
            }
            try {
                signature.setP2PHKSignatures(p2PHKSignatureList);
                ctx.setTransactionSignature(signature.serialize());
                byzantinePass = MessageUtil.signByzantineInChain(chain, ctx, signature, verifierList, hash);
            }
            catch (Exception e) {
                chain.getLogger().error(e);
                chain.getLogger().error("Signature error!,hash:{}", new Object[]{hashHex});
                return;
            }
            if (!chain.getWaitBroadSignMap().keySet().contains(hash)) {
                chain.getWaitBroadSignMap().put(hash, messageList);
            } else {
                chain.getWaitBroadSignMap().get(hash).addAll(messageList);
            }
        } else {
            ctxStatusService.save(hash, ctxStatusPO, chainId);
        }
        if (!config.isMainNet()) {
            convertHashService.save(hash, hash, chainId);
        }
        if (byzantinePass) {
            chain.getFutureMessageMap().remove(hash);
        } else if (chain.getFutureMessageMap().containsKey(hash)) {
            chain.getSignMessageByzantineQueue().addAll((Collection<UntreatedMessage>)chain.getFutureMessageMap().remove(hash));
        }
        MessageUtil.broadcastCtx(chain, hash, chainId, hashHex);
    }

    public static void signAndBroad(Chain chain, Transaction ctx) {
        boolean sign;
        Map packerInfo;
        List verifierList = chain.getVerifierList();
        if (ctx.getType() == 25) {
            packerInfo = ConsensusCall.getSeedNodeList(chain);
            verifierList = (List)packerInfo.get("packAddressList");
        } else {
            packerInfo = ConsensusCall.getPackerInfo(chain);
        }
        String password = (String)packerInfo.get("password");
        String address = (String)packerInfo.get("address");
        boolean bl = sign = !StringUtils.isBlank((String)address) && verifierList.contains(address);
        if (!sign) {
            return;
        }
        BroadCtxSignMessage message = new BroadCtxSignMessage();
        message.setLocalHash(ctx.getHash());
        Transaction realTx = ctx;
        try {
            if (ctx.getType() == 10 && !config.isMainNet()) {
                realTx = TxUtil.friendConvertToMain(chain, ctx, 10);
            }
            P2PHKSignature p2PHKSignature = AccountCall.signDigest(address, password, realTx.getHash().getBytes());
            message.setSignature(p2PHKSignature.serialize());
            NetWorkCall.broadcast(chain.getChainId(), message, "recvCtxSign", false);
        }
        catch (NulsException | IOException e) {
            chain.getLogger().error((Exception)e);
        }
    }

    public static byte getCtxState(Chain chain, NulsHash ctxHash) {
        int chainId = chain.getChainId();
        if (ctxStateService.get(ctxHash.getBytes(), chainId)) {
            return CtxStateEnum.CONFIRMED.getStatus();
        }
        try {
            byte result;
            CtxStatusPO ctxStatusPO = ctxStatusService.get(ctxHash, chainId);
            int fromChainId = AddressTool.getChainIdByAddress((byte[])((CoinFrom)ctxStatusPO.getTx().getCoinDataInstance().getFrom().get(0)).getAddress());
            if (chainId == fromChainId && ctxStatusPO.getStatus() != TxStatusEnum.CONFIRMED.getStatus()) {
                return CtxStateEnum.UNCONFIRM.getStatus();
            }
            GetCtxStateMessage message = new GetCtxStateMessage();
            NulsHash requestHash = ctxHash;
            int linkedChainId = chainId;
            if (!config.isMainNet()) {
                requestHash = TxUtil.friendConvertToMain(chain, ctxStatusPO.getTx(), 10).getHash();
            } else {
                linkedChainId = AddressTool.getChainIdByAddress((byte[])((CoinTo)ctxStatusPO.getTx().getCoinDataInstance().getTo().get(0)).getAddress());
            }
            if (MessageUtil.canSendMessage(chain, linkedChainId) != 2) {
                return CtxStateEnum.UNCONFIRM.getStatus();
            }
            message.setRequestHash(requestHash);
            NetWorkCall.broadcast(linkedChainId, message, "getCtxState", true);
            if (!chain.getCtxStateMap().containsKey(requestHash)) {
                chain.getCtxStateMap().put(requestHash, new ArrayList());
            }
            if ((result = TxUtil.statisticsCtxState(chain, linkedChainId, requestHash)) == CtxStateEnum.CONFIRMED.getStatus()) {
                ctxStateService.save(ctxHash.getBytes(), chainId);
            }
            return result;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return CtxStateEnum.UNCONFIRM.getStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte statisticsCtxState(Chain chain, int linkedChainId, NulsHash requestHash) {
        byte ctxState = CtxStateEnum.UNCONFIRM.getStatus();
        try {
            int linkedNode = NetWorkCall.getAvailableNodeAmount(linkedChainId, true);
            HashMap<Byte, Integer> ctxStateMap = new HashMap<Byte, Integer>(4);
            for (int tryCount = 0; tryCount < 5; ++tryCount) {
                for (Byte state : chain.getCtxStateMap().get(requestHash)) {
                    if (ctxStateMap.containsKey(state)) {
                        int count = (Integer)ctxStateMap.get(state);
                        if (++count < linkedNode / 2) continue;
                        byte by = state;
                        return by;
                    }
                    ctxStateMap.put(state, 1);
                }
                if (chain.getCtxStateMap().get(requestHash).size() >= linkedNode) break;
                Thread.sleep(2000L);
            }
            int maxCount = 0;
            for (Map.Entry entry : ctxStateMap.entrySet()) {
                int value = (Integer)entry.getValue();
                if (value <= maxCount) continue;
                maxCount = value;
                ctxState = (Byte)entry.getKey();
            }
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            byte by = ctxState;
            return by;
        }
        finally {
            chain.getCtxStateMap().remove(requestHash);
        }
        return ctxState;
    }

    private static void restoreCoinData(CoinData coinData) {
        BigInteger amount;
        String key;
        HashMap<CallSite, BigInteger> assetMap = new HashMap<CallSite, BigInteger>(16);
        String mainKey = config.getMainChainId() + "_" + config.getMainAssetId();
        for (Coin coin : coinData.getFrom()) {
            key = coin.getAssetsChainId() + "_" + coin.getAssetsId();
            if (assetMap.containsKey(key)) {
                amount = ((BigInteger)assetMap.get(key)).add(coin.getAmount());
                assetMap.put((CallSite)((Object)key), amount);
                continue;
            }
            assetMap.put((CallSite)((Object)key), coin.getAmount());
        }
        for (Coin coin : coinData.getTo()) {
            key = coin.getAssetsChainId() + "_" + coin.getAssetsId();
            amount = ((BigInteger)assetMap.get(key)).subtract(coin.getAmount());
            assetMap.put((CallSite)((Object)key), amount);
        }
        block2: for (Map.Entry entry : assetMap.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (entryKey.equals(mainKey)) continue;
            BigInteger entryValue = (BigInteger)entry.getValue();
            Iterator it = coinData.getFrom().iterator();
            while (it.hasNext()) {
                Coin coin = (Coin)it.next();
                key = coin.getAssetsChainId() + "_" + coin.getAssetsId();
                if (!entryKey.equals(key)) continue;
                if (coin.getAmount().compareTo(entryValue) > 0) {
                    coin.setAmount(coin.getAmount().subtract(entryValue));
                    continue block2;
                }
                it.remove();
                entryValue = entryValue.subtract(coin.getAmount());
            }
        }
    }

    public static boolean signByzantineVerify(Chain chain, Transaction ctx, List<String> verifierList, int byzantineCount, int verifierChainId) throws NulsException {
        TransactionSignature transactionSignature = new TransactionSignature();
        try {
            transactionSignature.parse(ctx.getTransactionSignature(), 0);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            throw e;
        }
        if (ctx.getBlockHeight() > 3505754L && transactionSignature.getP2PHKSignatures().size() < byzantineCount) {
            chain.getLogger().error("The number of cross chain transaction signatures is less than the number of Byzantine signatures,Hash:{},signCount:{},byzantineCount:{}", new Object[]{ctx.getHash().toHex(), transactionSignature.getP2PHKSignatures().size(), byzantineCount});
            return false;
        }
        chain.getLogger().debug("Current Verifier List\uff1a{}", new Object[]{verifierList.toString()});
        Iterator iterator = transactionSignature.getP2PHKSignatures().iterator();
        int passCount = 0;
        HashSet<String> passedAddress = new HashSet<String>();
        block2: while (iterator.hasNext()) {
            P2PHKSignature signature = (P2PHKSignature)iterator.next();
            for (String verifier : verifierList) {
                if (passedAddress.contains(verifier) || !Arrays.equals(AddressTool.getAddress((byte[])signature.getPublicKey(), (int)verifierChainId), AddressTool.getAddress((String)verifier))) continue;
                passedAddress.add(verifier);
                ++passCount;
                continue block2;
            }
        }
        if (ctx.getBlockHeight() <= 3505754L && passCount == 5) {
            return true;
        }
        if (passCount < byzantineCount) {
            chain.getLogger().error("The number of cross chain transaction signature verifications passed is less than the Byzantine number,Hash:{},passCount:{},byzantineCount:{}", new Object[]{ctx.getHash().toHex(), passCount, byzantineCount});
            return false;
        }
        return true;
    }
}

