/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils.manager;

import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.po.CtxStatusPO;
import io.nuls.crosschain.model.po.LocalVerifierPO;
import io.nuls.crosschain.model.po.SendCtxHashPO;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.srorage.LocalVerifierService;
import io.nuls.crosschain.srorage.SendHeightService;
import java.util.ArrayList;
import java.util.List;

@Component
public class LocalVerifierManager {
    @Autowired
    private static LocalVerifierService localVerifierService;
    @Autowired
    private static SendHeightService sendHeightService;
    @Autowired
    private static CtxStatusService ctxStatusService;

    public static void loadLocalVerifier(Chain chain) {
        LocalVerifierPO localVerifierPO = localVerifierService.get(chain.getChainId());
        if (localVerifierPO == null || localVerifierPO.getVerifierList() == null || localVerifierPO.getVerifierList().isEmpty()) {
            chain.getLogger().info("Local verifier has not been initialized");
            return;
        }
        chain.setVerifierList(localVerifierPO.getVerifierList());
    }

    public static boolean initLocalVerifier(Chain chain, List<String> verifierList) {
        if (verifierList == null || verifierList.isEmpty()) {
            chain.getLogger().error("Local verifier is empty, data is abnormal");
            return false;
        }
        boolean saveResult = localVerifierService.save(new LocalVerifierPO(verifierList), chain.getChainId());
        if (!saveResult) {
            chain.getLogger().error("Failed to save local initialization verifier list");
            return false;
        }
        chain.setVerifierList(verifierList);
        chain.getLogger().info("Local verifier initialization complete,verifierList:{}", new Object[]{verifierList});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean localVerifierChangeCommit(Chain chain, Transaction ctx, List<String> reduceList, List<String> appendList, long height, NulsHash txHash, int syncStatus) {
        LocalVerifierPO localVerifierPO = localVerifierService.get(chain.getChainId());
        if (localVerifierPO == null || localVerifierPO.getVerifierList() == null || localVerifierPO.getVerifierList().isEmpty()) {
            chain.getLogger().error("Local verifier is empty, data is abnormal");
            return false;
        }
        chain.getSwitchVerifierLock().writeLock().lock();
        try {
            SendCtxHashPO sendCtxHashPO;
            boolean saveResult;
            if (reduceList != null && !reduceList.isEmpty()) {
                localVerifierPO.getVerifierList().removeAll(reduceList);
            }
            if (appendList != null && !appendList.isEmpty()) {
                localVerifierPO.getVerifierList().addAll(appendList);
            }
            if (!(saveResult = localVerifierService.save(localVerifierPO, chain.getChainId()))) {
                chain.getLogger().error("Failed to update local initialization verifier list");
                boolean bl = false;
                return bl;
            }
            CtxStatusPO ctxStatusPO = new CtxStatusPO(ctx, TxStatusEnum.CONFIRMED.getStatus());
            saveResult = ctxStatusService.save(txHash, ctxStatusPO, chain.getChainId());
            if (!saveResult) {
                chain.getLogger().error("Transaction processing status save error");
                boolean bl = false;
                return bl;
            }
            if (syncStatus == 1 && (sendCtxHashPO = sendHeightService.get(height, chain.getChainId())) == null) {
                ArrayList<NulsHash> arrayList = new ArrayList<NulsHash>();
                arrayList.add(txHash);
                sendCtxHashPO = new SendCtxHashPO(arrayList);
                sendHeightService.save(height, sendCtxHashPO, chain.getChainId());
            }
            chain.setVerifierList(localVerifierPO.getVerifierList());
            chain.setLastChangeHeight(height);
            chain.setVerifierChangeTx(null);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            chain.getLogger().error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            chain.getSwitchVerifierLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean localVerifierChangeRollback(Chain chain, List<String> reduceList, List<String> appendList, long height, NulsHash txHash) {
        LocalVerifierPO localVerifierPO = localVerifierService.get(chain.getChainId());
        if (localVerifierPO == null || localVerifierPO.getVerifierList() == null || localVerifierPO.getVerifierList().isEmpty()) {
            chain.getLogger().error("Local verifier is empty, data is abnormal");
            return false;
        }
        chain.getSwitchVerifierLock().writeLock().lock();
        try {
            boolean saveResult;
            if (reduceList != null && !reduceList.isEmpty()) {
                localVerifierPO.getVerifierList().addAll(reduceList);
            }
            if (appendList != null && !appendList.isEmpty()) {
                localVerifierPO.getVerifierList().removeAll(appendList);
            }
            if (!(saveResult = localVerifierService.save(localVerifierPO, chain.getChainId()))) {
                chain.getLogger().error("Failed to update local initialization verifier list");
                boolean bl = false;
                return bl;
            }
            SendCtxHashPO sendCtxHashPO = sendHeightService.get(height, chain.getChainId());
            if (sendCtxHashPO != null) {
                sendCtxHashPO.getHashList().remove(txHash);
                if (sendCtxHashPO.getHashList().isEmpty()) {
                    sendHeightService.delete(height, chain.getChainId());
                } else {
                    sendHeightService.save(height, sendCtxHashPO, chain.getChainId());
                }
            }
            chain.setVerifierList(localVerifierPO.getVerifierList());
            chain.setLastChangeHeight(height - 1L);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            chain.getLogger().error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            chain.getSwitchVerifierLock().writeLock().unlock();
        }
    }
}

