/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.manager;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.ledger.model.LedgerChain;
import io.nuls.ledger.service.AssetRegMngService;
import io.nuls.ledger.service.BlockDataService;
import io.nuls.ledger.storage.Repository;
import io.nuls.ledger.storage.impl.LgBlockSyncRepositoryImpl;
import io.nuls.ledger.storage.impl.RepositoryImpl;
import io.nuls.ledger.utils.LoggerUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class LedgerChainManager {
    @Autowired
    BlockDataService blockDataService;
    @Autowired
    AssetRegMngService assetRegMngService;
    @Autowired
    NulsCoresConfig ledgerConfig;
    private Map<Integer, LedgerChain> chainMap = new ConcurrentHashMap<Integer, LedgerChain>();
    Map<String, Object> localChainDefaultAsset = new HashMap<String, Object>(16);

    public void addChain(int chainId) throws Exception {
        if (null != this.chainMap.get(chainId)) {
            return;
        }
        LedgerChain ledgerChain = new LedgerChain(chainId);
        LoggerUtil.createLogger(chainId);
        ((RepositoryImpl)SpringLiteContext.getBean(RepositoryImpl.class)).initChainDb(chainId);
        ((LgBlockSyncRepositoryImpl)SpringLiteContext.getBean(LgBlockSyncRepositoryImpl.class)).initChainDb(chainId);
        this.chainMap.put(chainId, ledgerChain);
    }

    public void runChain(int chainId) throws Exception {
    }

    public void stopChain(int chainId) {
    }

    private void initLedgerDatas() throws Exception {
        this.blockDataService.initBlockDatas();
        this.assetRegMngService.initDBAssetsIdMap();
    }

    private void initRocksDb() {
        try {
            RocksDBService.init((String)(this.ledgerConfig.getDataPath() + File.separator + ModuleE.LG.name));
            Repository initDB = (Repository)SpringLiteContext.getBean(RepositoryImpl.class);
            initDB.initTableName();
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
        }
    }

    public void initChains() throws Exception {
        this.initRocksDb();
        this.initLedgerDatas();
    }

    public void syncBlockHeight() {
        try {
            this.blockDataService.syncBlockHeight();
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
        }
    }

    public LedgerChain getChain(int key) {
        return this.chainMap.get(key);
    }

    public Map<String, Object> getLocalChainDefaultAsset() {
        if (this.localChainDefaultAsset.size() > 0) {
            return this.localChainDefaultAsset;
        }
        this.localChainDefaultAsset.put("assetChainId", this.ledgerConfig.getChainId());
        this.localChainDefaultAsset.put("assetId", this.ledgerConfig.getAssetId());
        this.localChainDefaultAsset.put("initNumber", 0);
        this.localChainDefaultAsset.put("decimalPlace", this.ledgerConfig.getDecimals());
        this.localChainDefaultAsset.put("assetName", this.ledgerConfig.getSymbol());
        this.localChainDefaultAsset.put("assetSymbol", this.ledgerConfig.getSymbol());
        this.localChainDefaultAsset.put("assetType", (short)1);
        this.localChainDefaultAsset.put("assetAddress", "");
        return this.localChainDefaultAsset;
    }
}

