/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.rpc.cmd;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.manager.LedgerChainManager;
import io.nuls.ledger.utils.LoggerUtil;
import java.util.List;

public class BaseLedgerCmd
extends BaseCmd {
    boolean chainHanlder(int chainId) {
        try {
            ((LedgerChainManager)SpringLiteContext.getBean(LedgerChainManager.class)).addChain(chainId);
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error(e);
            return false;
        }
        return true;
    }

    Response parseTxs(List<String> txStrList, List<Transaction> txList, int chainId) {
        for (String txStr : txStrList) {
            Transaction tx = (Transaction)RPCUtil.getInstanceRpcStr((String)txStr, Transaction.class);
            if (null == tx) {
                return this.failed(LedgerErrorCode.TX_IS_WRONG);
            }
            txList.add(tx);
        }
        return this.success();
    }

    Transaction parseTxs(String txStr, int chainId) {
        if (StringUtils.isBlank((String)txStr)) {
            return null;
        }
        byte[] txStream = RPCUtil.decode((String)txStr);
        Transaction tx = new Transaction();
        try {
            tx.parse(new NulsByteBuffer(txStream));
        }
        catch (NulsException e) {
            LoggerUtil.logger(chainId).error("transaction parse error", (Exception)((Object)e));
            return null;
        }
        return tx;
    }
}

