/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.rpc.cmd;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.CmdPriority;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.model.ValidateResult;
import io.nuls.ledger.rpc.cmd.BaseLedgerCmd;
import io.nuls.ledger.service.TransactionService;
import io.nuls.ledger.storage.Repository;
import io.nuls.ledger.utils.LoggerUtil;
import io.nuls.ledger.validator.CoinDataValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.LG)
public class ValidatorCmd
extends BaseLedgerCmd {
    @Autowired
    CoinDataValidator coinDataValidator;
    @Autowired
    TransactionService transactionService;
    @Autowired
    Repository repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CmdAnnotation(cmd="verifyCoinDataBatchPackaged", version=1.0, description="Package transaction verification")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="txList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="[]Transaction List\uff08HEXValue List\uff09")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="fail", valueType=List.class, valueElement=String.class, description="Verification failedHashValue List"), @Key(name="orphan", valueType=List.class, valueElement=String.class, description="Verified as orphanedHashValue List"), @Key(name="success", valueType=List.class, valueElement=String.class, description="Verified successfullyHashValue List")}))
    public Response verifyCoinDataBatchPackaged(Map params) {
        ArrayList<Transaction> txList;
        Integer chainId;
        block10: {
            chainId = (Integer)params.get("chainId");
            if (!this.chainHanlder(chainId)) {
                return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
            }
            List txStrList = (List)params.get("txList");
            txList = new ArrayList<Transaction>();
            Response parseResponse = this.parseTxs(txStrList, txList, chainId);
            if (parseResponse.isSuccess()) break block10;
            LoggerUtil.logger(chainId).debug("verifyCoinDataBatchPackaged response={}", new Object[]{parseResponse});
            Response response = parseResponse;
            return response;
        }
        try {
            long packagingHeight = this.repository.getBlockHeight(chainId) + 1L;
            ArrayList<String> orphanList = new ArrayList<String>();
            ArrayList<String> successList = new ArrayList<String>();
            ArrayList<String> failList = new ArrayList<String>();
            for (Transaction tx : txList) {
                tx.setBlockHeight(packagingHeight);
                String txHash = tx.getHash().toHex();
                ValidateResult validateResult = this.coinDataValidator.bathValidatePerTx(chainId, tx);
                if (validateResult.isSuccess()) {
                    successList.add(txHash);
                    continue;
                }
                if (validateResult.isOrphan()) {
                    orphanList.add(txHash);
                    continue;
                }
                failList.add(txHash);
            }
            HashMap<String, ArrayList<String>> rtMap = new HashMap<String, ArrayList<String>>(3);
            if (failList.size() > 0) {
                LoggerUtil.logger(chainId).debug("verifyCoinDataBatchPackaged failed txs size={}", new Object[]{failList.size()});
            }
            rtMap.put("fail", failList);
            rtMap.put("orphan", orphanList);
            rtMap.put("success", successList);
            Response response = this.success(rtMap);
            return response;
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error("verifyCoinDataBatchPackaged exception ={}", e);
            Response response = this.failed(LedgerErrorCode.SYS_UNKOWN_EXCEPTION);
            return response;
        }
    }

    @CmdAnnotation(cmd="verifyCoinData", version=1.0, description="Unconfirmed transaction verification")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="tx", requestType=@TypeDescriptor(value=String.class), parameterDes="transactionHexvalue")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="orphan", valueType=Boolean.class, description="trueOrphans,falseNon orphan")}))
    public Response verifyCoinData(Map params) {
        Integer chainId = (Integer)params.get("chainId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        String txStr = (String)params.get("tx");
        Transaction tx = new Transaction();
        Response response = null;
        ValidateResult validateResult = null;
        try {
            tx.parse(RPCUtil.decode((String)txStr), 0);
            validateResult = this.coinDataValidator.verifyCoinData(chainId, tx);
            HashMap<String, Boolean> rtMap = new HashMap<String, Boolean>(1);
            if (validateResult.isSuccess() || validateResult.isOrphan()) {
                rtMap.put("orphan", validateResult.isOrphan());
                response = this.success(rtMap);
            } else {
                response = this.failed(validateResult.toErrorCode());
            }
            if (!validateResult.isSuccess()) {
                LoggerUtil.logger(chainId).debug("validateCoinData returnCode={},returnMsg={}", new Object[]{validateResult.getValidateCode(), validateResult.getValidateDesc()});
            }
        }
        catch (NulsException e) {
            response = this.failed(e.getErrorCode());
            LoggerUtil.logger(chainId).error("validateCoinData exception:{}", (Exception)((Object)e));
        }
        catch (Exception e) {
            response = this.failed("validateCoinData exception");
            LoggerUtil.logger(chainId).error("validateCoinData exception:{}", e);
        }
        return response;
    }

    @CmdAnnotation(cmd="rollbackTxValidateStatus", version=1.0, description="Rollback packaging verification status")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="tx", requestType=@TypeDescriptor(value=String.class), parameterDes="transactionHexvalue")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="trueRollback successful,falseRollback failed")}))
    public Response rollbackTxValidateStatus(Map params) {
        HashMap<String, Boolean> rtData = new HashMap<String, Boolean>(1);
        boolean value = false;
        Integer chainId = (Integer)params.get("chainId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        try {
            String txStr = params.get("tx").toString();
            LoggerUtil.logger(chainId).debug("rollbackrTxValidateStatus chainId={}", new Object[]{chainId});
            Transaction tx = this.parseTxs(txStr, chainId);
            if (null == tx) {
                LoggerUtil.logger(chainId).debug("txHex is invalid chainId={},txHex={}", new Object[]{chainId, txStr});
                return this.failed("txHex is invalid");
            }
            LoggerUtil.logger(chainId).debug("rollbackrTxValidateStatus chainId={},txHash={}", new Object[]{chainId, tx.getHash().toHex()});
            if (this.coinDataValidator.rollbackTxValidateStatus(chainId, tx)) {
                value = true;
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error(e);
        }
        rtData.put("value", value);
        Response response = this.success(rtData);
        return response;
    }

    @CmdAnnotation(cmd="batchValidateBegin", version=1.0, description="Start bulk packaging:Status notification")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="trueSuccessfully processed,falseProcessing failed")}))
    public Response batchValidateBegin(Map params) {
        Integer chainId = (Integer)params.get("chainId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        LoggerUtil.logger(chainId).debug("chainId={} batchValidateBegin", new Object[]{chainId});
        this.coinDataValidator.beginBatchPerTxValidate(chainId);
        HashMap<String, Boolean> rtData = new HashMap<String, Boolean>(1);
        rtData.put("value", true);
        return this.success(rtData);
    }

    @CmdAnnotation(cmd="blockValidate", version=1.0, priority=CmdPriority.HIGH, description="Whole block accounting verification")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="txList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="[]transactionHexValue List"), @Parameter(parameterName="blockHeight", requestType=@TypeDescriptor(value=long.class), parameterDes="block height")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="trueSuccessfully processed,falseProcessing failed")}))
    public Response blockValidate(Map params) {
        Integer chainId = (Integer)params.get("chainId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        long blockHeight = Long.valueOf(params.get("blockHeight").toString());
        List txStrList = (List)params.get("txList");
        LoggerUtil.logger(chainId).debug("chainId={} blockHeight={} blockValidate", new Object[]{chainId, blockHeight});
        if (null == txStrList || 0 == txStrList.size()) {
            LoggerUtil.logger(chainId).error("txStrList is blank");
            return this.failed("txStrList is blank");
        }
        LoggerUtil.logger(chainId).debug("commitBlockTxs txHexListSize={}", new Object[]{txStrList.size()});
        ArrayList<Transaction> txList = new ArrayList<Transaction>();
        Response parseResponse = this.parseTxs(txStrList, txList, chainId);
        if (!parseResponse.isSuccess()) {
            LoggerUtil.logger(chainId).debug("commitBlockTxs response={}", new Object[]{parseResponse});
            return parseResponse;
        }
        HashMap<String, Boolean> rtData = new HashMap<String, Boolean>(1);
        if (this.coinDataValidator.blockValidate(chainId, blockHeight, txList)) {
            rtData.put("value", true);
        } else {
            rtData.put("value", false);
        }
        LoggerUtil.logger(chainId).debug("chainId={} blockHeight={},return={}", new Object[]{chainId, blockHeight, rtData.get("value")});
        return this.success(rtData);
    }
}

