/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.service.impl;

import io.nuls.base.basic.AddressTool;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.model.po.LedgerAsset;
import io.nuls.ledger.model.tx.txdata.TxLedgerAsset;
import io.nuls.ledger.service.AssetRegMngService;
import io.nuls.ledger.service.ChainAssetsService;
import io.nuls.ledger.storage.AssetRegMngRepository;
import io.nuls.ledger.storage.Repository;
import io.nuls.ledger.utils.LedgerUtil;
import io.nuls.ledger.utils.LoggerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@Component
public class AssetRegMngServiceImpl
implements AssetRegMngService {
    @Autowired
    NulsCoresConfig ledgerConfig;
    @Autowired
    ChainAssetsService chainAssetsService;
    Map<String, AtomicInteger> DB_ASSETS_ID_MAX_MAP = new ConcurrentHashMap<String, AtomicInteger>();
    @Autowired
    AssetRegMngRepository assetRegMngRepository;
    @Autowired
    Repository repository;
    Map<String, Object> localChainDefaultAsset = new HashMap<String, Object>();

    public Map<String, Object> getLocalChainDefaultAsset() {
        if (this.localChainDefaultAsset.size() > 0) {
            return this.localChainDefaultAsset;
        }
        this.localChainDefaultAsset.put("assetId", this.ledgerConfig.getAssetId());
        this.localChainDefaultAsset.put("assetType", (short)1);
        this.localChainDefaultAsset.put("assetOwnerAddress", "");
        this.localChainDefaultAsset.put("initNumber", "");
        this.localChainDefaultAsset.put("decimalPlace", this.ledgerConfig.getDecimals());
        this.localChainDefaultAsset.put("assetName", this.ledgerConfig.getSymbol());
        this.localChainDefaultAsset.put("assetSymbol", this.ledgerConfig.getSymbol());
        this.localChainDefaultAsset.put("txHash", "");
        return this.localChainDefaultAsset;
    }

    @Override
    public void initDBAssetsIdMap() throws Exception {
        int assetId = this.assetRegMngRepository.loadDatas(this.ledgerConfig.getChainId());
        if (assetId == 0) {
            assetId = this.ledgerConfig.getAssetId();
        }
        this.DB_ASSETS_ID_MAX_MAP.put(String.valueOf(this.ledgerConfig.getChainId()), new AtomicInteger(assetId));
    }

    @Override
    public synchronized int getAndSetAssetIdByTemp(int chainId, int assetSize) {
        AtomicInteger assetIdAtomic = this.DB_ASSETS_ID_MAX_MAP.get(String.valueOf(chainId));
        int assetId = assetIdAtomic.addAndGet(assetSize);
        return assetId;
    }

    @Override
    public int getRegAssetId(int chainId) {
        AtomicInteger assetIdAtomic = this.DB_ASSETS_ID_MAX_MAP.get(String.valueOf(chainId));
        return assetIdAtomic.get();
    }

    @Override
    public String getRegAssetContractAddr(int chainId, int assetId) throws Exception {
        LedgerAsset ledgerAsset = this.assetRegMngRepository.getLedgerAssetByAssetId(chainId, assetId);
        if (null != ledgerAsset) {
            return AddressTool.getStringAddressByBytes((byte[])ledgerAsset.getAssetOwnerAddress());
        }
        return null;
    }

    @Override
    public int getRegAssetId(int chainId, String contractAddr) throws Exception {
        int assetId = this.assetRegMngRepository.getLedgerAssetIdByContractAddr(chainId, AddressTool.getAddress((String)contractAddr));
        return assetId;
    }

    @Override
    public ErrorCode batchAssetRegValidator(TxLedgerAsset txLedgerAsset, byte[] address, BigInteger destroyAsset, int chainId) {
        boolean isAddressValidate;
        ErrorCode errorCode = this.commonRegValidator(txLedgerAsset);
        if (null != errorCode) {
            return errorCode;
        }
        boolean bl = isAddressValidate = AddressTool.getChainIdByAddress((byte[])txLedgerAsset.getAddress()) == chainId;
        if (!isAddressValidate) {
            return LedgerErrorCode.ERROR_ADDRESS_ERROR;
        }
        if (!Arrays.equals(address, AddressTool.getAddressByPubKeyStr((String)this.ledgerConfig.getBlackHolePublicKey(), (int)chainId))) {
            LoggerUtil.COMMON_LOG.error("toAddress is not blackHole");
            return LedgerErrorCode.TX_IS_WRONG;
        }
        long decimal = (long)Math.pow(10.0, Integer.valueOf(this.ledgerConfig.getDecimals()).intValue());
        BigInteger destroyAssetTx = BigInteger.valueOf(this.ledgerConfig.getAssetRegDestroyAmount()).multiply(BigInteger.valueOf(decimal));
        if (!BigIntegerUtils.isEqual((BigInteger)destroyAsset, (BigInteger)destroyAssetTx)) {
            LoggerUtil.COMMON_LOG.error("destroyNuls={} is error", new Object[]{destroyAsset});
            return LedgerErrorCode.TX_IS_WRONG;
        }
        return null;
    }

    @Override
    public ErrorCode batchAssetRegValidatorV15(TxLedgerAsset txLedgerAsset, byte[] address, BigInteger destroyAsset, int chainId) {
        boolean isAddressValidate;
        ErrorCode errorCode = this.commonRegValidatorV15(txLedgerAsset);
        if (null != errorCode) {
            return errorCode;
        }
        boolean bl = isAddressValidate = AddressTool.getChainIdByAddress((byte[])txLedgerAsset.getAddress()) == chainId;
        if (!isAddressValidate) {
            return LedgerErrorCode.ERROR_ADDRESS_ERROR;
        }
        if (!Arrays.equals(address, AddressTool.getAddressByPubKeyStr((String)this.ledgerConfig.getBlackHolePublicKey(), (int)chainId))) {
            LoggerUtil.COMMON_LOG.error("toAddress is not blackHole");
            return LedgerErrorCode.TX_IS_WRONG;
        }
        long decimal = (long)Math.pow(10.0, Integer.valueOf(this.ledgerConfig.getDecimals()).intValue());
        BigInteger destroyAssetTx = BigInteger.valueOf(this.ledgerConfig.getAssetRegDestroyAmount()).multiply(BigInteger.valueOf(decimal));
        if (!BigIntegerUtils.isEqual((BigInteger)destroyAsset, (BigInteger)destroyAssetTx)) {
            LoggerUtil.COMMON_LOG.error("destroyNuls={} is error", new Object[]{destroyAsset});
            return LedgerErrorCode.TX_IS_WRONG;
        }
        return null;
    }

    @Override
    public ErrorCode commonRegValidator(TxLedgerAsset asset) {
        if (asset.getDecimalPlace() < 0 || asset.getDecimalPlace() > 18) {
            return LedgerErrorCode.ERROR_ASSET_DECIMALPLACES;
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getSymbol())) {
            return LedgerErrorCode.ERROR_ASSET_SYMBOL;
        }
        if (!FormatValidUtils.validTokenNameOrSymbol((String)asset.getName())) {
            return LedgerErrorCode.ERROR_ASSET_NAME;
        }
        return null;
    }

    public ErrorCode commonRegValidatorV15(TxLedgerAsset asset) {
        if (asset.getDecimalPlace() < 0 || asset.getDecimalPlace() > 18) {
            return LedgerErrorCode.ERROR_ASSET_DECIMALPLACES;
        }
        if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getSymbol())) {
            return LedgerErrorCode.ERROR_ASSET_SYMBOL;
        }
        if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getName())) {
            return LedgerErrorCode.ERROR_ASSET_NAME;
        }
        return null;
    }

    @Override
    public void registerTxAssets(int chainId, List<LedgerAsset> ledgerAssets) throws Exception {
        HashMap<byte[], byte[]> assets = new HashMap<byte[], byte[]>(ledgerAssets.size());
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>(ledgerAssets.size());
        int assetId = this.getRegAssetId(chainId);
        LoggerUtil.COMMON_LOG.info("1=assetId={}" + assetId);
        HashMap<byte[], byte[]> accountStatesMap = new HashMap<byte[], byte[]>(ledgerAssets.size());
        HashMap<String, List<String>> assetAddressIndex = new HashMap<String, List<String>>(4);
        for (LedgerAsset ledgerAsset : ledgerAssets) {
            ledgerAsset.setAssetType((short)1);
            LoggerUtil.COMMON_LOG.info("assetId={}" + ++assetId);
            ledgerAsset.setAssetId(assetId);
            assets.put(ByteUtils.intToBytes((int)ledgerAsset.getAssetId()), ledgerAsset.serialize());
            hashMap.put(HexUtil.decode((String)ledgerAsset.getTxHash()), ByteUtils.intToBytes((int)ledgerAsset.getAssetId()));
            String address = LedgerUtil.getRealAddressStr(ledgerAsset.getAssetOwnerAddress());
            String key = LedgerUtil.getKeyStr(address, chainId, assetId);
            AccountState accountState = new AccountState();
            long decimal = (long)Math.pow(10.0, Integer.valueOf(ledgerAsset.getDecimalPlace()).intValue());
            BigInteger amount = ledgerAsset.getInitNumber().multiply(BigInteger.valueOf(decimal));
            accountState.setTotalToAmount(amount);
            accountStatesMap.put(key.getBytes(LedgerConstant.DEFAULT_ENCODING), accountState.serialize());
            LedgerUtil.dealAssetAddressIndex(assetAddressIndex, chainId, ledgerAsset.getAssetId(), address);
        }
        this.assetRegMngRepository.batchSaveLedgerAssetReg(chainId, assets, hashMap);
        this.getAndSetAssetIdByTemp(chainId, ledgerAssets.size());
        this.chainAssetsService.updateChainAssets(chainId, assetAddressIndex);
        if (accountStatesMap.size() > 0) {
            this.assetRegMngRepository.batchUpdateAccountState(chainId, accountStatesMap);
        }
    }

    @Override
    public void rollBackTxAssets(int chainId, List<LedgerAsset> ledgerAssets) throws Exception {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        ArrayList<byte[]> delKeys = new ArrayList<byte[]>();
        ConcurrentHashMap<String, AccountState> delMap = new ConcurrentHashMap<String, AccountState>();
        for (LedgerAsset ledgerAsset : ledgerAssets) {
            byte[] hash = HexUtil.decode((String)ledgerAsset.getTxHash());
            list.add(hash);
            int assetId = this.assetRegMngRepository.getLedgerAssetIdByHash(chainId, hash);
            String address = LedgerUtil.getRealAddressStr(ledgerAsset.getAssetOwnerAddress());
            String key = LedgerUtil.getKeyStr(address, chainId, assetId);
            delMap.put(key, new AccountState());
            delKeys.add(key.getBytes(LedgerConstant.DEFAULT_ENCODING));
        }
        this.repository.clearAccountStateMem(chainId, delMap);
        this.assetRegMngRepository.batchRollBackLedgerAssetReg(chainId, list);
        this.assetRegMngRepository.batchDelAccountState(chainId, delKeys);
        this.initDBAssetsIdMap();
    }

    @Override
    public int registerContractAsset(int chainId, LedgerAsset ledgerAsset) throws Exception {
        ledgerAsset.setAssetId(this.getAndSetAssetIdByTemp(chainId, 1));
        this.assetRegMngRepository.saveLedgerAssetReg(chainId, ledgerAsset);
        return ledgerAsset.getAssetId();
    }

    @Override
    public void rollBackContractAsset(int chainId, String contractAddress) throws Exception {
        byte[] address = AddressTool.getAddress((String)contractAddress);
        int assetId = this.assetRegMngRepository.getLedgerAssetIdByContractAddr(chainId, address);
        if (assetId > 0) {
            this.assetRegMngRepository.deleteLedgerAssetReg(chainId, assetId);
            this.assetRegMngRepository.deleteLedgerAssetRegIndex(chainId, address);
        }
    }

    Map<String, Object> getAssetMapByLedgerAsset(LedgerAsset ledgerAsset) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetId", ledgerAsset.getAssetId());
        map.put("assetType", ledgerAsset.getAssetType());
        map.put("assetOwnerAddress", AddressTool.getStringAddressByBytes((byte[])ledgerAsset.getAssetOwnerAddress()));
        map.put("initNumber", ledgerAsset.getInitNumber());
        map.put("decimalPlace", ledgerAsset.getDecimalPlace());
        map.put("assetName", ledgerAsset.getAssetName());
        map.put("assetSymbol", ledgerAsset.getSymbol());
        map.put("txHash", ledgerAsset.getTxHash());
        return map;
    }

    @Override
    public List<Map<String, Object>> getLedgerRegAssets(int chainId, int assetType) throws Exception {
        List<LedgerAsset> assets = this.assetRegMngRepository.getAllRegLedgerAssets(chainId);
        ArrayList<Map<String, Object>> rtList = new ArrayList<Map<String, Object>>();
        Map<Object, Object> defaultAsset = new HashMap();
        if (this.ledgerConfig.getChainId() == chainId) {
            defaultAsset = this.getLocalChainDefaultAsset();
        }
        if (1 == assetType) {
            rtList.add(defaultAsset);
            for (LedgerAsset ledgerAsset : assets) {
                if (1 != ledgerAsset.getAssetType()) continue;
                rtList.add(this.getAssetMapByLedgerAsset(ledgerAsset));
            }
        } else if (2 == assetType) {
            for (LedgerAsset ledgerAsset : assets) {
                if (2 != ledgerAsset.getAssetType()) continue;
                rtList.add(this.getAssetMapByLedgerAsset(ledgerAsset));
            }
        } else {
            rtList.add(defaultAsset);
            for (LedgerAsset ledgerAsset : assets) {
                rtList.add(this.getAssetMapByLedgerAsset(ledgerAsset));
            }
        }
        return rtList;
    }

    @Override
    public Map<String, Object> getLedgerRegAsset(int chainId, String txHash) throws Exception {
        LedgerAsset ledgerAsset;
        byte[] hashByte = HexUtil.decode((String)txHash);
        int assetId = this.assetRegMngRepository.getLedgerAssetIdByHash(chainId, hashByte);
        if (assetId > 0 && null != (ledgerAsset = this.assetRegMngRepository.getLedgerAssetByAssetId(chainId, assetId))) {
            return this.getAssetMapByLedgerAsset(ledgerAsset);
        }
        return null;
    }

    @Override
    public Map<String, Object> getLedgerRegAsset(int chainId, int assetId) throws Exception {
        if (assetId == this.ledgerConfig.getAssetId()) {
            return this.getLocalChainDefaultAsset();
        }
        LedgerAsset ledgerAsset = this.assetRegMngRepository.getLedgerAssetByAssetId(chainId, assetId);
        if (null != ledgerAsset) {
            return this.getAssetMapByLedgerAsset(ledgerAsset);
        }
        return null;
    }

    @Override
    public boolean isContractAsset(int chainId, int assetId) {
        return this.assetRegMngRepository.isContractAsset(chainId, assetId);
    }
}

