/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.service.impl;

import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.ByteUtils;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.service.AccountStateService;
import io.nuls.ledger.service.ChainAssetsService;
import io.nuls.ledger.storage.AccountIndexRepository;
import io.nuls.ledger.utils.LoggerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class ChainAssetsServiceImpl
implements ChainAssetsService {
    @Autowired
    AccountIndexRepository accountIndexRepository;
    @Autowired
    AccountStateService accountStateService;

    @Override
    public void updateChainAssets(int addressChainid, Map<String, List<String>> assetAddressIndex) {
        try {
            byte[] value = ByteUtils.intToBytes((int)1);
            for (Map.Entry<String, List<String>> entry : assetAddressIndex.entrySet()) {
                String assetIndex = entry.getKey();
                byte[] indexBytes = assetIndex.getBytes(LedgerConstant.DEFAULT_ENCODING);
                this.accountIndexRepository.updateAssetsIndex(addressChainid, indexBytes, indexBytes);
                List<String> assetAddress = entry.getValue();
                String[] assetChainAssetId = assetIndex.split("-");
                int assetChainId = Integer.valueOf(assetChainAssetId[0]);
                int assetId = Integer.valueOf(assetChainAssetId[1]);
                HashMap<byte[], byte[]> assetAddressMap = new HashMap<byte[], byte[]>();
                for (String address : assetAddress) {
                    byte[] addrBytes = address.getBytes(LedgerConstant.DEFAULT_ENCODING);
                    assetAddressMap.put(addrBytes, value);
                }
                this.accountIndexRepository.updateAssetsAddressIndex(addressChainid, assetChainId, assetId, assetAddressMap);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainid).error(e);
        }
    }

    @Override
    public List<Map<String, Object>> getAssetsByChainId(int addressChainId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<String> assetKeys = this.accountIndexRepository.assetsKeyList(addressChainId);
        if (null != assetKeys) {
            for (String assetKey : assetKeys) {
                String[] assetChainAssetId = assetKey.split("-");
                int assetChainId = Integer.valueOf(assetChainAssetId[0]);
                int assetId = Integer.valueOf(assetChainAssetId[1]);
                Map<String, Object> asset = this.getAssetByChainAssetId(addressChainId, assetChainId, assetId);
                list.add(asset);
            }
        }
        return list;
    }

    @Override
    public Map<String, Object> getAssetByChainAssetId(int addressChainId, int assetChainId, int assetId) {
        List<String> addressKeys = this.accountIndexRepository.assetsAddressKeyList(addressChainId, assetChainId, assetId);
        HashMap<String, Object> asset = new HashMap<String, Object>();
        BigInteger amount = BigInteger.ZERO;
        BigInteger freeze = BigInteger.ZERO;
        if (null != addressKeys) {
            for (String addressKey : addressKeys) {
                AccountState accountState = this.accountStateService.getAccountStateReCal(addressKey, addressChainId, assetChainId, assetId);
                amount = amount.add(accountState.getAvailableAmount());
                freeze = freeze.add(accountState.getFreezeTotal());
            }
        }
        asset.put("assetId", assetId);
        asset.put("availableAmount", amount);
        asset.put("freeze", freeze);
        return asset;
    }
}

