/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.storage.impl;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.manager.RocksDBManager;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.model.po.BlockSnapshotTxs;
import io.nuls.ledger.storage.LgBlockSyncRepository;
import io.nuls.ledger.utils.LoggerUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
public class LgBlockSyncRepositoryImpl
implements LgBlockSyncRepository,
InitializingBean {
    @Autowired
    private NulsCoresConfig config;

    @Override
    public void saveOrUpdateSyncBlockHeight(int chainId, long height) {
        try {
            RocksDBService.put((String)this.getSyncBlockTableName(chainId), (byte[])ByteUtils.toBytes((CharSequence)("height-" + chainId), (String)LedgerConstant.DEFAULT_ENCODING), (byte[])ByteUtils.longToBytes((long)height));
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error("saveOrUpdateSyncBlockHeight serialize error.", e);
        }
    }

    @Override
    public void bakBlockInfosByHeight(int chainId, long height, BlockSnapshotTxs blockSnapshotTxs) {
        try {
            RocksDBService.put((String)this.getSyncBlockTableName(chainId), (byte[])ByteUtils.toBytes((CharSequence)("bak-" + height), (String)LedgerConstant.DEFAULT_ENCODING), (byte[])blockSnapshotTxs.serialize());
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error("bakBlockInfosByHeight serialize error.", e);
        }
    }

    @Override
    public BlockSnapshotTxs getBlockSnapshotTxs(int chainId, long height) {
        byte[] snapshot = RocksDBService.get((String)this.getSyncBlockTableName(chainId), (byte[])ByteUtils.toBytes((CharSequence)("bak-" + height), (String)LedgerConstant.DEFAULT_ENCODING));
        if (null != snapshot) {
            try {
                BlockSnapshotTxs blockSnapshotTxs = new BlockSnapshotTxs();
                blockSnapshotTxs.parse(snapshot, 0);
                return blockSnapshotTxs;
            }
            catch (NulsException e) {
                LoggerUtil.COMMON_LOG.error(e);
            }
        }
        return null;
    }

    @Override
    public void delBlockSnapshotTxs(int chainId, long height) {
        try {
            RocksDBService.delete((String)this.getSyncBlockTableName(chainId), (byte[])ByteUtils.toBytes((CharSequence)("bak-" + height), (String)LedgerConstant.DEFAULT_ENCODING));
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
        }
    }

    @Override
    public void saveBlockHashByHeight(int chainId, long height, String hash) {
        try {
            RocksDBService.put((String)this.getSyncBlockTableName(chainId), (byte[])ByteUtils.toBytes((CharSequence)("bHash-" + height), (String)LedgerConstant.DEFAULT_ENCODING), (byte[])ByteUtils.toBytes((CharSequence)hash, (String)LedgerConstant.DEFAULT_ENCODING));
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error("saveBlockHashByHeight serialize error.", e);
        }
    }

    @Override
    public String getBlockHash(int chainId, long height) {
        String table = this.getSyncBlockTableName(chainId);
        byte[] hashBytes = RocksDBService.get((String)table, (byte[])ByteUtils.toBytes((CharSequence)("bHash-" + height), (String)LedgerConstant.DEFAULT_ENCODING));
        if (null != hashBytes) {
            try {
                return new String(hashBytes, LedgerConstant.DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                LoggerUtil.logger(chainId).error("getBlockHash serialize error.", (Exception)e);
            }
        }
        return null;
    }

    @Override
    public void delBlockHash(int chainId, long height) {
        try {
            RocksDBService.delete((String)this.getSyncBlockTableName(chainId), (byte[])ByteUtils.toBytes((CharSequence)("bHash-" + height), (String)LedgerConstant.DEFAULT_ENCODING));
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
        }
    }

    @Override
    public long getSyncBlockHeight(int chainId) {
        String table = this.getSyncBlockTableName(chainId);
        byte[] heightBytes = RocksDBService.get((String)table, (byte[])ByteUtils.toBytes((CharSequence)("height-" + chainId), (String)LedgerConstant.DEFAULT_ENCODING));
        if (null == heightBytes) {
            return -1L;
        }
        return ByteUtils.byteToLong((byte[])heightBytes);
    }

    String getChainTableName(String tableName, int chainId) {
        return tableName + "_" + chainId;
    }

    public String getSyncBlockTableName(int chainId) {
        return this.getChainTableName("chain_block_datas", chainId);
    }

    String getLedgerNonceTableName(int chainId) {
        return this.getChainTableName("ledger_nonces", chainId);
    }

    String getLedgerHashTableName(int chainId) {
        return this.getChainTableName("ledger_tx_hashs", chainId);
    }

    public void initChainDb(int addressChainId) {
        try {
            RocksDBManager.setDataPath((String)(this.config.getDataPath() + File.separator + ModuleE.LG.name));
            if (!RocksDBService.existTable((String)this.getLedgerNonceTableName(addressChainId))) {
                RocksDBService.createTable((String)this.getLedgerNonceTableName(addressChainId));
            }
            if (!RocksDBService.existTable((String)this.getLedgerHashTableName(addressChainId))) {
                RocksDBService.createTable((String)this.getLedgerHashTableName(addressChainId));
            }
            if (!RocksDBService.existTable((String)this.getSyncBlockTableName(addressChainId))) {
                RocksDBService.createTable((String)this.getSyncBlockTableName(addressChainId));
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error(e);
        }
    }

    public void afterPropertiesSet() throws NulsException {
    }

    @Override
    public void initTableName() throws NulsException {
    }

    @Override
    public void saveAccountNonces(int chainId, Map<byte[], byte[]> noncesMap) throws Exception {
        String table = this.getLedgerNonceTableName(chainId);
        RocksDBManager.setDataPath((String)(this.config.getDataPath() + File.separator + ModuleE.LG.name));
        if (!RocksDBService.existTable((String)table)) {
            RocksDBService.createTable((String)table);
        }
        if (noncesMap.size() > 0) {
            RocksDBService.batchPut((String)table, noncesMap);
        }
    }

    @Override
    public void deleteAccountNonces(int chainId, String accountNonceKey) throws Exception {
        RocksDBService.delete((String)this.getLedgerNonceTableName(chainId), (byte[])ByteUtils.toBytes((CharSequence)accountNonceKey, (String)LedgerConstant.DEFAULT_ENCODING));
    }

    @Override
    public boolean existAccountNonce(int chainId, String accountNonceKey) throws Exception {
        return null != RocksDBService.get((String)this.getLedgerNonceTableName(chainId), (byte[])ByteUtils.toBytes((CharSequence)accountNonceKey, (String)LedgerConstant.DEFAULT_ENCODING));
    }

    @Override
    public void saveAccountHash(int chainId, Map<byte[], byte[]> hashMap) throws Exception {
        String table = this.getLedgerHashTableName(chainId);
        if (hashMap.size() > 0) {
            RocksDBService.batchPut((String)table, hashMap);
        }
    }

    @Override
    public void batchDeleteAccountHash(int chainId, List<String> hashList) throws Exception {
        String table = this.getLedgerHashTableName(chainId);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (String hash : hashList) {
            list.add(ByteUtils.toBytes((CharSequence)hash, (String)LedgerConstant.DEFAULT_ENCODING));
        }
        if (list.size() > 0) {
            RocksDBService.deleteKeys((String)table, list);
        }
    }

    @Override
    public void deleteAccountHash(int chainId, String hash) throws Exception {
        RocksDBService.delete((String)this.getLedgerHashTableName(chainId), (byte[])ByteUtils.toBytes((CharSequence)hash, (String)LedgerConstant.DEFAULT_ENCODING));
    }

    @Override
    public void batchDeleteAccountNonces(int chainId, List<String> noncesList) throws Exception {
        String table = this.getLedgerNonceTableName(chainId);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (String addressNonce : noncesList) {
            list.add(ByteUtils.toBytes((CharSequence)addressNonce, (String)LedgerConstant.DEFAULT_ENCODING));
        }
        if (list.size() > 0) {
            RocksDBService.deleteKeys((String)table, list);
        }
    }

    @Override
    public boolean existAccountHash(int chainId, String hash) throws Exception {
        return null != RocksDBService.get((String)this.getLedgerHashTableName(chainId), (byte[])ByteUtils.toBytes((CharSequence)hash, (String)LedgerConstant.DEFAULT_ENCODING));
    }
}

