/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.storage.impl;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.manager.RocksDBManager;
import io.nuls.core.rockdb.model.Entry;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.ledger.model.ChainHeight;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.model.po.BlockSnapshotAccounts;
import io.nuls.ledger.storage.Repository;
import io.nuls.ledger.utils.LoggerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class RepositoryImpl
implements Repository,
InitializingBean {
    @Autowired
    private NulsCoresConfig config;
    Map<String, Map<String, AccountState>> memChainsAccounts = new ConcurrentHashMap<String, Map<String, AccountState>>(16);

    @Override
    public void batchUpdateAccountState(int addressChainId, Map<byte[], byte[]> accountStateMap, Map<String, AccountState> accountStateMemMap) throws Exception {
        if (null == this.memChainsAccounts.get(String.valueOf(addressChainId))) {
            this.memChainsAccounts.put(String.valueOf(addressChainId), new ConcurrentHashMap(1024));
        }
        if (null != accountStateMemMap) {
            this.memChainsAccounts.get(String.valueOf(addressChainId)).putAll(accountStateMemMap);
        }
        RocksDBService.batchPut((String)this.getLedgerAccountTableName(addressChainId), accountStateMap);
    }

    @Override
    public void clearAccountStateMem(int addressChainId, Map<String, AccountState> accountStateMemMap) throws Exception {
        if (null == this.memChainsAccounts.get(String.valueOf(addressChainId))) {
            this.memChainsAccounts.put(String.valueOf(addressChainId), new ConcurrentHashMap(1024));
        }
        if (null != accountStateMemMap) {
            this.memChainsAccounts.get(String.valueOf(addressChainId)).putAll(accountStateMemMap);
        }
    }

    @Override
    public void delBlockSnapshot(int chainId, long height) throws Exception {
        RocksDBService.delete((String)this.getBlockSnapshotTableName(chainId), (byte[])ByteUtils.longToBytes((long)height));
    }

    @Override
    public void saveBlockSnapshot(int chainId, long height, BlockSnapshotAccounts blockSnapshotAccounts) throws Exception {
        RocksDBService.put((String)this.getBlockSnapshotTableName(chainId), (byte[])ByteUtils.longToBytes((long)height), (byte[])blockSnapshotAccounts.serialize());
    }

    @Override
    public BlockSnapshotAccounts getBlockSnapshot(int chainId, long height) {
        byte[] stream = RocksDBService.get((String)this.getBlockSnapshotTableName(chainId), (byte[])ByteUtils.longToBytes((long)height));
        if (stream == null) {
            return null;
        }
        BlockSnapshotAccounts blockSnapshotAccounts = new BlockSnapshotAccounts();
        try {
            blockSnapshotAccounts.parse(new NulsByteBuffer(stream));
        }
        catch (NulsException e) {
            LoggerUtil.logger(chainId).error("getAccountState serialize error.", (Exception)((Object)e));
        }
        return blockSnapshotAccounts;
    }

    @Override
    public AccountState getAccountState(int chainId, byte[] key) {
        byte[] stream = RocksDBService.get((String)this.getLedgerAccountTableName(chainId), (byte[])key);
        if (stream == null) {
            return null;
        }
        AccountState accountState = new AccountState();
        try {
            accountState.parse(new NulsByteBuffer(stream));
        }
        catch (NulsException e) {
            LoggerUtil.logger(chainId).error("getAccountState serialize error.", (Exception)((Object)e));
        }
        return accountState;
    }

    @Override
    public AccountState getAccountStateByMemory(int chainId, String key) {
        AccountState accountStateMem;
        if (null != this.memChainsAccounts.get(String.valueOf(chainId)) && null != (accountStateMem = this.memChainsAccounts.get(String.valueOf(chainId)).get(key))) {
            AccountState accountState = new AccountState();
            System.arraycopy(accountStateMem.getNonce(), 0, accountState.getNonce(), 0, accountStateMem.getNonce().length);
            accountState.setTotalFromAmount(accountStateMem.getTotalFromAmount());
            accountState.setTotalToAmount(accountStateMem.getTotalToAmount());
            accountState.setLatestUnFreezeTime(accountStateMem.getLatestUnFreezeTime());
            accountState.getFreezeHeightStates().addAll(accountStateMem.getFreezeHeightStates());
            accountState.getFreezeLockTimeStates().addAll(accountStateMem.getFreezeLockTimeStates());
            return accountState;
        }
        return null;
    }

    @Override
    public long getBlockHeight(int chainId) {
        byte[] stream = RocksDBService.get((String)this.getChainsHeightTableName(), (byte[])ByteUtils.intToBytes((int)chainId));
        if (stream == null) {
            return -1L;
        }
        try {
            long height = ByteUtils.byteToLong((byte[])stream);
            return height;
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error("getBlockHeight serialize error.", e);
            return -1L;
        }
    }

    @Override
    public void saveOrUpdateBlockHeight(int chainId, long height) {
        try {
            RocksDBService.put((String)this.getChainsHeightTableName(), (byte[])ByteUtils.intToBytes((int)chainId), (byte[])ByteUtils.longToBytes((long)height));
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error("saveBlockHeight serialize error.", e);
        }
    }

    @Override
    public List<ChainHeight> getChainsBlockHeight() {
        List list = RocksDBService.entryList((String)this.getChainsHeightTableName());
        ArrayList<ChainHeight> rtList = new ArrayList<ChainHeight>();
        if (null == list || 0 == list.size()) {
            return null;
        }
        for (Entry entry : list) {
            ChainHeight chainHeight = new ChainHeight();
            chainHeight.setChainId(ByteUtils.bytesToInt((byte[])((byte[])entry.getKey())));
            chainHeight.setBlockHeight(ByteUtils.byteToLong((byte[])((byte[])entry.getValue())));
            rtList.add(chainHeight);
        }
        return rtList;
    }

    String getChainTableName(String tableName, int chainId) {
        return tableName + "_" + chainId;
    }

    String getLedgerAccountTableName(int chainId) {
        return this.getChainTableName("account", chainId);
    }

    String getBlockSnapshotTableName(int chainId) {
        return this.getChainTableName("account_block_snapshot", chainId);
    }

    public String getChainsHeightTableName() {
        return "chain_block_height";
    }

    public void initChainDb(int addressChainId) {
        try {
            RocksDBManager.setDataPath((String)(this.config.getDataPath() + File.separator + ModuleE.LG.name));
            if (!RocksDBService.existTable((String)this.getLedgerAccountTableName(addressChainId))) {
                RocksDBService.createTable((String)this.getLedgerAccountTableName(addressChainId));
            }
            if (!RocksDBService.existTable((String)this.getBlockSnapshotTableName(addressChainId))) {
                RocksDBService.createTable((String)this.getBlockSnapshotTableName(addressChainId));
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error(e);
        }
    }

    public void afterPropertiesSet() throws NulsException {
    }

    @Override
    public void initTableName() throws NulsException {
        try {
            RocksDBManager.setDataPath((String)(this.config.getDataPath() + File.separator + ModuleE.LG.name));
            if (!RocksDBService.existTable((String)this.getChainsHeightTableName())) {
                RocksDBService.createTable((String)this.getChainsHeightTableName());
            } else {
                Log.info((String)"table {} exist.", (Object[])new Object[]{this.getChainsHeightTableName()});
            }
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            throw new NulsException((Throwable)e);
        }
    }
}

