/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager.handler;

import io.nuls.core.rpc.model.CmdPriority;
import io.nuls.network.locker.Lockers;
import io.nuls.network.manager.StorageManager;
import io.nuls.network.manager.handler.base.BaseMeesageHandlerInf;
import io.nuls.network.manager.handler.message.OtherModuleMessageHandler;
import io.nuls.network.utils.MessageUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MessageHandlerFactory {
    private StorageManager storageManager = StorageManager.getInstance();
    private static Map<String, BaseMeesageHandlerInf> handlerMap = new HashMap<String, BaseMeesageHandlerInf>();
    private static Map<String, Map<String, CmdPriority>> protocolRoleHandlerMap = new ConcurrentHashMap<String, Map<String, CmdPriority>>();
    private static MessageHandlerFactory INSTANCE = new MessageHandlerFactory();

    public static MessageHandlerFactory getInstance() {
        return INSTANCE;
    }

    public static void addHandler(String messageCmd, BaseMeesageHandlerInf handler) {
        handlerMap.put(messageCmd, handler);
    }

    private MessageHandlerFactory() {
    }

    public BaseMeesageHandlerInf getHandler(String messageCmd) {
        return handlerMap.get(messageCmd);
    }

    public OtherModuleMessageHandler getOtherModuleHandler() {
        return OtherModuleMessageHandler.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtocolRoleHandlerMap(String protocolCmd, CmdPriority cmdPriority, String role) {
        Lockers.PROTOCOL_HANDLERS_REGISTER_LOCK.lock();
        try {
            Map<String, CmdPriority> roleMap = protocolRoleHandlerMap.get(protocolCmd);
            if (null == roleMap) {
                roleMap = new HashMap<String, CmdPriority>();
            }
            roleMap.put(role, cmdPriority);
            protocolRoleHandlerMap.put(protocolCmd, roleMap);
            MessageUtil.addCmdPriority(protocolCmd, cmdPriority);
        }
        finally {
            Lockers.PROTOCOL_HANDLERS_REGISTER_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheProtocolRoleHandlerMap(String role) {
        Lockers.PROTOCOL_HANDLERS_REGISTER_LOCK.lock();
        try {
            Collection<Map<String, CmdPriority>> values = protocolRoleHandlerMap.values();
            for (Map<String, CmdPriority> value : values) {
                value.remove(role);
            }
        }
        finally {
            Lockers.PROTOCOL_HANDLERS_REGISTER_LOCK.unlock();
        }
    }

    public Map<String, CmdPriority> getProtocolRoleHandlerMap(String protocolCmd) {
        return protocolRoleHandlerMap.get(protocolCmd);
    }
}

