/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager.handler.base;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.nuls.network.constant.NetworkErrorCode;
import io.nuls.network.manager.handler.base.BaseMeesageHandlerInf;
import io.nuls.network.model.NetworkEventResult;
import io.nuls.network.model.Node;
import io.nuls.network.model.message.base.BaseMessage;
import io.nuls.network.model.message.base.MessageHeader;
import io.nuls.network.utils.LoggerUtil;

public abstract class BaseMessageHandler
implements BaseMeesageHandlerInf {
    @Override
    public NetworkEventResult send(BaseMessage message, Node node, boolean asyn) {
        try {
            MessageHeader header = message.getHeader();
            header.setMagicNumber(header.getMagicNumber());
            Object body = message.getMsgBody();
            header.setPayloadLength(body.size());
            ChannelFuture future = node.getChannel().writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])message.serialize()));
            if (!asyn) {
                future.await();
                boolean success = future.isSuccess();
                if (!success) {
                    return NetworkEventResult.getResultFail(NetworkErrorCode.NET_MESSAGE_SEND_FAIL);
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(node.getNodeGroup().getChainId()).error(e.getMessage(), e);
            return NetworkEventResult.getResultFail(NetworkErrorCode.NET_MESSAGE_SEND_EXCEPTION);
        }
        return NetworkEventResult.getResultSuccess();
    }
}

