/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.nuls.network.netty.NulsChannelInitializer;
import io.nuls.network.netty.handler.ServerChannelHandler;
import io.nuls.network.utils.LoggerUtil;

public class NettyServer {
    private int port;
    private ServerBootstrap serverBootstrap;
    private static EventLoopGroup boss;
    private static EventLoopGroup worker;

    public NettyServer(int port) {
        this.port = port;
    }

    public void init() {
        boss = new NioEventLoopGroup(1);
        worker = new NioEventLoopGroup();
        this.serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)this.serverBootstrap.group(boss, worker).channel(NioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.SO_SNDBUF, (Object)131072).childOption(ChannelOption.SO_RCVBUF, (Object)131072).childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)AdaptiveRecvByteBufAllocator.DEFAULT).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler(new NulsChannelInitializer<ServerChannelHandler>(new ServerChannelHandler()));
    }

    public void start() throws InterruptedException {
        try {
            ChannelFuture future = this.serverBootstrap.bind(this.port).sync();
            LoggerUtil.COMMON_LOG.info("boot server:" + this.port);
            future.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            throw e;
        }
        finally {
            boss.shutdownGracefully();
            worker.shutdownGracefully();
        }
    }

    public void shutdownGracefully() {
        boss.shutdownGracefully();
        worker.shutdownGracefully();
    }
}

